/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction.order;

import java.util.Collection;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.requests.restaction.order.ChannelOrderAction;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.order.OrderActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChannelOrderActionImpl<T extends GuildChannel>
extends OrderActionImpl<T, ChannelOrderAction<T>>
implements ChannelOrderAction<T> {
    protected final Guild guild;
    protected final ChannelType type;

    public ChannelOrderActionImpl(Guild guild, ChannelType type) {
        this(guild, type, ChannelOrderActionImpl.getChannelsOfType(guild, type));
    }

    public ChannelOrderActionImpl(Guild guild, ChannelType type, Collection<T> channels) {
        super(guild.getJDA(), Route.Guilds.MODIFY_CHANNELS.compile(guild.getId()));
        Checks.notNull(channels, "Channels to order");
        Checks.notEmpty(channels, "Channels to order");
        Checks.check(channels.stream().allMatch(c -> guild.equals(c.getGuild())), "One or more channels are not from the correct guild");
        Checks.check(channels.stream().allMatch(c -> c.getType().equals((Object)type)), "One or more channels did not match the expected type of " + type.name());
        this.guild = guild;
        this.type = type;
        this.orderList.addAll(channels);
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public ChannelType getChannelType() {
        return this.type;
    }

    @Override
    protected RequestBody finalizeData() {
        Member self = this.guild.getSelfMember();
        if (!self.hasPermission(Permission.MANAGE_CHANNEL)) {
            throw new InsufficientPermissionException(Permission.MANAGE_CHANNEL);
        }
        JSONArray array = new JSONArray();
        for (int i = 0; i < this.orderList.size(); ++i) {
            GuildChannel chan = (GuildChannel)this.orderList.get(i);
            array.put((Object)new JSONObject().put("id", (Object)chan.getId()).put("position", i));
        }
        return this.getRequestBody(array);
    }

    @Override
    protected void validateInput(T entity) {
        Checks.check(entity.getGuild().equals(this.guild), "Provided channel is not from this Guild!");
        Checks.check(this.orderList.contains(entity), "Provided channel is not in the list of orderable channels!");
    }

    private static Collection<? extends GuildChannel> getChannelsOfType(Guild guild, ChannelType type) {
        switch (type) {
            case TEXT: {
                return guild.getTextChannels();
            }
            case VOICE: {
                return guild.getVoiceChannels();
            }
            case CATEGORY: {
                return guild.getCategories();
            }
        }
        throw new IllegalArgumentException("Cannot order specified channel type " + (Object)((Object)type));
    }
}

