/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction.order;

import java.util.Collection;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.requests.restaction.order.CategoryOrderAction;
import net.dv8tion.jda.internal.requests.restaction.order.ChannelOrderActionImpl;
import net.dv8tion.jda.internal.utils.Checks;

public class CategoryOrderActionImpl<T extends GuildChannel>
extends ChannelOrderActionImpl<T>
implements CategoryOrderAction<T> {
    protected final Category category;

    public CategoryOrderActionImpl(Category category, ChannelType type) {
        super(category.getGuild(), type, CategoryOrderActionImpl.getChannelsOfType(category, type));
        this.category = category;
    }

    @Override
    @Nonnull
    public Category getCategory() {
        return this.category;
    }

    @Override
    protected void validateInput(T entity) {
        Checks.notNull(entity, "Provided channel");
        Checks.check(this.getCategory().equals(entity.getParent()), "Provided channel's Category is not this Category!");
        Checks.check(this.orderList.contains(entity), "Provided channel is not in the list of orderable channels!");
    }

    @Nonnull
    private static Collection<? extends GuildChannel> getChannelsOfType(Category category, ChannelType type) {
        Checks.notNull((Object)type, "ChannelType");
        Checks.notNull(category, "Category");
        switch (type) {
            case TEXT: {
                return category.getTextChannels();
            }
            case VOICE: {
                return category.getVoiceChannels();
            }
        }
        throw new IllegalArgumentException("Cannot order category with specified channel type " + (Object)((Object)type));
    }
}

