/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.managers;

import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.managers.DirectAudioController;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;

public class DirectAudioControllerImpl
implements DirectAudioController {
    private final UpstreamReference<JDAImpl> api;

    public DirectAudioControllerImpl(JDAImpl api) {
        this.api = new UpstreamReference<JDAImpl>(api);
    }

    @Override
    public JDAImpl getJDA() {
        return this.api.get();
    }

    @Override
    public void connect(VoiceChannel channel) {
        Checks.notNull(channel, "Voice Channel");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.queueAudioConnect(channel);
    }

    @Override
    public void disconnect(Guild guild) {
        Checks.notNull(guild, "Guild");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.queueAudioDisconnect(guild);
    }

    @Override
    public void reconnect(VoiceChannel channel) {
        Checks.notNull(channel, "Voice Channel");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.queueAudioReconnect(channel);
    }

    public void update(Guild guild, VoiceChannel channel) {
        Checks.notNull(guild, "Guild");
        JDAImpl jda = this.getJDA();
        WebSocketClient client = jda.getClient();
        client.updateAudioConnection(guild.getIdLong(), channel);
    }
}

