/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.managers;

import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.SelfUser;
import net.dv8tion.jda.api.managers.AccountManager;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.managers.ManagerBase;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class AccountManagerImpl
extends ManagerBase<AccountManager>
implements AccountManager {
    protected final UpstreamReference<SelfUser> selfUser;
    protected String currentPassword;
    protected String name;
    protected Icon avatar;
    protected String email;
    protected String password;

    public AccountManagerImpl(SelfUser selfUser) {
        super(selfUser.getJDA(), Route.Self.MODIFY_SELF.compile(new String[0]));
        this.selfUser = new UpstreamReference<SelfUser>(selfUser);
    }

    @Override
    public SelfUser getSelfUser() {
        return this.selfUser.get();
    }

    @Override
    @CheckReturnValue
    public AccountManagerImpl reset(long fields) {
        super.reset(fields);
        if ((fields & 2L) == 2L) {
            this.avatar = null;
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public AccountManagerImpl reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public AccountManagerImpl reset() {
        super.reset();
        this.avatar = null;
        return this;
    }

    @Override
    @CheckReturnValue
    public AccountManagerImpl setName(String name, String currentPassword) {
        Checks.notBlank(name, "Name");
        Checks.check(name.length() >= 2 && name.length() <= 32, "Name must be between 2-32 characters long");
        this.currentPassword = currentPassword;
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @Override
    @CheckReturnValue
    public AccountManagerImpl setAvatar(Icon avatar, String currentPassword) {
        this.currentPassword = currentPassword;
        this.avatar = avatar;
        this.set |= 2L;
        return this;
    }

    @Override
    @CheckReturnValue
    public AccountManagerImpl setEmail(String email, String currentPassword) {
        Checks.notNull(email, "email");
        this.currentPassword = currentPassword;
        this.email = email;
        this.set |= 4L;
        return this;
    }

    @Override
    @CheckReturnValue
    public AccountManagerImpl setPassword(String newPassword, String currentPassword) {
        Checks.notNull(newPassword, "password");
        Checks.check(newPassword.length() >= 6 && newPassword.length() <= 128, "Password must be between 2-128 characters long");
        this.currentPassword = currentPassword;
        this.password = newPassword;
        this.set |= 8L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        boolean isClient = this.getJDA().getAccountType() == AccountType.CLIENT;
        Checks.check(!isClient || this.currentPassword != null && !this.currentPassword.isEmpty(), "Provided client account password to be used in auth is null or empty!");
        JSONObject body = new JSONObject();
        body.put("username", (Object)this.getSelfUser().getName());
        body.put("avatar", this.opt(this.getSelfUser().getAvatarId()));
        if (this.shouldUpdate(1L)) {
            body.put("username", (Object)this.name);
        }
        if (this.shouldUpdate(2L)) {
            body.put("avatar", this.avatar == null ? JSONObject.NULL : this.avatar.getEncoding());
        }
        if (isClient) {
            body.put("password", (Object)this.currentPassword);
            body.put("email", (Object)this.email);
            if (this.shouldUpdate(4L)) {
                body.put("email", (Object)this.email);
            }
            if (this.shouldUpdate(8L)) {
                body.put("new_password", (Object)this.password);
            }
        }
        this.reset();
        return this.getRequestBody(body);
    }

    @Override
    protected void handleSuccess(Response response, Request<Void> request) {
        String newToken = response.getObject().getString("token").replace("Bot ", "");
        ((JDAImpl)this.api.get()).setToken(newToken);
        request.onSuccess(null);
    }
}

