/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.events.user.UserActivityEndEvent;
import net.dv8tion.jda.api.events.user.UserActivityStartEvent;
import net.dv8tion.jda.api.events.user.update.UserUpdateActivityOrderEvent;
import net.dv8tion.jda.api.events.user.update.UserUpdateAvatarEvent;
import net.dv8tion.jda.api.events.user.update.UserUpdateDiscriminatorEvent;
import net.dv8tion.jda.api.events.user.update.UserUpdateNameEvent;
import net.dv8tion.jda.api.events.user.update.UserUpdateOnlineStatusEvent;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.MemberImpl;
import net.dv8tion.jda.internal.entities.UserImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.utils.Helpers;
import org.json.JSONArray;
import org.json.JSONObject;

public class PresenceUpdateHandler
extends SocketHandler {
    public PresenceUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        GuildImpl guild = null;
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
            guild = (GuildImpl)this.getJDA().getGuildById(guildId);
            if (guild == null) {
                this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
                EventCache.LOG.debug("Received a PRESENCE_UPDATE for a guild that is not yet cached! GuildId: " + guildId + " UserId: " + content.getJSONObject("user").get("id"));
                return null;
            }
        }
        JSONObject jsonUser = content.getJSONObject("user");
        long userId = jsonUser.getLong("id");
        UserImpl user = (UserImpl)this.getJDA().getUsersView().get(userId);
        if (user != null) {
            if (jsonUser.has("username")) {
                String name = jsonUser.getString("username");
                String discriminator = jsonUser.get("discriminator").toString();
                String avatarId = jsonUser.optString("avatar", null);
                String oldAvatar = user.getAvatarId();
                if (!user.getName().equals(name)) {
                    String oldUsername = user.getName();
                    user.setName(name);
                    this.getJDA().getEventManager().handle(new UserUpdateNameEvent(this.getJDA(), this.responseNumber, user, oldUsername));
                }
                if (!user.getDiscriminator().equals(discriminator)) {
                    String oldDiscriminator = user.getDiscriminator();
                    user.setDiscriminator(discriminator);
                    this.getJDA().getEventManager().handle(new UserUpdateDiscriminatorEvent(this.getJDA(), this.responseNumber, user, oldDiscriminator));
                }
                if (!Objects.equals(avatarId, oldAvatar)) {
                    String oldAvatarId = user.getAvatarId();
                    user.setAvatarId(avatarId);
                    this.getJDA().getEventManager().handle(new UserUpdateAvatarEvent(this.getJDA(), this.responseNumber, user, oldAvatarId));
                }
            }
            JSONArray activityArray = !this.getJDA().isCacheFlagSet(CacheFlag.PRESENCE) || content.isNull("activities") ? null : content.getJSONArray("activities");
            ArrayList<Activity> newActivities = new ArrayList<Activity>();
            boolean parsedGame = false;
            try {
                if (activityArray != null) {
                    for (int i = 0; i < activityArray.length(); ++i) {
                        newActivities.add(EntityBuilder.createAcitvity(activityArray.getJSONObject(i)));
                    }
                    parsedGame = true;
                }
            }
            catch (Exception ex) {
                if (EntityBuilder.LOG.isDebugEnabled()) {
                    EntityBuilder.LOG.warn("Encountered exception trying to parse a presence! UserID: {} JSON: {}", new Object[]{userId, activityArray, ex});
                }
                EntityBuilder.LOG.warn("Encountered exception trying to parse a presence! UserID: {} Message: {} Enable debug for details", (Object)userId, (Object)ex.getMessage());
            }
            OnlineStatus status = OnlineStatus.fromKey(content.getString("status"));
            if (guild != null) {
                MemberImpl member = (MemberImpl)guild.getMember(user);
                if (member == null) {
                    if (status != OnlineStatus.OFFLINE) {
                        guild.getCachedPresenceMap().put(userId, (Object)content);
                        return null;
                    }
                } else {
                    if (!member.getOnlineStatus().equals((Object)status)) {
                        OnlineStatus oldStatus = member.getOnlineStatus();
                        member.setOnlineStatus(status);
                        this.getJDA().getEventManager().handle(new UserUpdateOnlineStatusEvent(this.getJDA(), this.responseNumber, user, guild, oldStatus));
                    }
                    if (parsedGame) {
                        List<Activity> oldActivities = member.getActivities();
                        boolean unorderedEquals = Helpers.deepEqualsUnordered(oldActivities, newActivities);
                        if (unorderedEquals) {
                            boolean deepEquals = Helpers.deepEquals(oldActivities, newActivities);
                            if (!deepEquals) {
                                member.setActivities(newActivities);
                                this.getJDA().getEventManager().handle(new UserUpdateActivityOrderEvent(this.getJDA(), this.responseNumber, oldActivities, member));
                            }
                        } else {
                            member.setActivities(newActivities);
                            oldActivities = new ArrayList<Activity>(oldActivities);
                            ArrayList<Activity> startedActivities = new ArrayList<Activity>();
                            for (Activity activity : newActivities) {
                                if (oldActivities.remove(activity)) continue;
                                startedActivities.add(activity);
                            }
                            for (Activity activity : startedActivities) {
                                this.getJDA().getEventManager().handle(new UserActivityStartEvent(this.getJDA(), this.responseNumber, member, activity));
                            }
                            for (Activity activity : oldActivities) {
                                this.getJDA().getEventManager().handle(new UserActivityEndEvent(this.getJDA(), this.responseNumber, member, activity));
                            }
                        }
                    }
                }
            }
        } else {
            OnlineStatus status = OnlineStatus.fromKey(content.getString("status"));
            if (status != OnlineStatus.OFFLINE && guild != null) {
                guild.getCachedPresenceMap().put(userId, (Object)content);
            }
        }
        return null;
    }
}

