/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class GuildMembersChunkHandler
extends SocketHandler {
    public GuildMembersChunkHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long guildId = content.getLong("guild_id");
        JSONArray members = content.getJSONArray("members");
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        if (guild != null) {
            WebSocketClient.LOG.debug("Received member chunk for guild that is already in cache. GuildId: {} Count: {}", (Object)guildId, (Object)members.length());
            EntityBuilder builder = this.getJDA().getEntityBuilder();
            for (int i = 0; i < members.length(); ++i) {
                JSONObject object = members.getJSONObject(i);
                builder.createMember(guild, object);
            }
        }
        this.getJDA().getGuildSetupController().onMemberChunk(guildId, members);
        return null;
    }
}

