/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.events.guild.member.GuildMemberLeaveEvent;
import net.dv8tion.jda.api.events.guild.voice.GuildVoiceLeaveEvent;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.GuildVoiceStateImpl;
import net.dv8tion.jda.internal.entities.MemberImpl;
import net.dv8tion.jda.internal.entities.PrivateChannelImpl;
import net.dv8tion.jda.internal.entities.UserImpl;
import net.dv8tion.jda.internal.entities.VoiceChannelImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import net.dv8tion.jda.internal.utils.UnlockHook;
import net.dv8tion.jda.internal.utils.cache.SnowflakeCacheViewImpl;
import org.json.JSONObject;

public class GuildMemberRemoveHandler
extends SocketHandler {
    public GuildMemberRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("guild_id");
        boolean setup = this.getJDA().getGuildSetupController().onRemoveMember(id, content);
        if (setup) {
            return null;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildsView().get(id);
        if (guild == null) {
            return null;
        }
        long userId = content.getJSONObject("user").getLong("id");
        if (userId == this.getJDA().getSelfUser().getIdLong()) {
            return null;
        }
        MemberImpl member = (MemberImpl)guild.getMembersView().remove(userId);
        if (member == null) {
            WebSocketClient.LOG.debug("Received GUILD_MEMBER_REMOVE for a Member that does not exist in the specified Guild.");
            return null;
        }
        GuildVoiceStateImpl voiceState = (GuildVoiceStateImpl)member.getVoiceState();
        if (voiceState != null && voiceState.inVoiceChannel()) {
            VoiceChannel channel = voiceState.getChannel();
            voiceState.setConnectedChannel(null);
            ((VoiceChannelImpl)channel).getConnectedMembersMap().remove(member.getUser().getIdLong());
            this.getJDA().getEventManager().handle(new GuildVoiceLeaveEvent(this.getJDA(), this.responseNumber, member, channel));
        }
        SnowflakeCacheViewImpl<User> userView = this.getJDA().getUsersView();
        try (UnlockHook hook = userView.writeLock();){
            if (userId != this.getJDA().getSelfUser().getIdLong()) {
                if (this.getJDA().getGuildsView().stream().map(GuildImpl.class::cast).noneMatch(g -> g.getMembersView().get(userId) != null)) {
                    UserImpl user = (UserImpl)userView.getMap().remove(userId);
                    if (user.hasPrivateChannel()) {
                        PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                        user.setFake(true);
                        priv.setFake(true);
                        this.getJDA().getFakeUserMap().put(user.getIdLong(), (Object)user);
                        this.getJDA().getFakePrivateChannelMap().put(priv.getIdLong(), (Object)priv);
                    }
                    this.getJDA().getEventCache().clear(EventCache.Type.USER, userId);
                }
            }
        }
        this.getJDA().getEventManager().handle(new GuildMemberLeaveEvent((JDA)this.getJDA(), this.responseNumber, member));
        return null;
    }
}

