/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import gnu.trove.TLongCollection;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.set.TLongSet;
import net.dv8tion.jda.api.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.api.events.guild.GuildUnavailableEvent;
import net.dv8tion.jda.api.managers.AudioManager;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.PrivateChannelImpl;
import net.dv8tion.jda.internal.entities.UserImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.managers.AudioManagerImpl;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import net.dv8tion.jda.internal.utils.Helpers;
import net.dv8tion.jda.internal.utils.UnlockHook;
import net.dv8tion.jda.internal.utils.cache.AbstractCacheView;
import net.dv8tion.jda.internal.utils.cache.SnowflakeCacheViewImpl;
import org.json.JSONObject;

public class GuildDeleteHandler
extends SocketHandler {
    public GuildDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("id");
        boolean wasInit = this.getJDA().getGuildSetupController().onDelete(id, content);
        if (wasInit) {
            return null;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(id);
        boolean unavailable = Helpers.optBoolean(content, "unavailable");
        if (guild == null) {
            WebSocketClient.LOG.debug("Received GUILD_DELETE for a Guild that is not currently cached. ID: {} unavailable: {}", (Object)id, (Object)unavailable);
            return null;
        }
        if (!guild.isAvailable() && unavailable) {
            return null;
        }
        if (unavailable) {
            guild.setAvailable(false);
            this.getJDA().getEventManager().handle(new GuildUnavailableEvent(this.getJDA(), this.responseNumber, guild));
            return null;
        }
        SnowflakeCacheViewImpl<Guild> guildView = this.getJDA().getGuildsView();
        SnowflakeCacheViewImpl<TextChannel> textView = this.getJDA().getTextChannelsView();
        SnowflakeCacheViewImpl<VoiceChannel> voiceView = this.getJDA().getVoiceChannelsView();
        SnowflakeCacheViewImpl<Category> categoryView = this.getJDA().getCategoriesView();
        guildView.remove(id);
        try (UnlockHook hook = textView.writeLock();){
            guild.getTextChannelCache().forEach(chan -> textView.getMap().remove(chan.getIdLong()));
        }
        hook = voiceView.writeLock();
        try {
            guild.getVoiceChannelCache().forEach(chan -> voiceView.getMap().remove(chan.getIdLong()));
        }
        finally {
            if (hook != null) {
                hook.close();
            }
        }
        hook = categoryView.writeLock();
        try {
            guild.getCategoryCache().forEach(chan -> categoryView.getMap().remove(chan.getIdLong()));
        }
        finally {
            if (hook != null) {
                hook.close();
            }
        }
        this.getJDA().getClient().removeAudioConnection(id);
        AbstractCacheView<AudioManager> audioManagerView = this.getJDA().getAudioManagersView();
        try (UnlockHook hook = audioManagerView.writeLock();){
            TLongObjectMap<AudioManager> audioManagerMap = audioManagerView.getMap();
            AudioManagerImpl manager = (AudioManagerImpl)audioManagerMap.get(id);
            if (manager != null) {
                MiscUtil.locked(manager.CONNECTION_LOCK, () -> {
                    if (manager.isConnected() || manager.isAttemptingToConnect()) {
                        manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD);
                    } else {
                        audioManagerMap.remove(id);
                    }
                });
            }
        }
        TLongSet memberIds = guild.getMembersView().keySet();
        this.getJDA().getGuildCache().stream().map(GuildImpl.class::cast).forEach(g -> memberIds.removeAll((TLongCollection)g.getMembersView().keySet()));
        SnowflakeCacheViewImpl<User> userView = this.getJDA().getUsersView();
        try (UnlockHook hook = userView.writeLock();){
            long selfId = this.getJDA().getSelfUser().getIdLong();
            memberIds.forEach(memberId -> {
                if (memberId == selfId) {
                    return true;
                }
                UserImpl user = (UserImpl)userView.getMap().remove(memberId);
                if (user.hasPrivateChannel()) {
                    PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                    user.setFake(true);
                    priv.setFake(true);
                    this.getJDA().getFakeUserMap().put(user.getIdLong(), (Object)user);
                    this.getJDA().getFakePrivateChannelMap().put(priv.getIdLong(), (Object)priv);
                }
                this.getJDA().getEventCache().clear(EventCache.Type.USER, memberId);
                return true;
            });
        }
        this.getJDA().getEventManager().handle(new GuildLeaveEvent(this.getJDA(), this.responseNumber, guild));
        this.getJDA().getEventCache().clear(EventCache.Type.GUILD, id);
        return null;
    }
}

