/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.events.guild.GuildBanEvent;
import net.dv8tion.jda.api.events.guild.GuildUnbanEvent;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.UserImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.utils.JDALogger;
import org.json.JSONObject;

public class GuildBanHandler
extends SocketHandler {
    private final boolean banned;

    public GuildBanHandler(JDAImpl api, boolean banned) {
        super(api);
        this.banned = banned;
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(id)) {
            return id;
        }
        JSONObject userJson = content.getJSONObject("user");
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(id);
        if (guild == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, id, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received Guild Member {} event for a Guild not yet cached.", JDALogger.getLazyString(() -> this.banned ? "Ban" : "Unban"));
            return null;
        }
        UserImpl user = this.getJDA().getEntityBuilder().createFakeUser(userJson, false);
        if (this.banned) {
            this.getJDA().getEventManager().handle(new GuildBanEvent(this.getJDA(), this.responseNumber, guild, user));
        } else {
            this.getJDA().getEventManager().handle(new GuildUnbanEvent(this.getJDA(), this.responseNumber, guild, user));
        }
        return null;
    }
}

