/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.VerificationLevelException;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.requests.restaction.WebhookAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.api.utils.TimeUtil;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.AbstractChannelImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.WebhookImpl;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.WebhookActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextChannelImpl
extends AbstractChannelImpl<TextChannel, TextChannelImpl>
implements TextChannel {
    private String topic;
    private long lastMessageId;
    private boolean nsfw;
    private int slowmode;

    public TextChannelImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    public String getAsMention() {
        return "<#" + this.id + '>';
    }

    @Override
    public RestAction<List<Webhook>> retrieveWebhooks() {
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Channels.GET_WEBHOOKS.compile(this.getId());
        JDAImpl jda = (JDAImpl)this.getJDA();
        return new RestActionImpl<List<Webhook>>((JDA)jda, route, (response, request) -> {
            JSONArray array = response.getArray();
            ArrayList<WebhookImpl> webhooks = new ArrayList<WebhookImpl>(array.length());
            EntityBuilder builder = jda.getEntityBuilder();
            for (Object object : array) {
                try {
                    webhooks.add(builder.createWebhook((JSONObject)object));
                }
                catch (NullPointerException | JSONException e) {
                    JDAImpl.LOG.error("Error while creating websocket from json", e);
                }
            }
            return Collections.unmodifiableList(webhooks);
        });
    }

    @Override
    public WebhookAction createWebhook(String name) {
        Checks.notBlank(name, "Webhook name");
        name = name.trim();
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Checks.check(name.length() >= 2 && name.length() <= 100, "Name must be 2-100 characters in length!");
        return new WebhookActionImpl(this.getJDA(), this, name);
    }

    @Override
    public RestAction<Void> deleteMessages(Collection<Message> messages) {
        Checks.notEmpty(messages, "Messages collection");
        return this.deleteMessagesByIds(messages.stream().map(ISnowflake::getId).collect(Collectors.toList()));
    }

    @Override
    public RestAction<Void> deleteMessagesByIds(Collection<String> messageIds) {
        this.checkPermission(Permission.MESSAGE_MANAGE, "Must have MESSAGE_MANAGE in order to bulk delete messages in this channel regardless of author.");
        if (messageIds.size() < 2 || messageIds.size() > 100) {
            throw new IllegalArgumentException("Must provide at least 2 or at most 100 messages to be deleted.");
        }
        long twoWeeksAgo = TimeUtil.getDiscordTimestamp(System.currentTimeMillis() - 1209600000L);
        for (String id : messageIds) {
            Checks.check(MiscUtil.parseSnowflake(id) > twoWeeksAgo, "Message Id provided was older than 2 weeks. Id: " + id);
        }
        return this.deleteMessages0(messageIds);
    }

    @Override
    public AuditableRestAction<Void> deleteWebhookById(String id) {
        Checks.isSnowflake(id, "Webhook ID");
        if (!this.getGuild().getSelfMember().hasPermission((GuildChannel)this, Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_WEBHOOKS);
        }
        Route.CompiledRoute route = Route.Webhooks.DELETE_WEBHOOK.compile(id);
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    public boolean canTalk() {
        return this.canTalk(this.getGuild().getSelfMember());
    }

    @Override
    public boolean canTalk(Member member) {
        if (!this.getGuild().equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided Member is not from the Guild that this TextChannel is part of.");
        }
        return member.hasPermission((GuildChannel)this, Permission.MESSAGE_READ, Permission.MESSAGE_WRITE);
    }

    @Override
    public List<CompletableFuture<Void>> purgeMessages(List<? extends Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return Collections.emptyList();
        }
        boolean hasPerms = this.getGuild().getSelfMember().hasPermission((GuildChannel)this, Permission.MESSAGE_MANAGE);
        if (!hasPerms) {
            for (Message message : messages) {
                if (message.getAuthor().equals(this.getJDA().getSelfUser())) continue;
                throw new InsufficientPermissionException(Permission.MESSAGE_MANAGE, "Cannot delete messages of other users");
            }
        }
        return TextChannel.super.purgeMessages(messages);
    }

    @Override
    public List<CompletableFuture<Void>> purgeMessagesById(long ... messageIds) {
        if (messageIds == null || messageIds.length == 0) {
            return Collections.emptyList();
        }
        if (this.getJDA().getAccountType() != AccountType.BOT || !this.getGuild().getSelfMember().hasPermission((GuildChannel)this, Permission.MESSAGE_MANAGE)) {
            return TextChannel.super.purgeMessagesById(messageIds);
        }
        LinkedList<CompletableFuture<Void>> list = new LinkedList<CompletableFuture<Void>>();
        TreeSet bulk = new TreeSet(Comparator.reverseOrder());
        TreeSet norm = new TreeSet(Comparator.reverseOrder());
        long twoWeeksAgo = TimeUtil.getDiscordTimestamp(System.currentTimeMillis() - 1209600000L + 10000L);
        for (long messageId : messageIds) {
            if (messageId > twoWeeksAgo) {
                bulk.add(messageId);
                continue;
            }
            norm.add(messageId);
        }
        if (!bulk.isEmpty()) {
            ArrayList<String> toDelete = new ArrayList<String>(100);
            while (!bulk.isEmpty()) {
                toDelete.clear();
                for (int i = 0; i < 100 && !bulk.isEmpty(); ++i) {
                    toDelete.add(Long.toUnsignedString((Long)bulk.pollLast()));
                }
                if (toDelete.size() == 1) {
                    list.add(this.deleteMessageById((String)toDelete.get(0)).submit());
                    continue;
                }
                if (toDelete.isEmpty()) continue;
                list.add(this.deleteMessages0(toDelete).submit());
            }
        }
        if (!norm.isEmpty()) {
            Object object = norm.iterator();
            while (object.hasNext()) {
                long message = (Long)object.next();
                list.add(this.deleteMessageById(message).submit());
            }
        }
        return list;
    }

    @Override
    public long getLatestMessageIdLong() {
        long messageId = this.lastMessageId;
        if (messageId == 0L) {
            throw new IllegalStateException("No last message id found.");
        }
        return messageId;
    }

    @Override
    public boolean hasLatestMessage() {
        return this.lastMessageId != 0L;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.TEXT;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public boolean isNSFW() {
        return this.nsfw || this.name.equals("nsfw") || this.name.startsWith("nsfw-");
    }

    @Override
    public int getSlowmode() {
        return this.slowmode;
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(this.getGuild().getMembersView().stream().filter(m -> m.hasPermission((GuildChannel)this, Permission.MESSAGE_READ)).collect(Collectors.toList()));
    }

    @Override
    public int getPosition() {
        List<TextChannel> channels = this.getGuild().getTextChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new AssertionError((Object)"Somehow when determining position we never found the TextChannel in the Guild's channels? wtf?");
    }

    @Override
    public ChannelAction<TextChannel> createCopy(Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<TextChannel> action = guild.getController().createTextChannel(this.name).setNSFW(this.nsfw).setTopic(this.topic).setSlowmode(this.slowmode);
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParent();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.overrides.valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addPermissionOverride((IPermissionHolder)o.getMember(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addPermissionOverride((IPermissionHolder)o.getRole(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }

    @Override
    public MessageAction sendMessage(CharSequence text) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        return TextChannel.super.sendMessage(text);
    }

    @Override
    public MessageAction sendMessage(MessageEmbed embed) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        return TextChannel.super.sendMessage(embed);
    }

    @Override
    public MessageAction sendMessage(Message msg) {
        Checks.notNull(msg, "Message");
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        if (msg.getContentRaw().isEmpty() && !msg.getEmbeds().isEmpty()) {
            this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        }
        return TextChannel.super.sendMessage(msg);
    }

    @Override
    public MessageAction sendFile(InputStream data, String fileName, Message message) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        return TextChannel.super.sendFile(data, fileName, message);
    }

    @Override
    public RestAction<Message> retrieveMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.retrieveMessageById(messageId);
    }

    @Override
    public AuditableRestAction<Void> deleteMessageById(String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        this.checkPermission(Permission.MESSAGE_READ);
        return TextChannel.super.deleteMessageById(messageId);
    }

    @Override
    public RestAction<Void> pinMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ, "You cannot pin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        return TextChannel.super.pinMessageById(messageId);
    }

    @Override
    public RestAction<Void> unpinMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ, "You cannot unpin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        return TextChannel.super.unpinMessageById(messageId);
    }

    @Override
    public RestAction<List<Message>> retrievePinnedMessages() {
        this.checkPermission(Permission.MESSAGE_READ, "Cannot get the pinned message of a channel without MESSAGE_READ access.");
        return TextChannel.super.retrievePinnedMessages();
    }

    @Override
    public RestAction<Void> addReactionById(String messageId, String unicode) {
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.addReactionById(messageId, unicode);
    }

    @Override
    public RestAction<Void> addReactionById(String messageId, Emote emote) {
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.addReactionById(messageId, emote);
    }

    @Override
    public RestAction<Void> clearReactionsById(String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        this.checkPermission(Permission.MESSAGE_MANAGE);
        Route.CompiledRoute route = Route.Messages.REMOVE_ALL_REACTIONS.compile(this.getId(), messageId);
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    public RestActionImpl<Void> removeReactionById(String messageId, String unicode, User user) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.noWhitespace(unicode, "Unicode emoji");
        Checks.notNull(user, "User");
        if (!this.getJDA().getSelfUser().equals(user)) {
            this.checkPermission(Permission.MESSAGE_MANAGE);
        }
        String code = MiscUtil.encodeUTF8(unicode);
        Route.CompiledRoute route = user.equals(this.getJDA().getSelfUser()) ? Route.Messages.REMOVE_REACTION.compile(this.getId(), messageId, code, "@me") : Route.Messages.REMOVE_REACTION.compile(this.getId(), messageId, code, user.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    public MessageAction editMessageById(String messageId, CharSequence newContent) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        return TextChannel.super.editMessageById(messageId, newContent);
    }

    @Override
    public MessageAction editMessageById(String messageId, MessageEmbed newEmbed) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        return TextChannel.super.editMessageById(messageId, newEmbed);
    }

    @Override
    public MessageAction editMessageById(String id, Message newContent) {
        Checks.notNull(newContent, "Message");
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        if (newContent.getContentRaw().isEmpty() && !newContent.getEmbeds().isEmpty()) {
            this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        }
        return TextChannel.super.editMessageById(id, newContent);
    }

    public String toString() {
        return "TC:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public int compareTo(TextChannel chan) {
        Checks.notNull(chan, "Other TextChannel");
        if (this == chan) {
            return 0;
        }
        Checks.check(this.getGuild().equals(chan.getGuild()), "Cannot compare TextChannels that aren't from the same guild!");
        if (this.getPositionRaw() == chan.getPositionRaw()) {
            return Long.compare(this.id, chan.getIdLong());
        }
        return Integer.compare(this.rawPosition, chan.getPositionRaw());
    }

    public TextChannelImpl setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public TextChannelImpl setLastMessageId(long id) {
        this.lastMessageId = id;
        return this;
    }

    public TextChannelImpl setNSFW(boolean nsfw) {
        this.nsfw = nsfw;
        return this;
    }

    public TextChannelImpl setSlowmode(int slowmode) {
        this.slowmode = slowmode;
        return this;
    }

    private RestActionImpl<Void> deleteMessages0(Collection<String> messageIds) {
        JSONObject body = new JSONObject().put("messages", messageIds);
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGES.compile(this.getId());
        return new RestActionImpl<Void>(this.getJDA(), route, body);
    }

    private void checkVerification() {
        if (!this.getGuild().checkVerification()) {
            throw new VerificationLevelException(this.getGuild().getVerificationLevel());
        }
    }
}

