/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.awt.Color;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.GuildVoiceStateImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.PermissionUtil;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;

public class MemberImpl
implements Member {
    private static final ZoneOffset OFFSET = ZoneOffset.of("+00:00");
    private final UpstreamReference<GuildImpl> guild;
    private final User user;
    private final Set<Role> roles = ConcurrentHashMap.newKeySet();
    private final GuildVoiceState voiceState;
    private String nickname;
    private long joinDate;
    private List<Activity> activities = null;
    private OnlineStatus onlineStatus = OnlineStatus.OFFLINE;

    public MemberImpl(GuildImpl guild, User user) {
        this.guild = new UpstreamReference<GuildImpl>(guild);
        this.user = user;
        JDAImpl jda = (JDAImpl)this.getJDA();
        boolean cacheState = jda.isCacheFlagSet(CacheFlag.VOICE_STATE) || user.equals(jda.getSelfUser());
        this.voiceState = cacheState ? new GuildVoiceStateImpl(this) : null;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public GuildImpl getGuild() {
        return this.guild.get();
    }

    @Override
    public JDA getJDA() {
        return this.user.getJDA();
    }

    @Override
    public OffsetDateTime getTimeJoined() {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.joinDate), OFFSET);
    }

    @Override
    public GuildVoiceState getVoiceState() {
        return this.voiceState;
    }

    @Override
    public List<Activity> getActivities() {
        return this.activities == null || this.activities.isEmpty() ? Collections.emptyList() : this.activities;
    }

    @Override
    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getEffectiveName() {
        return this.nickname != null ? this.nickname : this.user.getName();
    }

    @Override
    public List<Role> getRoles() {
        ArrayList<Role> roleList = new ArrayList<Role>(this.roles);
        roleList.sort(Comparator.reverseOrder());
        return Collections.unmodifiableList(roleList);
    }

    @Override
    public Color getColor() {
        int raw = this.getColorRaw();
        return raw != 0x1FFFFFFF ? new Color(raw) : null;
    }

    @Override
    public int getColorRaw() {
        for (Role r : this.getRoles()) {
            int colorRaw = r.getColorRaw();
            if (colorRaw == 0x1FFFFFFF) continue;
            return colorRaw;
        }
        return 0x1FFFFFFF;
    }

    @Override
    public EnumSet<Permission> getPermissions() {
        return Permission.getPermissions(PermissionUtil.getEffectivePermission(this));
    }

    @Override
    public EnumSet<Permission> getPermissions(GuildChannel channel) {
        if (!this.getGuild().equals(channel.getGuild())) {
            throw new IllegalArgumentException("Provided channel is not in the same guild as this member!");
        }
        return Permission.getPermissions(PermissionUtil.getEffectivePermission(channel, this));
    }

    @Override
    public boolean hasPermission(Permission ... permissions) {
        return PermissionUtil.checkPermission(this, permissions);
    }

    @Override
    public boolean hasPermission(Collection<Permission> permissions) {
        Checks.notNull(permissions, "Permission Collection");
        return this.hasPermission(permissions.toArray(Permission.EMPTY_PERMISSIONS));
    }

    @Override
    public boolean hasPermission(GuildChannel channel, Permission ... permissions) {
        return PermissionUtil.checkPermission(channel, this, permissions);
    }

    @Override
    public boolean hasPermission(GuildChannel channel, Collection<Permission> permissions) {
        Checks.notNull(permissions, "Permission Collection");
        return this.hasPermission(channel, permissions.toArray(Permission.EMPTY_PERMISSIONS));
    }

    @Override
    public boolean canInteract(Member member) {
        return PermissionUtil.canInteract((Member)this, member);
    }

    @Override
    public boolean canInteract(Role role) {
        return PermissionUtil.canInteract((Member)this, role);
    }

    @Override
    public boolean canInteract(Emote emote) {
        return PermissionUtil.canInteract((Member)this, emote);
    }

    @Override
    public boolean isOwner() {
        return this.equals(this.getGuild().getOwner());
    }

    @Override
    public long getIdLong() {
        return this.user.getIdLong();
    }

    public MemberImpl setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public MemberImpl setJoinDate(long joinDate) {
        this.joinDate = joinDate;
        return this;
    }

    public MemberImpl setActivities(List<Activity> activities) {
        this.activities = Collections.unmodifiableList(activities);
        return this;
    }

    public MemberImpl setOnlineStatus(OnlineStatus onlineStatus) {
        this.onlineStatus = onlineStatus;
        return this;
    }

    public Set<Role> getRoleSet() {
        return this.roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Member)) {
            return false;
        }
        Member oMember = (Member)o;
        return oMember.getUser().equals(this.user) && oMember.getGuild().equals(this.getGuild());
    }

    public int hashCode() {
        return (this.getGuild().getId() + this.user.getId()).hashCode();
    }

    public String toString() {
        return "MB:" + this.getEffectiveName() + '(' + this.user.toString() + " / " + this.getGuild().toString() + ')';
    }

    @Override
    public String getAsMention() {
        return this.nickname == null ? this.user.getAsMention() : "<@!" + this.user.getIdLong() + '>';
    }

    @Override
    @Nullable
    public TextChannel getDefaultChannel() {
        return this.getGuild().getTextChannelsView().stream().sorted(Comparator.reverseOrder()).filter(c -> this.hasPermission((GuildChannel)c, Permission.MESSAGE_READ)).findFirst().orElse(null);
    }
}

