/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.InviteAction;
import net.dv8tion.jda.api.requests.restaction.order.CategoryOrderAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.entities.AbstractChannelImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.requests.EmptyRestAction;
import net.dv8tion.jda.internal.utils.Checks;

public class CategoryImpl
extends AbstractChannelImpl<Category, CategoryImpl>
implements Category {
    protected final TLongObjectMap<GuildChannel> channels = MiscUtil.newLongMap();

    public CategoryImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    public Category getParent() {
        return null;
    }

    @Override
    public int compareTo(Category other) {
        Checks.notNull(other, "Other Category");
        if (other.equals(this)) {
            return 0;
        }
        Checks.check(this.getGuild().equals(other.getGuild()), "Cannot compare categories from different guilds!");
        if (this.rawPosition == other.getPositionRaw()) {
            return Long.compare(this.id, other.getIdLong());
        }
        return Integer.compare(this.rawPosition, other.getPositionRaw());
    }

    @Override
    public ChannelType getType() {
        return ChannelType.CATEGORY;
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(this.getChannels().stream().map(GuildChannel::getMembers).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }

    @Override
    public int getPosition() {
        List<Category> channels = this.getGuild().getCategories();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new AssertionError((Object)"Somehow when determining position we never found the Category in the Guild's channels? wtf?");
    }

    @Override
    public ChannelAction<Category> createCopy(Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<Category> action = guild.getController().createCategory(this.name);
        if (guild.equals(this.getGuild())) {
            for (PermissionOverride o : this.overrides.valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addPermissionOverride((IPermissionHolder)o.getMember(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addPermissionOverride((IPermissionHolder)o.getRole(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }

    @Override
    public InviteAction createInvite() {
        throw new UnsupportedOperationException("Cannot create invites for category!");
    }

    @Override
    public RestAction<List<Invite>> retrieveInvites() {
        return new EmptyRestAction<List<Invite>>(this.getJDA(), Collections.emptyList());
    }

    @Override
    public List<GuildChannel> getChannels() {
        ArrayList<GuildChannel> channels = new ArrayList<GuildChannel>();
        channels.addAll(this.getTextChannels());
        channels.addAll(this.getVoiceChannels());
        return Collections.unmodifiableList(channels);
    }

    @Override
    public List<TextChannel> getTextChannels() {
        return Collections.unmodifiableList(this.getGuild().getTextChannels().stream().filter(channel -> channel.getParent() != null).filter(channel -> channel.getParent().equals(this)).collect(Collectors.toList()));
    }

    @Override
    public List<VoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableList(this.getGuild().getVoiceChannels().stream().filter(channel -> channel.getParent() != null).filter(channel -> channel.getParent().equals(this)).collect(Collectors.toList()));
    }

    @Override
    public ChannelAction<TextChannel> createTextChannel(String name) {
        ChannelAction<TextChannel> action = this.getGuild().getController().createTextChannel(name).setParent(this);
        this.applyPermission(action);
        return action;
    }

    @Override
    public ChannelAction<VoiceChannel> createVoiceChannel(String name) {
        ChannelAction<VoiceChannel> action = this.getGuild().getController().createVoiceChannel(name).setParent(this);
        this.applyPermission(action);
        return action;
    }

    @Override
    public CategoryOrderAction<TextChannel> modifyTextChannelPositions() {
        return this.getGuild().getController().modifyTextChannelPositions(this);
    }

    @Override
    public CategoryOrderAction<VoiceChannel> modifyVoiceChannelPositions() {
        return this.getGuild().getController().modifyVoiceChannelPositions(this);
    }

    public String toString() {
        return "GC:" + this.getName() + '(' + this.id + ')';
    }

    private void applyPermission(ChannelAction a) {
        this.overrides.forEachValue(override -> {
            if (override.isMemberOverride()) {
                a.addPermissionOverride((IPermissionHolder)override.getMember(), override.getAllowedRaw(), override.getDeniedRaw());
            } else {
                a.addPermissionOverride((IPermissionHolder)override.getRole(), override.getAllowedRaw(), override.getDeniedRaw());
            }
            return true;
        });
    }
}

