/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.sharding;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.ApplicationInfo;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.api.utils.cache.CacheView;
import net.dv8tion.jda.api.utils.cache.ShardCacheView;
import net.dv8tion.jda.api.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.requests.EmptyRestAction;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.Checks;

public interface ShardManager {
    default public void addEventListener(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        this.getShardCache().forEach(jda -> jda.addEventListener(listeners));
    }

    default public void removeEventListener(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        this.getShardCache().forEach(jda -> jda.removeEventListener(listeners));
    }

    default public void addEventListeners(IntFunction<Object> eventListenerProvider) {
        Checks.notNull(eventListenerProvider, "event listener provider");
        this.getShardCache().forEach(jda -> {
            Object listener = eventListenerProvider.apply(jda.getShardInfo().getShardId());
            if (listener != null) {
                jda.addEventListener(listener);
            }
        });
    }

    default public void removeEventListeners(IntFunction<Collection<Object>> eventListenerProvider) {
        Checks.notNull(eventListenerProvider, "event listener provider");
        this.getShardCache().forEach(jda -> jda.removeEventListener(eventListenerProvider.apply(jda.getShardInfo().getShardId())));
    }

    default public void removeEventListenerProvider(IntFunction<Object> eventListenerProvider) {
    }

    public int getShardsQueued();

    default public int getShardsRunning() {
        return (int)this.getShardCache().size();
    }

    default public int getShardsTotal() {
        return this.getShardsQueued() + this.getShardsRunning();
    }

    default public RestAction<ApplicationInfo> retrieveApplicationInfo() {
        return ((JDA)this.getShardCache().stream().findAny().orElseThrow(() -> new IllegalStateException("no active shards"))).retrieveApplicationInfo();
    }

    default public double getAverageGatewayPing() {
        return this.getShardCache().stream().mapToLong(JDA::getGatewayPing).filter(ping -> ping != -1L).average().orElse(-1.0);
    }

    default public List<Category> getCategories() {
        return this.getCategoryCache().asList();
    }

    default public List<Category> getCategoriesByName(String name, boolean ignoreCase) {
        return this.getCategoryCache().getElementsByName(name, ignoreCase);
    }

    default public Category getCategoryById(long id) {
        return this.getCategoryCache().getElementById(id);
    }

    default public Category getCategoryById(String id) {
        return this.getCategoryCache().getElementById(id);
    }

    default public SnowflakeCacheView<Category> getCategoryCache() {
        return CacheView.allSnowflakes(() -> this.getShardCache().stream().map(JDA::getCategoryCache));
    }

    default public Emote getEmoteById(long id) {
        return this.getEmoteCache().getElementById(id);
    }

    default public Emote getEmoteById(String id) {
        return this.getEmoteCache().getElementById(id);
    }

    default public SnowflakeCacheView<Emote> getEmoteCache() {
        return CacheView.allSnowflakes(() -> this.getShardCache().stream().map(JDA::getEmoteCache));
    }

    default public List<Emote> getEmotes() {
        return this.getEmoteCache().asList();
    }

    default public List<Emote> getEmotesByName(String name, boolean ignoreCase) {
        return this.getEmoteCache().getElementsByName(name, ignoreCase);
    }

    default public Guild getGuildById(long id) {
        return this.getGuildCache().getElementById(id);
    }

    default public Guild getGuildById(String id) {
        return this.getGuildById(MiscUtil.parseSnowflake(id));
    }

    default public List<Guild> getGuildsByName(String name, boolean ignoreCase) {
        return this.getGuildCache().getElementsByName(name, ignoreCase);
    }

    default public SnowflakeCacheView<Guild> getGuildCache() {
        return CacheView.allSnowflakes(() -> this.getShardCache().stream().map(JDA::getGuildCache));
    }

    default public List<Guild> getGuilds() {
        return this.getGuildCache().asList();
    }

    default public List<Guild> getMutualGuilds(Collection<User> users) {
        Checks.noneNull(users, "users");
        return Collections.unmodifiableList(this.getGuildCache().stream().filter(guild -> users.stream().allMatch(guild::isMember)).collect(Collectors.toList()));
    }

    default public List<Guild> getMutualGuilds(User ... users) {
        Checks.notNull(users, "users");
        return this.getMutualGuilds(Arrays.asList(users));
    }

    @CheckReturnValue
    default public RestAction<User> retrieveUserById(String id) {
        return this.retrieveUserById(MiscUtil.parseSnowflake(id));
    }

    @CheckReturnValue
    default public RestAction<User> retrieveUserById(long id) {
        JDA api = null;
        Iterator iterator = this.getShardCache().iterator();
        while (iterator.hasNext()) {
            JDA shard;
            api = shard = (JDA)iterator.next();
            User user = shard.getUserById(id);
            if (user == null) continue;
            return new EmptyRestAction<User>(shard, user);
        }
        if (api == null) {
            throw new IllegalStateException("no shards active");
        }
        JDAImpl jda = (JDAImpl)api;
        Route.CompiledRoute route = Route.Users.GET_USER.compile(Long.toUnsignedString(id));
        return new RestActionImpl<User>((JDA)jda, route, (response, request) -> jda.getEntityBuilder().createFakeUser(response.getObject(), false));
    }

    default public PrivateChannel getPrivateChannelById(long id) {
        return this.getPrivateChannelCache().getElementById(id);
    }

    default public PrivateChannel getPrivateChannelById(String id) {
        return this.getPrivateChannelCache().getElementById(id);
    }

    default public SnowflakeCacheView<PrivateChannel> getPrivateChannelCache() {
        return CacheView.allSnowflakes(() -> this.getShardCache().stream().map(JDA::getPrivateChannelCache));
    }

    default public List<PrivateChannel> getPrivateChannels() {
        return this.getPrivateChannelCache().asList();
    }

    default public Role getRoleById(long id) {
        return this.getRoleCache().getElementById(id);
    }

    default public Role getRoleById(String id) {
        return this.getRoleCache().getElementById(id);
    }

    default public SnowflakeCacheView<Role> getRoleCache() {
        return CacheView.allSnowflakes(() -> this.getShardCache().stream().map(JDA::getRoleCache));
    }

    default public List<Role> getRoles() {
        return this.getRoleCache().asList();
    }

    default public List<Role> getRolesByName(String name, boolean ignoreCase) {
        return this.getRoleCache().getElementsByName(name, ignoreCase);
    }

    default public JDA getShardById(int id) {
        return this.getShardCache().getElementById(id);
    }

    default public JDA getShardById(String id) {
        return this.getShardCache().getElementById(id);
    }

    public ShardCacheView getShardCache();

    default public List<JDA> getShards() {
        return this.getShardCache().asList();
    }

    default public JDA.Status getStatus(int shardId) {
        JDA jda = this.getShardCache().getElementById(shardId);
        return jda == null ? null : jda.getStatus();
    }

    default public Map<JDA, JDA.Status> getStatuses() {
        return Collections.unmodifiableMap(this.getShardCache().stream().collect(Collectors.toMap(Function.identity(), JDA::getStatus)));
    }

    default public TextChannel getTextChannelById(long id) {
        return this.getTextChannelCache().getElementById(id);
    }

    default public TextChannel getTextChannelById(String id) {
        return this.getTextChannelCache().getElementById(id);
    }

    default public SnowflakeCacheView<TextChannel> getTextChannelCache() {
        return CacheView.allSnowflakes(() -> this.getShardCache().stream().map(JDA::getTextChannelCache));
    }

    default public List<TextChannel> getTextChannels() {
        return this.getTextChannelCache().asList();
    }

    default public User getUserById(long id) {
        return this.getUserCache().getElementById(id);
    }

    default public User getUserById(String id) {
        return this.getUserCache().getElementById(id);
    }

    default public SnowflakeCacheView<User> getUserCache() {
        return CacheView.allSnowflakes(() -> this.getShardCache().stream().map(JDA::getUserCache));
    }

    default public List<User> getUsers() {
        return this.getUserCache().asList();
    }

    default public VoiceChannel getVoiceChannelById(long id) {
        return this.getVoiceChannelCache().getElementById(id);
    }

    default public VoiceChannel getVoiceChannelById(String id) {
        return this.getVoiceChannelCache().getElementById(id);
    }

    default public SnowflakeCacheView<VoiceChannel> getVoiceChannelCache() {
        return CacheView.allSnowflakes(() -> this.getShardCache().stream().map(JDA::getVoiceChannelCache));
    }

    default public List<VoiceChannel> getVoiceChannels() {
        return this.getVoiceChannelCache().asList();
    }

    public void restart();

    public void restart(int var1);

    default public void setGame(Activity game) {
        this.setActivityProvider(id -> game);
    }

    default public void setActivityProvider(IntFunction<? extends Activity> gameProvider) {
        this.getShardCache().forEach(jda -> jda.getPresence().setActivity((Activity)gameProvider.apply(jda.getShardInfo().getShardId())));
    }

    default public void setIdle(boolean idle) {
        this.setIdleProvider(id -> idle);
    }

    default public void setIdleProvider(IntFunction<Boolean> idleProvider) {
        this.getShardCache().forEach(jda -> jda.getPresence().setIdle((Boolean)idleProvider.apply(jda.getShardInfo().getShardId())));
    }

    default public void setPresence(OnlineStatus status, Activity game) {
        this.setPresenceProvider(id -> status, id -> game);
    }

    default public void setPresenceProvider(IntFunction<OnlineStatus> statusProvider, IntFunction<? extends Activity> gameProvider) {
        this.getShardCache().forEach(jda -> jda.getPresence().setPresence((OnlineStatus)((Object)((Object)statusProvider.apply(jda.getShardInfo().getShardId()))), (Activity)gameProvider.apply(jda.getShardInfo().getShardId())));
    }

    default public void setStatus(OnlineStatus status) {
        this.setStatusProvider(id -> status);
    }

    default public void setStatusProvider(IntFunction<OnlineStatus> statusProvider) {
        this.getShardCache().forEach(jda -> jda.getPresence().setStatus((OnlineStatus)((Object)((Object)statusProvider.apply(jda.getShardInfo().getShardId())))));
    }

    public void shutdown();

    public void shutdown(int var1);

    public void start(int var1);
}

