/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.requests.restaction;

import java.util.Collection;
import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.internal.utils.Checks;

public interface PermissionOverrideAction
extends AuditableRestAction<PermissionOverride> {
    @Override
    public PermissionOverrideAction setCheck(BooleanSupplier var1);

    public GuildChannel getChannel();

    public Role getRole();

    public Member getMember();

    default public Guild getGuild() {
        return this.getChannel().getGuild();
    }

    public long getAllow();

    default public EnumSet<Permission> getAllowedPermissions() {
        return Permission.getPermissions(this.getAllow());
    }

    public long getDeny();

    default public EnumSet<Permission> getDeniedPermissions() {
        return Permission.getPermissions(this.getDeny());
    }

    public long getInherited();

    default public EnumSet<Permission> getInheritedPermissions() {
        return Permission.getPermissions(this.getInherited());
    }

    public boolean isMember();

    public boolean isRole();

    @CheckReturnValue
    public PermissionOverrideAction setAllow(long var1);

    @CheckReturnValue
    default public PermissionOverrideAction setAllow(Collection<Permission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return this.setAllow(0L);
        }
        Checks.noneNull(permissions, "Permissions");
        return this.setAllow(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    default public PermissionOverrideAction setAllow(Permission ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return this.setAllow(0L);
        }
        Checks.noneNull((Object[])permissions, "Permissions");
        return this.setAllow(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    default public PermissionOverrideAction grant(long allowBits) {
        return this.setAllow(this.getAllow() | allowBits);
    }

    @CheckReturnValue
    default public PermissionOverrideAction grant(Collection<Permission> permissions) {
        return this.setAllow(this.getAllow() | Permission.getRaw(permissions));
    }

    @CheckReturnValue
    default public PermissionOverrideAction grant(Permission ... permissions) {
        return this.setAllow(this.getAllow() | Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermissionOverrideAction setDeny(long var1);

    @CheckReturnValue
    default public PermissionOverrideAction setDeny(Collection<Permission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return this.setDeny(0L);
        }
        Checks.noneNull(permissions, "Permissions");
        return this.setDeny(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    default public PermissionOverrideAction setDeny(Permission ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return this.setDeny(0L);
        }
        Checks.noneNull((Object[])permissions, "Permissions");
        return this.setDeny(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    default public PermissionOverrideAction deny(long denyBits) {
        return this.setDeny(this.getDeny() | denyBits);
    }

    @CheckReturnValue
    default public PermissionOverrideAction deny(Collection<Permission> permissions) {
        return this.setDeny(this.getDeny() | Permission.getRaw(permissions));
    }

    @CheckReturnValue
    default public PermissionOverrideAction deny(Permission ... permissions) {
        return this.setDeny(this.getDeny() | Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermissionOverrideAction setPermissions(long var1, long var3);

    @CheckReturnValue
    default public PermissionOverrideAction setPermissions(Collection<Permission> grantPermissions, Collection<Permission> denyPermissions) {
        return this.setAllow(grantPermissions).setDeny(denyPermissions);
    }
}

