/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.requests;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.exceptions.RateLimitedException;
import net.dv8tion.jda.api.utils.concurrent.DelayedCompletableFuture;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.ContextRunnable;

public interface RestAction<T> {
    public static void setPassContext(boolean enable) {
        RestActionImpl.setPassContext(enable);
    }

    public static boolean isPassContext() {
        return RestActionImpl.isPassContext();
    }

    public static void setDefaultFailure(Consumer<? super Throwable> callback) {
        RestActionImpl.setDefaultFailure(callback);
    }

    public static void setDefaultSuccess(Consumer<Object> callback) {
        RestActionImpl.setDefaultSuccess(callback);
    }

    public static Consumer<? super Throwable> getDefaultFailure() {
        return RestActionImpl.getDefaultFailure();
    }

    public static Consumer<Object> getDefaultSuccess() {
        return RestActionImpl.getDefaultSuccess();
    }

    public JDA getJDA();

    public RestAction<T> setCheck(BooleanSupplier var1);

    default public void queue() {
        this.queue(null);
    }

    default public void queue(Consumer<? super T> success) {
        this.queue(success, null);
    }

    public void queue(Consumer<? super T> var1, Consumer<? super Throwable> var2);

    default public T complete() {
        try {
            return this.complete(true);
        }
        catch (RateLimitedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public T complete(boolean var1) throws RateLimitedException;

    default public CompletableFuture<T> submit() {
        return this.submit(true);
    }

    public CompletableFuture<T> submit(boolean var1);

    default public DelayedCompletableFuture<T> submitAfter(long delay, TimeUnit unit) {
        return this.submitAfter(delay, unit, null);
    }

    default public DelayedCompletableFuture<T> submitAfter(long delay, TimeUnit unit, ScheduledExecutorService executor) {
        Checks.notNull((Object)unit, "TimeUnit");
        if (executor == null) {
            executor = this.getJDA().getRateLimitPool();
        }
        return DelayedCompletableFuture.make(executor, delay, unit, task -> new ContextRunnable(() -> this.queue(task::complete, task::completeExceptionally)));
    }

    default public T completeAfter(long delay, TimeUnit unit) {
        Checks.notNull((Object)unit, "TimeUnit");
        try {
            unit.sleep(delay);
            return this.complete();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    default public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit) {
        return this.queueAfter(delay, unit, null, null, null);
    }

    default public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<? super T> success) {
        return this.queueAfter(delay, unit, success, null, null);
    }

    default public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<? super T> success, Consumer<? super Throwable> failure) {
        return this.queueAfter(delay, unit, success, failure, null);
    }

    default public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, null, null, executor);
    }

    default public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<? super T> success, ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, success, null, executor);
    }

    default public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<? super T> success, Consumer<? super Throwable> failure, ScheduledExecutorService executor) {
        Checks.notNull((Object)unit, "TimeUnit");
        if (executor == null) {
            executor = this.getJDA().getRateLimitPool();
        }
        return executor.schedule(new ContextRunnable(() -> this.queue(success, failure)), delay, unit);
    }
}

