/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.requests;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.utils.IOFunction;
import net.dv8tion.jda.internal.requests.Requester;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Response
implements Closeable {
    public static final int ERROR_CODE = -1;
    public static final String ERROR_MESSAGE = "ERROR";
    public static final IOFunction<BufferedReader, JSONObject> JSON_SERIALIZE_OBJECT = reader -> new JSONObject(new JSONTokener((Reader)reader));
    public static final IOFunction<BufferedReader, JSONArray> JSON_SERIALIZE_ARRAY = reader -> new JSONArray(new JSONTokener((Reader)reader));
    public final int code;
    public final String message;
    public final long retryAfter;
    private final InputStream body;
    private final okhttp3.Response rawResponse;
    private final Set<String> cfRays;
    private String fallbackString;
    private Object object;
    private boolean attemptedParsing = false;
    private Exception exception;

    public Response(okhttp3.Response response, Exception exception, Set<String> cfRays) {
        this(response, response != null ? response.code() : -1, ERROR_MESSAGE, -1L, cfRays);
        this.exception = exception;
    }

    public Response(okhttp3.Response response, int code, String message, long retryAfter, Set<String> cfRays) {
        this.rawResponse = response;
        this.code = code;
        this.message = message;
        this.exception = null;
        this.retryAfter = retryAfter;
        this.cfRays = cfRays;
        if (response == null) {
            this.body = null;
        } else {
            try {
                this.body = Requester.getBody(response);
            }
            catch (Exception e) {
                throw new IllegalStateException("An error occurred while parsing the response for a RestAction", e);
            }
        }
    }

    public Response(long retryAfter, Set<String> cfRays) {
        this(null, 429, "TOO MANY REQUESTS", retryAfter, cfRays);
    }

    public Response(okhttp3.Response response, long retryAfter, Set<String> cfRays) {
        this(response, response.code(), response.message(), retryAfter, cfRays);
    }

    public JSONArray getArray() {
        return this.get(JSONArray.class, JSON_SERIALIZE_ARRAY);
    }

    public Optional<JSONArray> optArray() {
        return this.parseBody(true, JSONArray.class, JSON_SERIALIZE_ARRAY);
    }

    public JSONObject getObject() {
        return this.get(JSONObject.class, JSON_SERIALIZE_OBJECT);
    }

    public Optional<JSONObject> optObject() {
        return this.parseBody(true, JSONObject.class, JSON_SERIALIZE_OBJECT);
    }

    public String getString() {
        return this.parseBody(String.class, this::readString).orElseGet(() -> this.fallbackString == null ? "N/A" : this.fallbackString);
    }

    public <T> T get(Class<T> clazz, IOFunction<BufferedReader, T> parser) {
        return this.parseBody(clazz, parser).orElseThrow(IllegalStateException::new);
    }

    public okhttp3.Response getRawResponse() {
        return this.rawResponse;
    }

    public Set<String> getCFRays() {
        return this.cfRays;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isError() {
        return this.code == -1;
    }

    public boolean isOk() {
        return this.code > 199 && this.code < 300;
    }

    public boolean isRateLimit() {
        return this.code == 429;
    }

    public String toString() {
        return this.exception == null ? "HTTPResponse[" + this.code + (this.object == null ? "" : ", " + this.object.toString()) + ']' : "HTTPException[" + this.exception.getMessage() + ']';
    }

    @Override
    public void close() {
        if (this.rawResponse != null) {
            this.rawResponse.close();
        }
    }

    private String readString(BufferedReader reader) {
        return reader.lines().collect(Collectors.joining("\n"));
    }

    private <T> Optional<T> parseBody(Class<T> clazz, IOFunction<BufferedReader, T> parser) {
        return this.parseBody(false, clazz, parser);
    }

    private <T> Optional<T> parseBody(boolean opt, Class<T> clazz, IOFunction<BufferedReader, T> parser) {
        if (this.attemptedParsing) {
            if (this.object != null && clazz.isAssignableFrom(this.object.getClass())) {
                return Optional.of(clazz.cast(this.object));
            }
            return Optional.empty();
        }
        this.attemptedParsing = true;
        if (this.body == null || this.rawResponse == null || this.rawResponse.body().contentLength() == 0L) {
            return Optional.empty();
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.body));
            reader.mark(1024);
            T t = parser.apply(reader);
            this.object = t;
            return Optional.ofNullable(t);
        }
        catch (Exception e) {
            try {
                reader.reset();
                this.fallbackString = this.readString(reader);
                reader.close();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
            if (opt && e instanceof JSONException) {
                return Optional.empty();
            }
            throw new IllegalStateException("An error occurred while parsing the response for a RestAction", e);
        }
    }
}

