/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.managers;

import java.util.Collection;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.managers.Manager;
import net.dv8tion.jda.internal.utils.Checks;

public interface PermOverrideManager
extends Manager<PermOverrideManager> {
    public static final long DENIED = 1L;
    public static final long ALLOWED = 2L;
    public static final long PERMISSIONS = 3L;

    @Override
    public PermOverrideManager reset(long var1);

    @Override
    public PermOverrideManager reset(long ... var1);

    default public Guild getGuild() {
        return this.getPermissionOverride().getGuild();
    }

    default public GuildChannel getChannel() {
        return this.getPermissionOverride().getChannel();
    }

    public PermissionOverride getPermissionOverride();

    @CheckReturnValue
    public PermOverrideManager grant(long var1);

    @CheckReturnValue
    default public PermOverrideManager grant(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.grant(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    default public PermOverrideManager grant(Collection<Permission> permissions) {
        return this.grant(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermOverrideManager deny(long var1);

    @CheckReturnValue
    default public PermOverrideManager deny(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.deny(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    default public PermOverrideManager deny(Collection<Permission> permissions) {
        return this.deny(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public PermOverrideManager clear(long var1);

    @CheckReturnValue
    default public PermOverrideManager clear(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.clear(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    default public PermOverrideManager clear(Collection<Permission> permissions) {
        return this.clear(Permission.getRaw(permissions));
    }
}

