/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.managers;

import java.util.Collection;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.managers.Manager;

public interface ChannelManager
extends Manager<ChannelManager> {
    public static final long NAME = 1L;
    public static final long PARENT = 2L;
    public static final long TOPIC = 4L;
    public static final long POSITION = 8L;
    public static final long NSFW = 16L;
    public static final long USERLIMIT = 32L;
    public static final long BITRATE = 64L;
    public static final long PERMISSION = 128L;
    public static final long SLOWMODE = 256L;

    @Override
    public ChannelManager reset(long var1);

    @Override
    public ChannelManager reset(long ... var1);

    public GuildChannel getChannel();

    default public ChannelType getType() {
        return this.getChannel().getType();
    }

    default public Guild getGuild() {
        return this.getChannel().getGuild();
    }

    @CheckReturnValue
    public ChannelManager clearOverridesAdded();

    @CheckReturnValue
    public ChannelManager clearOverridesRemoved();

    @CheckReturnValue
    public ChannelManager putPermissionOverride(IPermissionHolder var1, long var2, long var4);

    @CheckReturnValue
    default public ChannelManager putPermissionOverride(IPermissionHolder permHolder, Collection<Permission> allow, Collection<Permission> deny) {
        long allowRaw = allow == null ? 0L : Permission.getRaw(allow);
        long denyRaw = deny == null ? 0L : Permission.getRaw(deny);
        return this.putPermissionOverride(permHolder, allowRaw, denyRaw);
    }

    @CheckReturnValue
    public ChannelManager removePermissionOverride(IPermissionHolder var1);

    @CheckReturnValue
    default public ChannelManager sync() {
        if (this.getChannel().getParent() == null) {
            throw new IllegalStateException("sync() requires a parent category");
        }
        return this.sync(this.getChannel().getParent());
    }

    @CheckReturnValue
    public ChannelManager sync(GuildChannel var1);

    @CheckReturnValue
    public ChannelManager setName(String var1);

    @CheckReturnValue
    public ChannelManager setParent(Category var1);

    @CheckReturnValue
    public ChannelManager setPosition(int var1);

    @CheckReturnValue
    public ChannelManager setTopic(String var1);

    @CheckReturnValue
    public ChannelManager setNSFW(boolean var1);

    @CheckReturnValue
    public ChannelManager setSlowmode(int var1);

    @CheckReturnValue
    public ChannelManager setUserLimit(int var1);

    @CheckReturnValue
    public ChannelManager setBitrate(int var1);
}

