/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.managers;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import net.dv8tion.jda.annotations.Incubating;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.audio.AudioReceiveHandler;
import net.dv8tion.jda.api.audio.AudioSendHandler;
import net.dv8tion.jda.api.audio.SpeakingMode;
import net.dv8tion.jda.api.audio.hooks.ConnectionListener;
import net.dv8tion.jda.api.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.JDALogger;
import org.slf4j.Logger;

public interface AudioManager {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 10000L;
    public static final Logger LOG = JDALogger.getLog(AudioManager.class);

    public void openAudioConnection(VoiceChannel var1);

    public void closeAudioConnection();

    @Incubating
    public void setSpeakingMode(Collection<SpeakingMode> var1);

    @Incubating
    default public void setSpeakingMode(SpeakingMode ... mode) {
        Checks.notNull(mode, "Speaking Mode");
        this.setSpeakingMode(Arrays.asList(mode));
    }

    @Incubating
    public EnumSet<SpeakingMode> getSpeakingMode();

    public JDA getJDA();

    public Guild getGuild();

    public boolean isAttemptingToConnect();

    public VoiceChannel getQueuedAudioConnection();

    public VoiceChannel getConnectedChannel();

    public boolean isConnected();

    public void setConnectTimeout(long var1);

    public long getConnectTimeout();

    public void setSendingHandler(AudioSendHandler var1);

    public AudioSendHandler getSendingHandler();

    public void setReceivingHandler(AudioReceiveHandler var1);

    public AudioReceiveHandler getReceivingHandler();

    public void setConnectionListener(ConnectionListener var1);

    public ConnectionListener getConnectionListener();

    public ConnectionStatus getConnectionStatus();

    public void setAutoReconnect(boolean var1);

    public boolean isAutoReconnect();

    public void setSelfMuted(boolean var1);

    public boolean isSelfMuted();

    public void setSelfDeafened(boolean var1);

    public boolean isSelfDeafened();
}

