/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.hooks;

import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.managers.DirectAudioController;
import org.json.JSONObject;
import org.json.JSONString;

public interface VoiceDispatchInterceptor {
    public void onVoiceServerUpdate(@Nonnull VoiceServerUpdate var1);

    public boolean onVoiceStateUpdate(@Nonnull VoiceStateUpdate var1);

    public static class VoiceStateUpdate
    implements VoiceUpdate {
        private final VoiceChannel channel;
        private final GuildVoiceState voiceState;
        private final JSONObject json;

        public VoiceStateUpdate(VoiceChannel channel, GuildVoiceState voiceState, JSONObject json) {
            this.channel = channel;
            this.voiceState = voiceState;
            this.json = json;
        }

        @Override
        public Guild getGuild() {
            return this.voiceState.getGuild();
        }

        @Override
        public JSONObject getJSON() {
            return this.json;
        }

        public VoiceChannel getChannel() {
            return this.channel;
        }

        public GuildVoiceState getVoiceState() {
            return this.voiceState;
        }
    }

    public static class VoiceServerUpdate
    implements VoiceUpdate {
        private final Guild guild;
        private final String endpoint;
        private final String token;
        private final String sessionId;
        private final JSONObject json;

        public VoiceServerUpdate(Guild guild, String endpoint, String token, String sessionId, JSONObject json) {
            this.guild = guild;
            this.endpoint = endpoint;
            this.token = token;
            this.sessionId = sessionId;
            this.json = json;
        }

        @Override
        public Guild getGuild() {
            return this.guild;
        }

        @Override
        public JSONObject getJSON() {
            return this.json;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getToken() {
            return this.token;
        }

        public String getSessionId() {
            return this.sessionId;
        }
    }

    public static interface VoiceUpdate
    extends JSONString {
        public Guild getGuild();

        public JSONObject getJSON();

        default public String toJSONString() {
            return this.getJSON().toString();
        }

        default public DirectAudioController getAudioController() {
            return this.getJDA().getDirectAudioController();
        }

        default public long getGuildIdLong() {
            return this.getGuild().getIdLong();
        }

        default public String getGuildId() {
            return Long.toUnsignedString(this.getGuildIdLong());
        }

        default public JDA getJDA() {
            return this.getGuild().getJDA();
        }

        default public JDA.ShardInfo getShardInfo() {
            return this.getJDA().getShardInfo();
        }
    }
}

