/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.events.message;

import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.events.Event;

public abstract class GenericMessageEvent
extends Event {
    protected final long messageId;
    protected final MessageChannel channel;

    public GenericMessageEvent(JDA api, long responseNumber, long messageId, MessageChannel channel) {
        super(api, responseNumber);
        this.messageId = messageId;
        this.channel = channel;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public String getMessageId() {
        return Long.toUnsignedString(this.messageId);
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    public boolean isFromType(ChannelType type) {
        return this.channel.getType() == type;
    }

    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    public Guild getGuild() {
        return this.isFromType(ChannelType.TEXT) ? this.getTextChannel().getGuild() : null;
    }

    public TextChannel getTextChannel() {
        return this.isFromType(ChannelType.TEXT) ? (TextChannel)this.channel : null;
    }

    public PrivateChannel getPrivateChannel() {
        return this.isFromType(ChannelType.PRIVATE) ? (PrivateChannel)this.channel : null;
    }
}

