/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.WebhookAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.utils.Checks;

public interface TextChannel
extends GuildChannel,
MessageChannel,
Comparable<TextChannel>,
IMentionable {
    public String getTopic();

    public boolean isNSFW();

    public int getSlowmode();

    public ChannelAction<TextChannel> createCopy(Guild var1);

    public ChannelAction<TextChannel> createCopy();

    @CheckReturnValue
    public RestAction<List<Webhook>> retrieveWebhooks();

    @CheckReturnValue
    public WebhookAction createWebhook(String var1);

    @CheckReturnValue
    public RestAction<Void> deleteMessages(Collection<Message> var1);

    @CheckReturnValue
    public RestAction<Void> deleteMessagesByIds(Collection<String> var1);

    @CheckReturnValue
    public AuditableRestAction<Void> deleteWebhookById(String var1);

    @CheckReturnValue
    public RestAction<Void> clearReactionsById(String var1);

    @CheckReturnValue
    default public RestAction<Void> clearReactionsById(long messageId) {
        return this.clearReactionsById(Long.toUnsignedString(messageId));
    }

    @CheckReturnValue
    public RestAction<Void> removeReactionById(String var1, String var2, User var3);

    @CheckReturnValue
    default public RestAction<Void> removeReactionById(long messageId, String unicode, User user) {
        return this.removeReactionById(Long.toUnsignedString(messageId), unicode, user);
    }

    @CheckReturnValue
    default public RestAction<Void> removeReactionById(String messageId, Emote emote, User user) {
        Checks.notNull(emote, "Emote");
        return this.removeReactionById(messageId, emote.getName() + ":" + emote.getId(), user);
    }

    @CheckReturnValue
    default public RestAction<Void> removeReactionById(long messageId, Emote emote, User user) {
        return this.removeReactionById(Long.toUnsignedString(messageId), emote, user);
    }

    public boolean canTalk();

    public boolean canTalk(Member var1);

    @Override
    default public void formatTo(Formatter formatter, int flags, int width, int precision) {
        boolean alt;
        boolean leftJustified = (flags & 1) == 1;
        boolean upper = (flags & 2) == 2;
        boolean bl = alt = (flags & 4) == 4;
        String out = alt ? "#" + (upper ? this.getName().toUpperCase(formatter.locale()) : this.getName()) : this.getAsMention();
        MiscUtil.appendTo(formatter, width, precision, leftJustified, out);
    }
}

