/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Formattable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.utils.IOConsumer;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.requests.Requester;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.IOUtil;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public interface Message
extends ISnowflake,
Formattable {
    public static final int MAX_FILE_SIZE = 0x800000;
    public static final int MAX_FILE_SIZE_NITRO = 0x3200000;
    public static final int MAX_FILE_AMOUNT = 10;
    public static final int MAX_CONTENT_LENGTH = 2000;
    public static final Pattern INVITE_PATTERN = Pattern.compile("(?:https?://)?discord(?:app\\.com/invite|\\.gg)/([a-z0-9-]+)", 2);

    public List<User> getMentionedUsers();

    public List<TextChannel> getMentionedChannels();

    public List<Role> getMentionedRoles();

    public List<Member> getMentionedMembers(Guild var1);

    public List<Member> getMentionedMembers();

    public List<IMentionable> getMentions(MentionType ... var1);

    public boolean isMentioned(IMentionable var1, MentionType ... var2);

    public boolean mentionsEveryone();

    public boolean isEdited();

    public OffsetDateTime getTimeEdited();

    public User getAuthor();

    public Member getMember();

    public String getJumpUrl();

    public String getContentDisplay();

    public String getContentRaw();

    public String getContentStripped();

    public List<String> getInvites();

    public String getNonce();

    public boolean isFromType(ChannelType var1);

    public ChannelType getChannelType();

    public boolean isWebhookMessage();

    public MessageChannel getChannel();

    public PrivateChannel getPrivateChannel();

    public TextChannel getTextChannel();

    public Category getCategory();

    public Guild getGuild();

    public List<Attachment> getAttachments();

    public List<MessageEmbed> getEmbeds();

    public List<Emote> getEmotes();

    public List<MessageReaction> getReactions();

    public boolean isTTS();

    @CheckReturnValue
    public MessageAction editMessage(CharSequence var1);

    @CheckReturnValue
    public MessageAction editMessage(MessageEmbed var1);

    @CheckReturnValue
    public MessageAction editMessageFormat(String var1, Object ... var2);

    @CheckReturnValue
    public MessageAction editMessage(Message var1);

    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    public JDA getJDA();

    public boolean isPinned();

    @CheckReturnValue
    public RestAction<Void> pin();

    @CheckReturnValue
    public RestAction<Void> unpin();

    @CheckReturnValue
    public RestAction<Void> addReaction(Emote var1);

    @CheckReturnValue
    public RestAction<Void> addReaction(String var1);

    @CheckReturnValue
    public RestAction<Void> clearReactions();

    public MessageType getType();

    public static class Attachment
    implements ISnowflake {
        private final long id;
        private final String url;
        private final String proxyUrl;
        private final String fileName;
        private final int size;
        private final int height;
        private final int width;
        private final JDAImpl jda;

        public Attachment(long id, String url, String proxyUrl, String fileName, int size, int height, int width, JDAImpl jda) {
            this.id = id;
            this.url = url;
            this.proxyUrl = proxyUrl;
            this.fileName = fileName;
            this.size = size;
            this.height = height;
            this.width = width;
            this.jda = jda;
        }

        public JDA getJDA() {
            return this.jda;
        }

        @Override
        public long getIdLong() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public String getFileName() {
            return this.fileName;
        }

        public Icon getAsIcon() throws IOException {
            if (!this.isImage()) {
                throw new IllegalStateException("Cannot create an Icon out of this attachment. This is not an image.");
            }
            AtomicReference icon = new AtomicReference();
            this.withInputStream(in -> icon.set(Icon.from(in)));
            return (Icon)icon.get();
        }

        public boolean download(File file) {
            try {
                this.withInputStream(in -> Files.copy(in, Paths.get(file.getAbsolutePath(), new String[0]), new CopyOption[0]));
                return true;
            }
            catch (Exception e) {
                JDAImpl.LOG.error("Error while downloading an attachment", (Throwable)e);
                return false;
            }
        }

        public InputStream getInputStream() throws IOException {
            try (Response response = this.openConnection();){
                InputStream in = Requester.getBody(response);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(IOUtil.readFully(in));
                return byteArrayInputStream;
            }
        }

        public void withInputStream(IOConsumer<InputStream> then) throws IOException {
            Checks.notNull(then, "Consumer");
            try (Response response = this.openConnection();){
                then.accept(Requester.getBody(response));
            }
        }

        protected Response openConnection() throws IOException {
            OkHttpClient client = this.jda.getRequester().getHttpClient();
            Request request = new Request.Builder().url(this.getUrl()).addHeader("user-agent", Requester.USER_AGENT).addHeader("accept-encoding", "gzip").build();
            return client.newCall(request).execute();
        }

        public int getSize() {
            return this.size;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isImage() {
            return this.height > 0 && this.width > 0;
        }
    }

    public static enum MentionType {
        USER("<@!?(\\d+)>"),
        ROLE("<@&(\\d+)>"),
        CHANNEL("<#(\\d+)>"),
        EMOTE("<a?:([a-zA-Z0-9_]+):([0-9]+)>"),
        HERE("@here"),
        EVERYONE("@everyone");

        private final Pattern pattern;

        private MentionType(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

