/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.Region;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.ListedEmote;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.managers.AudioManager;
import net.dv8tion.jda.api.managers.GuildController;
import net.dv8tion.jda.api.managers.GuildManager;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.MemberAction;
import net.dv8tion.jda.api.requests.restaction.pagination.AuditLogPaginationAction;
import net.dv8tion.jda.api.utils.cache.MemberCacheView;
import net.dv8tion.jda.api.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.api.utils.cache.SortedSnowflakeCacheView;
import net.dv8tion.jda.internal.requests.EmptyRestAction;
import net.dv8tion.jda.internal.utils.Checks;

public interface Guild
extends ISnowflake {
    @CheckReturnValue
    default public RestAction<EnumSet<Region>> retrieveRegions() {
        return this.retrieveRegions(true);
    }

    @CheckReturnValue
    public RestAction<EnumSet<Region>> retrieveRegions(boolean var1);

    @CheckReturnValue
    public MemberAction addMember(String var1, String var2);

    @CheckReturnValue
    default public MemberAction addMember(String accessToken, User user) {
        Checks.notNull(user, "User");
        return this.addMember(accessToken, user.getId());
    }

    @CheckReturnValue
    default public MemberAction addMember(String accessToken, long userId) {
        return this.addMember(accessToken, Long.toUnsignedString(userId));
    }

    public String getName();

    public String getIconId();

    public String getIconUrl();

    public Set<String> getFeatures();

    public String getSplashId();

    public String getSplashUrl();

    @CheckReturnValue
    public RestAction<String> retrieveVanityUrl();

    public VoiceChannel getAfkChannel();

    public TextChannel getSystemChannel();

    public Member getOwner();

    public long getOwnerIdLong();

    default public String getOwnerId() {
        return Long.toUnsignedString(this.getOwnerIdLong());
    }

    public Timeout getAfkTimeout();

    default public Region getRegion() {
        return Region.fromKey(this.getRegionRaw());
    }

    public String getRegionRaw();

    public boolean isMember(User var1);

    public Member getSelfMember();

    public Member getMember(User var1);

    default public Member getMemberById(String userId) {
        return this.getMemberCache().getElementById(userId);
    }

    default public Member getMemberById(long userId) {
        return this.getMemberCache().getElementById(userId);
    }

    default public List<Member> getMembers() {
        return this.getMemberCache().asList();
    }

    default public List<Member> getMembersByName(String name, boolean ignoreCase) {
        return this.getMemberCache().getElementsByUsername(name, ignoreCase);
    }

    default public List<Member> getMembersByNickname(String nickname, boolean ignoreCase) {
        return this.getMemberCache().getElementsByNickname(nickname, ignoreCase);
    }

    default public List<Member> getMembersByEffectiveName(String name, boolean ignoreCase) {
        return this.getMemberCache().getElementsByName(name, ignoreCase);
    }

    default public List<Member> getMembersWithRoles(Role ... roles) {
        return this.getMemberCache().getElementsWithRoles(roles);
    }

    default public List<Member> getMembersWithRoles(Collection<Role> roles) {
        return this.getMemberCache().getElementsWithRoles(roles);
    }

    public MemberCacheView getMemberCache();

    default public Category getCategoryById(String id) {
        return (Category)this.getCategoryCache().getElementById(id);
    }

    default public Category getCategoryById(long id) {
        return (Category)this.getCategoryCache().getElementById(id);
    }

    default public List<Category> getCategories() {
        return this.getCategoryCache().asList();
    }

    default public List<Category> getCategoriesByName(String name, boolean ignoreCase) {
        return this.getCategoryCache().getElementsByName(name, ignoreCase);
    }

    public SortedSnowflakeCacheView<Category> getCategoryCache();

    default public TextChannel getTextChannelById(String id) {
        return (TextChannel)this.getTextChannelCache().getElementById(id);
    }

    default public TextChannel getTextChannelById(long id) {
        return (TextChannel)this.getTextChannelCache().getElementById(id);
    }

    default public List<TextChannel> getTextChannels() {
        return this.getTextChannelCache().asList();
    }

    default public List<TextChannel> getTextChannelsByName(String name, boolean ignoreCase) {
        return this.getTextChannelCache().getElementsByName(name, ignoreCase);
    }

    public SortedSnowflakeCacheView<TextChannel> getTextChannelCache();

    default public VoiceChannel getVoiceChannelById(String id) {
        return (VoiceChannel)this.getVoiceChannelCache().getElementById(id);
    }

    default public VoiceChannel getVoiceChannelById(long id) {
        return (VoiceChannel)this.getVoiceChannelCache().getElementById(id);
    }

    default public List<VoiceChannel> getVoiceChannels() {
        return this.getVoiceChannelCache().asList();
    }

    default public List<VoiceChannel> getVoiceChannelsByName(String name, boolean ignoreCase) {
        return this.getVoiceChannelCache().getElementsByName(name, ignoreCase);
    }

    public SortedSnowflakeCacheView<VoiceChannel> getVoiceChannelCache();

    default public List<GuildChannel> getChannels() {
        return this.getChannels(true);
    }

    public List<GuildChannel> getChannels(boolean var1);

    default public Role getRoleById(String id) {
        return (Role)this.getRoleCache().getElementById(id);
    }

    default public Role getRoleById(long id) {
        return (Role)this.getRoleCache().getElementById(id);
    }

    default public List<Role> getRoles() {
        return this.getRoleCache().asList();
    }

    default public List<Role> getRolesByName(String name, boolean ignoreCase) {
        return this.getRoleCache().getElementsByName(name, ignoreCase);
    }

    public SortedSnowflakeCacheView<Role> getRoleCache();

    default public Emote getEmoteById(String id) {
        return this.getEmoteCache().getElementById(id);
    }

    default public Emote getEmoteById(long id) {
        return this.getEmoteCache().getElementById(id);
    }

    default public List<Emote> getEmotes() {
        return this.getEmoteCache().asList();
    }

    default public List<Emote> getEmotesByName(String name, boolean ignoreCase) {
        return this.getEmoteCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<Emote> getEmoteCache();

    @Nonnull
    @CheckReturnValue
    public RestAction<List<ListedEmote>> retrieveEmotes();

    @Nonnull
    @CheckReturnValue
    public RestAction<ListedEmote> retrieveEmoteById(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    default public RestAction<ListedEmote> retrieveEmoteById(long id) {
        return this.retrieveEmoteById(Long.toUnsignedString(id));
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<ListedEmote> retrieveEmote(@Nonnull Emote emote) {
        ListedEmote listedEmote;
        Checks.notNull(emote, "Emote");
        if (emote.getGuild() != null) {
            Checks.check(emote.getGuild().equals(this), "Emote must be from the same Guild!");
        }
        if (emote instanceof ListedEmote && !emote.isFake() && ((listedEmote = (ListedEmote)emote).hasUser() || !this.getSelfMember().hasPermission(Permission.MANAGE_EMOTES))) {
            return new EmptyRestAction<ListedEmote>(this.getJDA(), listedEmote);
        }
        return this.retrieveEmoteById(emote.getId());
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<List<Ban>> retrieveBanList();

    @Nonnull
    @CheckReturnValue
    default public RestAction<Ban> retrieveBanById(long userId) {
        return this.retrieveBanById(Long.toUnsignedString(userId));
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Ban> retrieveBanById(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    default public RestAction<Ban> retrieveBan(@Nonnull User bannedUser) {
        Checks.notNull(bannedUser, "bannedUser");
        return this.retrieveBanById(bannedUser.getId());
    }

    @CheckReturnValue
    public RestAction<Integer> retrievePrunableMemberCount(int var1);

    public Role getPublicRole();

    @Nullable
    public TextChannel getDefaultChannel();

    public GuildManager getManager();

    public GuildController getController();

    @CheckReturnValue
    public AuditLogPaginationAction retrieveAuditLogs();

    @CheckReturnValue
    public RestAction<Void> leave();

    @CheckReturnValue
    public RestAction<Void> delete();

    @CheckReturnValue
    public RestAction<Void> delete(String var1);

    public AudioManager getAudioManager();

    public JDA getJDA();

    @CheckReturnValue
    public RestAction<List<Invite>> retrieveInvites();

    @CheckReturnValue
    public RestAction<List<Webhook>> retrieveWebhooks();

    public List<GuildVoiceState> getVoiceStates();

    public VerificationLevel getVerificationLevel();

    public NotificationLevel getDefaultNotificationLevel();

    public MFALevel getRequiredMFALevel();

    public ExplicitContentLevel getExplicitContentLevel();

    public boolean checkVerification();

    public boolean isAvailable();

    public static class Ban {
        protected final User user;
        protected final String reason;

        public Ban(User user, String reason) {
            this.user = user;
            this.reason = reason;
        }

        @Nonnull
        public User getUser() {
            return this.user;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "GuildBan:" + this.user + (this.reason == null ? "" : '(' + this.reason + ')');
        }
    }

    public static enum ExplicitContentLevel {
        OFF(0, "Don't scan any messages."),
        NO_ROLE(1, "Scan messages from members without a role."),
        ALL(2, "Scan messages sent by all members."),
        UNKNOWN(-1, "Unknown filter level!");

        private final int key;
        private final String description;

        private ExplicitContentLevel(int key, String description) {
            this.key = key;
            this.description = description;
        }

        public int getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public static ExplicitContentLevel fromKey(int key) {
            for (ExplicitContentLevel level : ExplicitContentLevel.values()) {
                if (level.key != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }

    public static enum MFALevel {
        NONE(0),
        TWO_FACTOR_AUTH(1),
        UNKNOWN(-1);

        private final int key;

        private MFALevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static MFALevel fromKey(int key) {
            for (MFALevel level : MFALevel.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }

    public static enum NotificationLevel {
        ALL_MESSAGES(0),
        MENTIONS_ONLY(1),
        UNKNOWN(-1);

        private final int key;

        private NotificationLevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static NotificationLevel fromKey(int key) {
            for (NotificationLevel level : NotificationLevel.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }

    public static enum VerificationLevel {
        NONE(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        VERY_HIGH(4),
        UNKNOWN(-1);

        private final int key;

        private VerificationLevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static VerificationLevel fromKey(int key) {
            for (VerificationLevel level : VerificationLevel.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }

    public static enum Timeout {
        SECONDS_60(60),
        SECONDS_300(300),
        SECONDS_900(900),
        SECONDS_1800(1800),
        SECONDS_3600(3600);

        private final int seconds;

        private Timeout(int seconds) {
            this.seconds = seconds;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public static Timeout fromKey(int seconds) {
            for (Timeout t : Timeout.values()) {
                if (t.getSeconds() != seconds) continue;
                return t;
            }
            throw new IllegalArgumentException("Provided key was not recognized. Seconds: " + seconds);
        }
    }
}

