/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api;

import com.neovisionaries.ws.client.WebSocketFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.annotations.Incubating;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.exceptions.AccountTypeException;
import net.dv8tion.jda.api.hooks.IEventManager;
import net.dv8tion.jda.api.hooks.VoiceDispatchInterceptor;
import net.dv8tion.jda.api.utils.SessionController;
import net.dv8tion.jda.api.utils.SessionControllerAdapter;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.managers.PresenceImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.config.AuthorizationConfig;
import net.dv8tion.jda.internal.utils.config.MetaConfig;
import net.dv8tion.jda.internal.utils.config.SessionConfig;
import net.dv8tion.jda.internal.utils.config.ThreadingConfig;
import okhttp3.OkHttpClient;

public class JDABuilder {
    protected final List<Object> listeners;
    protected final AccountType accountType;
    protected ScheduledExecutorService rateLimitPool = null;
    protected boolean shutdownRateLimitPool = true;
    protected ScheduledExecutorService mainWsPool = null;
    protected boolean shutdownMainWsPool = true;
    protected ExecutorService callbackPool = null;
    protected boolean shutdownCallbackPool = true;
    protected EnumSet<CacheFlag> cacheFlags = EnumSet.allOf(CacheFlag.class);
    protected ConcurrentMap<String, String> contextMap = null;
    protected SessionController controller = null;
    protected VoiceDispatchInterceptor voiceDispatchInterceptor = null;
    protected OkHttpClient.Builder httpClientBuilder = null;
    protected OkHttpClient httpClient = null;
    protected WebSocketFactory wsFactory = null;
    protected String token = null;
    protected IEventManager eventManager = null;
    protected IAudioSendFactory audioSendFactory = null;
    protected JDA.ShardInfo shardInfo = null;
    protected Activity activity = null;
    protected OnlineStatus status = OnlineStatus.ONLINE;
    protected int maxReconnectDelay = 900;
    protected boolean enableContext = true;
    protected boolean enableVoice = true;
    protected boolean enableShutdownHook = true;
    protected boolean enableBulkDeleteSplitting = true;
    protected boolean autoReconnect = true;
    protected boolean idle = false;
    protected boolean requestTimeoutRetry = true;
    protected boolean enableCompression = true;

    public JDABuilder() {
        this(AccountType.BOT);
    }

    public JDABuilder(String token) {
        this();
        this.setToken(token);
    }

    @Incubating
    public JDABuilder(AccountType accountType) {
        Checks.notNull((Object)accountType, "accountType");
        this.accountType = accountType;
        this.listeners = new LinkedList<Object>();
    }

    public JDABuilder setEnabledCacheFlags(EnumSet<CacheFlag> flags) {
        this.cacheFlags = flags == null ? EnumSet.noneOf(CacheFlag.class) : EnumSet.copyOf(flags);
        return this;
    }

    public JDABuilder setDisabledCacheFlags(EnumSet<CacheFlag> flags) {
        return this.setEnabledCacheFlags(EnumSet.complementOf(flags));
    }

    public JDABuilder setContextMap(ConcurrentMap<String, String> map) {
        this.contextMap = map;
        if (map != null) {
            this.enableContext = true;
        }
        return this;
    }

    public JDABuilder setContextEnabled(boolean enable) {
        this.enableContext = enable;
        return this;
    }

    public JDABuilder setCompressionEnabled(boolean enable) {
        this.enableCompression = enable;
        return this;
    }

    public JDABuilder setRequestTimeoutRetry(boolean retryOnTimeout) {
        this.requestTimeoutRetry = retryOnTimeout;
        return this;
    }

    public JDABuilder setToken(String token) {
        this.token = token;
        return this;
    }

    public JDABuilder setHttpClientBuilder(OkHttpClient.Builder builder) {
        this.httpClientBuilder = builder;
        return this;
    }

    public JDABuilder setHttpClient(OkHttpClient client) {
        this.httpClient = client;
        return this;
    }

    public JDABuilder setWebsocketFactory(WebSocketFactory factory) {
        this.wsFactory = factory;
        return this;
    }

    public JDABuilder setRateLimitPool(ScheduledExecutorService pool) {
        return this.setRateLimitPool(pool, pool == null);
    }

    public JDABuilder setRateLimitPool(ScheduledExecutorService pool, boolean automaticShutdown) {
        this.rateLimitPool = pool;
        this.shutdownRateLimitPool = automaticShutdown;
        return this;
    }

    public JDABuilder setGatewayPool(ScheduledExecutorService pool) {
        return this.setGatewayPool(pool, pool == null);
    }

    public JDABuilder setGatewayPool(ScheduledExecutorService pool, boolean automaticShutdown) {
        this.mainWsPool = pool;
        this.shutdownMainWsPool = automaticShutdown;
        return this;
    }

    public JDABuilder setCallbackPool(ExecutorService executor) {
        return this.setCallbackPool(executor, executor == null);
    }

    public JDABuilder setCallbackPool(ExecutorService executor, boolean automaticShutdown) {
        this.callbackPool = executor;
        this.shutdownCallbackPool = automaticShutdown;
        return this;
    }

    public JDABuilder setAudioEnabled(boolean enabled) {
        this.enableVoice = enabled;
        return this;
    }

    public JDABuilder setBulkDeleteSplittingEnabled(boolean enabled) {
        this.enableBulkDeleteSplitting = enabled;
        return this;
    }

    public JDABuilder setEnableShutdownHook(boolean enable) {
        this.enableShutdownHook = enable;
        return this;
    }

    public JDABuilder setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public JDABuilder setEventManager(IEventManager manager) {
        this.eventManager = manager;
        return this;
    }

    public JDABuilder setAudioSendFactory(IAudioSendFactory factory) {
        this.audioSendFactory = factory;
        return this;
    }

    public JDABuilder setIdle(boolean idle) {
        this.idle = idle;
        return this;
    }

    public JDABuilder setActivity(Activity activity) {
        this.activity = activity;
        return this;
    }

    public JDABuilder setStatus(OnlineStatus status) {
        if (status == null || status == OnlineStatus.UNKNOWN) {
            throw new IllegalArgumentException("OnlineStatus cannot be null or unknown!");
        }
        this.status = status;
        return this;
    }

    public JDABuilder addEventListeners(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        Collections.addAll(this.listeners, listeners);
        return this;
    }

    public JDABuilder removeEventListeners(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        this.listeners.removeAll(Arrays.asList(listeners));
        return this;
    }

    public JDABuilder setMaxReconnectDelay(int maxReconnectDelay) {
        Checks.check(maxReconnectDelay >= 32, "Max reconnect delay must be 32 seconds or greater. You provided %d.", (Object)maxReconnectDelay);
        this.maxReconnectDelay = maxReconnectDelay;
        return this;
    }

    public JDABuilder useSharding(int shardId, int shardTotal) {
        AccountTypeException.check(this.accountType, AccountType.BOT);
        Checks.notNegative(shardId, "Shard ID");
        Checks.positive(shardTotal, "Shard Total");
        Checks.check(shardId < shardTotal, "The shard ID must be lower than the shardTotal! Shard IDs are 0-based.");
        this.shardInfo = new JDA.ShardInfo(shardId, shardTotal);
        return this;
    }

    public JDABuilder setSessionController(SessionController controller) {
        this.controller = controller;
        return this;
    }

    public JDABuilder setVoiceDispatchInterceptor(VoiceDispatchInterceptor interceptor) {
        this.voiceDispatchInterceptor = interceptor;
        return this;
    }

    public JDA build() throws LoginException {
        WebSocketFactory wsFactory;
        OkHttpClient httpClient = this.httpClient;
        if (httpClient == null) {
            if (this.httpClientBuilder == null) {
                this.httpClientBuilder = new OkHttpClient.Builder();
            }
            httpClient = this.httpClientBuilder.build();
        }
        WebSocketFactory webSocketFactory = wsFactory = this.wsFactory == null ? new WebSocketFactory() : this.wsFactory;
        if (this.controller == null && this.shardInfo != null) {
            this.controller = new SessionControllerAdapter();
        }
        AuthorizationConfig authConfig = new AuthorizationConfig(this.accountType, this.token);
        ThreadingConfig threadingConfig = new ThreadingConfig();
        threadingConfig.setCallbackPool(this.callbackPool, this.shutdownCallbackPool);
        threadingConfig.setGatewayPool(this.mainWsPool, this.shutdownMainWsPool);
        threadingConfig.setRateLimitPool(this.rateLimitPool, this.shutdownRateLimitPool);
        SessionConfig sessionConfig = new SessionConfig(this.controller, httpClient, wsFactory, this.voiceDispatchInterceptor, this.enableVoice, this.requestTimeoutRetry, this.autoReconnect, this.enableBulkDeleteSplitting, this.maxReconnectDelay);
        MetaConfig metaConfig = new MetaConfig(this.contextMap, this.cacheFlags, this.enableContext, this.enableShutdownHook);
        JDAImpl jda = new JDAImpl(authConfig, sessionConfig, threadingConfig, metaConfig);
        if (this.eventManager != null) {
            jda.setEventManager(this.eventManager);
        }
        if (this.audioSendFactory != null) {
            jda.setAudioSendFactory(this.audioSendFactory);
        }
        this.listeners.forEach(xva$0 -> jda.addEventListener(xva$0));
        jda.setStatus(JDA.Status.INITIALIZED);
        ((PresenceImpl)jda.getPresence()).setCacheActivity(this.activity).setCacheIdle(this.idle).setCacheStatus(this.status);
        jda.login(this.shardInfo, this.enableCompression, true);
        return jda;
    }
}

