/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import javax.annotation.Nullable;
import net.dv8tion.jda.core.entities.ISnowflake;

public class MessageActivity {
    private final ActivityType type;
    private final String partyId;
    private final Application application;

    MessageActivity(ActivityType type, String partyId, Application application) {
        this.type = type;
        this.partyId = partyId;
        this.application = application;
    }

    public ActivityType getType() {
        return this.type;
    }

    @Nullable
    public String getPartyId() {
        return this.partyId;
    }

    @Nullable
    public Application getApplication() {
        return this.application;
    }

    public static enum ActivityType {
        JOIN(1),
        SPECTATE(2),
        LISTENING(3),
        JOIN_REQUEST(5),
        UNKNOWN(-1);

        private final int id;

        private ActivityType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static ActivityType fromId(int id) {
            for (ActivityType activityType : ActivityType.values()) {
                if (activityType.id != id) continue;
                return activityType;
            }
            return UNKNOWN;
        }
    }

    public static class Application
    implements ISnowflake {
        private final String name;
        private final String description;
        private final String iconId;
        private final String coverId;
        private final long id;

        public Application(String name, String description, String iconId, String coverId, long id) {
            this.name = name;
            this.description = description;
            this.iconId = iconId;
            this.coverId = coverId;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIconId() {
            return this.iconId;
        }

        public String getIconUrl() {
            return "https://cdn.discordapp.com/application/" + this.getId() + "/" + this.iconId + ".png";
        }

        public String getCoverId() {
            return this.coverId;
        }

        public String getCoverUrl() {
            return "https://cdn.discordapp.com/application/" + this.getId() + "/" + this.coverId + ".png";
        }

        @Override
        public long getIdLong() {
            return this.id;
        }
    }
}

