/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.dv8tion.jda.bot.entities.ApplicationInfo;
import net.dv8tion.jda.bot.entities.impl.ApplicationInfoImpl;
import net.dv8tion.jda.client.entities.Application;
import net.dv8tion.jda.client.entities.AuthorizedApplication;
import net.dv8tion.jda.client.entities.Friend;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.entities.impl.ApplicationImpl;
import net.dv8tion.jda.client.entities.impl.AuthorizedApplicationImpl;
import net.dv8tion.jda.client.entities.impl.BlockedUserImpl;
import net.dv8tion.jda.client.entities.impl.FriendImpl;
import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.entities.impl.IncomingFriendRequestImpl;
import net.dv8tion.jda.client.entities.impl.OutgoingFriendRequestImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.audit.ActionType;
import net.dv8tion.jda.core.audit.AuditLogChange;
import net.dv8tion.jda.core.audit.AuditLogEntry;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.EmbedType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageActivity;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageReaction;
import net.dv8tion.jda.core.entities.MessageType;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.RichPresence;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.SelfUser;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.dv8tion.jda.core.entities.impl.CategoryImpl;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.GuildVoiceStateImpl;
import net.dv8tion.jda.core.entities.impl.InviteImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.ReceivedMessage;
import net.dv8tion.jda.core.entities.impl.RoleImpl;
import net.dv8tion.jda.core.entities.impl.SelfUserImpl;
import net.dv8tion.jda.core.entities.impl.SystemMessage;
import net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.core.entities.impl.WebhookImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.utils.Helpers;
import net.dv8tion.jda.core.utils.JDALogger;
import net.dv8tion.jda.core.utils.cache.CacheFlag;
import net.dv8tion.jda.core.utils.cache.UpstreamReference;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class EntityBuilder {
    public static final Logger LOG = JDALogger.getLog(EntityBuilder.class);
    public static final String MISSING_CHANNEL = "MISSING_CHANNEL";
    public static final String MISSING_USER = "MISSING_USER";
    public static final String UNKNOWN_MESSAGE_TYPE = "UNKNOWN_MESSAGE_TYPE";
    private static final Set<String> richGameFields;
    protected final UpstreamReference<JDAImpl> api;

    public EntityBuilder(JDA api) {
        this.api = new UpstreamReference<JDAImpl>((JDAImpl)api);
    }

    public JDAImpl getJDA() {
        return this.api.get();
    }

    public SelfUser createSelfUser(JSONObject self) {
        SelfUserImpl selfUser = (SelfUserImpl)this.getJDA().getSelfUser();
        if (selfUser == null) {
            long id = self.getLong("id");
            selfUser = new SelfUserImpl(id, this.getJDA());
            this.getJDA().setSelfUser(selfUser);
        }
        if (!this.getJDA().getUserMap().containsKey(selfUser.getIdLong())) {
            this.getJDA().getUserMap().put(selfUser.getIdLong(), (Object)selfUser);
        }
        selfUser.setVerified(self.getBoolean("verified")).setMfaEnabled(self.getBoolean("mfa_enabled")).setName(self.getString("username")).setDiscriminator(self.getString("discriminator")).setAvatarId(self.optString("avatar", null)).setBot(Helpers.optBoolean(self, "bot"));
        if (this.getJDA().getAccountType() == AccountType.CLIENT) {
            selfUser.setEmail(self.optString("email", null)).setMobile(Helpers.optBoolean(self, "mobile")).setNitro(Helpers.optBoolean(self, "premium")).setPhoneNumber(self.optString("phone", null));
        }
        return selfUser;
    }

    public Game createGame(String name, String url, Game.GameType type) {
        return new Game(name, url, type);
    }

    private void createGuildEmotePass(GuildImpl guildObj, JSONArray array) {
        if (!this.getJDA().isCacheFlagSet(CacheFlag.EMOTE)) {
            return;
        }
        TLongObjectMap<Emote> emoteMap = guildObj.getEmoteMap();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.getJSONObject(i);
            if (object.isNull("id")) {
                LOG.error("Received GUILD_CREATE with an emoji with a null ID. JSON: {}", (Object)object);
                continue;
            }
            long emoteId = object.getLong("id");
            emoteMap.put(emoteId, (Object)this.createEmote(guildObj, object, false));
        }
    }

    public GuildImpl createGuild(long guildId, JSONObject guildJson, TLongObjectMap<JSONObject> members) {
        int i;
        GuildImpl guildObj = new GuildImpl(this.getJDA(), guildId);
        String name = guildJson.optString("name", "");
        String iconId = guildJson.optString("icon", null);
        String splashId = guildJson.optString("splash", null);
        String region = guildJson.optString("region", null);
        JSONArray roleArray = guildJson.getJSONArray("roles");
        JSONArray channelArray = guildJson.getJSONArray("channels");
        JSONArray emotesArray = guildJson.getJSONArray("emojis");
        JSONArray voiceStateArray = guildJson.getJSONArray("voice_states");
        JSONArray featuresArray = guildJson.optJSONArray("features");
        JSONArray presencesArray = guildJson.optJSONArray("presences");
        long ownerId = Helpers.optLong(guildJson, "owner_id", 0L);
        long afkChannelId = Helpers.optLong(guildJson, "afk_channel_id", 0L);
        long systemChannelId = Helpers.optLong(guildJson, "system_channel_id", 0L);
        int mfaLevel = Helpers.optInt(guildJson, "mfa_level", 0);
        int afkTimeout = Helpers.optInt(guildJson, "afk_timeout", 0);
        int verificationLevel = Helpers.optInt(guildJson, "verification_level", 0);
        int notificationLevel = Helpers.optInt(guildJson, "default_message_notifications", 0);
        int explicitContentLevel = Helpers.optInt(guildJson, "explicit_content_filter", 0);
        guildObj.setAvailable(true).setName(name).setIconId(iconId).setSplashId(splashId).setRegion(region).setOwnerId(ownerId).setAfkTimeout(Guild.Timeout.fromKey(afkTimeout)).setVerificationLevel(Guild.VerificationLevel.fromKey(verificationLevel)).setDefaultNotificationLevel(Guild.NotificationLevel.fromKey(notificationLevel)).setExplicitContentLevel(Guild.ExplicitContentLevel.fromKey(explicitContentLevel)).setRequiredMFALevel(Guild.MFALevel.fromKey(mfaLevel));
        if (featuresArray == null) {
            guildObj.setFeatures(Collections.emptySet());
        } else {
            guildObj.setFeatures(StreamSupport.stream(featuresArray.spliterator(), false).map(String::valueOf).collect(Collectors.toSet()));
        }
        for (int i2 = 0; i2 < roleArray.length(); ++i2) {
            JSONObject obj = roleArray.getJSONObject(i2);
            Role role = this.createRole(guildObj, obj, guildId);
            guildObj.getRolesMap().put(role.getIdLong(), (Object)role);
            if (role.getIdLong() != guildObj.getIdLong()) continue;
            guildObj.setPublicRole(role);
        }
        for (JSONObject memberJson : members.valueCollection()) {
            this.createMember(guildObj, memberJson);
        }
        if (guildObj.getOwner() == null) {
            LOG.warn("Finished setup for guild with a null owner. GuildId: {} OwnerId: {}", (Object)guildId, guildJson.opt("owner_id"));
        }
        for (i = 0; i < channelArray.length(); ++i) {
            JSONObject channelJson = channelArray.getJSONObject(i);
            this.createGuildChannel(guildObj, channelJson);
        }
        this.createGuildEmotePass(guildObj, emotesArray);
        this.createGuildVoiceStatePass(guildObj, voiceStateArray);
        guildObj.setAfkChannel(guildObj.getVoiceChannelById(afkChannelId)).setSystemChannel(guildObj.getTextChannelById(systemChannelId));
        for (i = 0; i < presencesArray.length(); ++i) {
            JSONObject presence = presencesArray.getJSONObject(i);
            long userId = presence.getJSONObject("user").getLong("id");
            MemberImpl member = (MemberImpl)guildObj.getMembersMap().get(userId);
            if (member == null) {
                LOG.debug("Received a ghost presence in GuildFirstPass! UserId: {} Guild: {}", (Object)userId, (Object)guildObj);
                continue;
            }
            this.createPresence(member, presence);
        }
        this.getJDA().getGuildMap().put(guildId, (Object)guildObj);
        return guildObj;
    }

    private void createGuildChannel(GuildImpl guildObj, JSONObject channelData) {
        ChannelType channelType = ChannelType.fromId(channelData.getInt("type"));
        switch (channelType) {
            case TEXT: {
                this.createTextChannel(guildObj, channelData, guildObj.getIdLong());
                break;
            }
            case VOICE: {
                this.createVoiceChannel(guildObj, channelData, guildObj.getIdLong());
                break;
            }
            case CATEGORY: {
                this.createCategory(guildObj, channelData, guildObj.getIdLong());
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create channel for type " + channelData.getInt("type"));
            }
        }
    }

    public void createGuildVoiceStatePass(GuildImpl guildObj, JSONArray voiceStates) {
        for (int i = 0; i < voiceStates.length(); ++i) {
            JSONObject voiceStateJson = voiceStates.getJSONObject(i);
            long userId = voiceStateJson.getLong("user_id");
            Member member = (Member)guildObj.getMembersMap().get(userId);
            if (member == null) {
                LOG.error("Received a VoiceState for a unknown Member! GuildId: " + guildObj.getId() + " MemberId: " + voiceStateJson.getString("user_id"));
                continue;
            }
            GuildVoiceStateImpl voiceState = (GuildVoiceStateImpl)member.getVoiceState();
            if (voiceState == null) continue;
            long channelId = voiceStateJson.getLong("channel_id");
            VoiceChannelImpl voiceChannel = (VoiceChannelImpl)guildObj.getVoiceChannelsMap().get(channelId);
            if (voiceChannel != null) {
                voiceChannel.getConnectedMembersMap().put(member.getUser().getIdLong(), (Object)member);
            } else {
                LOG.error("Received a GuildVoiceState with a channel ID for a non-existent channel! ChannelId: {} GuildId: {} UserId: {}", new Object[]{channelId, guildObj.getId(), userId});
            }
            voiceState.setSelfMuted(Helpers.optBoolean(voiceStateJson, "self_mute")).setSelfDeafened(Helpers.optBoolean(voiceStateJson, "self_deaf")).setGuildMuted(Helpers.optBoolean(voiceStateJson, "mute")).setGuildDeafened(Helpers.optBoolean(voiceStateJson, "deaf")).setSuppressed(Helpers.optBoolean(voiceStateJson, "suppress")).setSessionId(voiceStateJson.optString("session_id")).setConnectedChannel(voiceChannel);
        }
    }

    public UserImpl createFakeUser(JSONObject user, boolean modifyCache) {
        return this.createUser(user, true, modifyCache);
    }

    public UserImpl createUser(JSONObject user) {
        return this.createUser(user, false, true);
    }

    private UserImpl createUser(JSONObject user, boolean fake, boolean modifyCache) {
        long id = user.getLong("id");
        UserImpl userObj = (UserImpl)this.getJDA().getUserMap().get(id);
        if (userObj == null) {
            userObj = (UserImpl)this.getJDA().getFakeUserMap().get(id);
            if (userObj != null) {
                if (!fake && modifyCache) {
                    this.getJDA().getFakeUserMap().remove(id);
                    userObj.setFake(false);
                    this.getJDA().getUserMap().put(userObj.getIdLong(), (Object)userObj);
                    if (userObj.hasPrivateChannel()) {
                        PrivateChannelImpl priv = (PrivateChannelImpl)userObj.getPrivateChannel();
                        priv.setFake(false);
                        this.getJDA().getFakePrivateChannelMap().remove(priv.getIdLong());
                        this.getJDA().getPrivateChannelMap().put(priv.getIdLong(), (Object)priv);
                    }
                }
            } else {
                userObj = new UserImpl(id, this.getJDA()).setFake(fake);
                if (modifyCache) {
                    if (fake) {
                        this.getJDA().getFakeUserMap().put(id, (Object)userObj);
                    } else {
                        this.getJDA().getUserMap().put(id, (Object)userObj);
                    }
                }
            }
        }
        userObj.setName(user.getString("username")).setDiscriminator(user.get("discriminator").toString()).setAvatarId(user.optString("avatar", null)).setBot(Helpers.optBoolean(user, "bot"));
        if (!fake && modifyCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.USER, id);
        }
        return userObj;
    }

    public Member createMember(GuildImpl guild, JSONObject memberJson) {
        GuildVoiceStateImpl state;
        boolean playbackCache = false;
        UserImpl user = this.createUser(memberJson.getJSONObject("user"));
        MemberImpl member = (MemberImpl)guild.getMember(user);
        if (member == null) {
            member = new MemberImpl(guild, user);
            boolean bl = playbackCache = guild.getMembersMap().put(user.getIdLong(), (Object)member) == null;
            if (guild.getOwnerIdLong() == user.getIdLong()) {
                LOG.trace("Found owner of guild with id {}", (Object)guild.getId());
                guild.setOwner(member);
            }
        }
        if ((state = (GuildVoiceStateImpl)member.getVoiceState()) != null) {
            state.setGuildMuted(memberJson.getBoolean("mute")).setGuildDeafened(memberJson.getBoolean("deaf"));
        }
        TemporalAccessor joinedAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(memberJson.getString("joined_at"));
        member.setJoinDate(Instant.from(joinedAt).toEpochMilli()).setNickname(memberJson.optString("nick", null));
        JSONArray rolesJson = memberJson.getJSONArray("roles");
        for (int k = 0; k < rolesJson.length(); ++k) {
            long roleId = rolesJson.getLong(k);
            Role r = (Role)guild.getRolesMap().get(roleId);
            if (r == null) {
                LOG.debug("Received a Member with an unknown Role. MemberId: {} GuildId: {} roleId: {}", new Object[]{member.getUser().getId(), guild.getId(), roleId});
                continue;
            }
            member.getRoleSet().add(r);
        }
        if (playbackCache) {
            long hashId = guild.getIdLong() ^ user.getIdLong();
            this.getJDA().getEventCache().playbackCache(EventCache.Type.MEMBER, hashId);
        }
        return member;
    }

    public void createPresence(Object memberOrFriend, JSONObject presenceJson) {
        if (memberOrFriend == null) {
            throw new NullPointerException("Provided memberOrFriend was null!");
        }
        boolean cacheGame = this.getJDA().isCacheFlagSet(CacheFlag.GAME);
        JSONObject gameJson = !cacheGame || presenceJson.isNull("game") ? null : presenceJson.getJSONObject("game");
        OnlineStatus onlineStatus = OnlineStatus.fromKey(presenceJson.getString("status"));
        Game game = null;
        boolean parsedGame = false;
        if (cacheGame && gameJson != null && !gameJson.isNull("name")) {
            try {
                game = EntityBuilder.createGame(gameJson);
                parsedGame = true;
            }
            catch (Exception ex) {
                String userId = memberOrFriend instanceof Member ? ((Member)memberOrFriend).getUser().getId() : (memberOrFriend instanceof Friend ? ((Friend)memberOrFriend).getUser().getId() : "unknown");
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Encountered exception trying to parse a presence! UserId: {} JSON: {}", new Object[]{userId, gameJson, ex});
                }
                LOG.warn("Encountered exception trying to parse a presence! UserId: {} Message: {} Enable debug for details", (Object)userId, (Object)ex.getMessage());
            }
        }
        if (memberOrFriend instanceof Member) {
            MemberImpl member = (MemberImpl)memberOrFriend;
            member.setOnlineStatus(onlineStatus);
            if (cacheGame && parsedGame) {
                member.setGame(game);
            }
        } else if (memberOrFriend instanceof Friend) {
            FriendImpl friend = (FriendImpl)memberOrFriend;
            friend.setOnlineStatus(onlineStatus);
            if (cacheGame && parsedGame) {
                friend.setGame(game);
            }
            OffsetDateTime lastModified = OffsetDateTime.ofInstant(Instant.ofEpochMilli(presenceJson.getLong("last_modified")), TimeZone.getTimeZone("GMT").toZoneId());
            friend.setOnlineStatusModifiedTime(lastModified);
        } else {
            throw new IllegalArgumentException("An object was provided to EntityBuilder#createPresence that wasn't a Member or Friend. JSON: " + presenceJson);
        }
    }

    public static Game createGame(JSONObject gameJson) {
        Game.GameType type;
        String name = String.valueOf(gameJson.get("name"));
        String url = gameJson.isNull("url") ? null : String.valueOf(gameJson.get("url"));
        try {
            type = gameJson.isNull("type") ? Game.GameType.DEFAULT : Game.GameType.fromKey(Integer.parseInt(gameJson.get("type").toString()));
        }
        catch (NumberFormatException e) {
            type = Game.GameType.DEFAULT;
        }
        RichPresence.Timestamps timestamps = null;
        if (!gameJson.isNull("timestamps")) {
            JSONObject obj = gameJson.getJSONObject("timestamps");
            long start = obj.isNull("start") ? 0L : obj.getLong("start");
            long end = obj.isNull("end") ? 0L : obj.getLong("end");
            timestamps = new RichPresence.Timestamps(start, end);
        }
        if (!CollectionUtils.containsAny((Collection)gameJson.keySet(), richGameFields)) {
            return new Game(name, url, type, timestamps);
        }
        long id = Helpers.optLong(gameJson, "application_id", 0L);
        String sessionId = gameJson.optString("session_id", null);
        String syncId = gameJson.optString("sync_id", null);
        int flags = Helpers.optInt(gameJson, "flags", 0);
        String details = gameJson.isNull("details") ? null : String.valueOf(gameJson.get("details"));
        String state = gameJson.isNull("state") ? null : String.valueOf(gameJson.get("state"));
        RichPresence.Party party = null;
        if (!gameJson.isNull("party")) {
            JSONObject obj = gameJson.getJSONObject("party");
            String partyId = obj.isNull("id") ? null : obj.getString("id");
            JSONArray sizeArr = obj.isNull("size") ? null : obj.getJSONArray("size");
            long size = 0L;
            long max = 0L;
            if (sizeArr != null && sizeArr.length() > 0) {
                size = sizeArr.getLong(0);
                max = sizeArr.isNull(1) ? 0L : sizeArr.getLong(1);
            }
            party = new RichPresence.Party(partyId, size, max);
        }
        String smallImageKey = null;
        String smallImageText = null;
        String largeImageKey = null;
        String largeImageText = null;
        if (!gameJson.isNull("assets")) {
            JSONObject assets = gameJson.getJSONObject("assets");
            if (!assets.isNull("small_image")) {
                smallImageKey = String.valueOf(assets.get("small_image"));
                String string = smallImageText = assets.isNull("small_text") ? null : String.valueOf(assets.get("small_text"));
            }
            if (!assets.isNull("large_image")) {
                largeImageKey = String.valueOf(assets.get("large_image"));
                largeImageText = assets.isNull("large_text") ? null : String.valueOf(assets.get("large_text"));
            }
        }
        return new RichPresence(type, name, url, id, party, details, state, timestamps, syncId, sessionId, flags, largeImageKey, largeImageText, smallImageKey, smallImageText);
    }

    public EmoteImpl createEmote(GuildImpl guildObj, JSONObject json, boolean fake) {
        JSONArray emoteRoles = json.isNull("roles") ? new JSONArray() : json.getJSONArray("roles");
        long emoteId = json.getLong("id");
        UserImpl user = json.isNull("user") ? null : this.createFakeUser(json.getJSONObject("user"), false);
        EmoteImpl emoteObj = (EmoteImpl)guildObj.getEmoteById(emoteId);
        if (emoteObj == null) {
            emoteObj = new EmoteImpl(emoteId, guildObj, fake);
        }
        Set<Role> roleSet = emoteObj.getRoleSet();
        roleSet.clear();
        for (int j = 0; j < emoteRoles.length(); ++j) {
            Role role = guildObj.getRoleById(emoteRoles.getString(j));
            if (role == null) continue;
            roleSet.add(role);
        }
        if (user != null) {
            emoteObj.setUser(user);
        }
        return emoteObj.setName(json.optString("name")).setAnimated(json.optBoolean("animated")).setManaged(Helpers.optBoolean(json, "managed"));
    }

    public Category createCategory(JSONObject json, long guildId) {
        return this.createCategory(null, json, guildId);
    }

    public Category createCategory(GuildImpl guild, JSONObject json, long guildId) {
        boolean playbackCache = false;
        long id = json.getLong("id");
        CategoryImpl channel = (CategoryImpl)this.getJDA().getCategoryMap().get(id);
        if (channel == null) {
            if (guild == null) {
                guild = (GuildImpl)this.getJDA().getGuildMap().get(guildId);
            }
            channel = new CategoryImpl(id, guild);
            guild.getCategoriesMap().put(id, (Object)channel);
            boolean bl = playbackCache = this.getJDA().getCategoryMap().put(id, (Object)channel) == null;
        }
        if (!json.isNull("permission_overwrites")) {
            JSONArray overrides = json.getJSONArray("permission_overwrites");
            this.createOverridesPass(channel, overrides);
        }
        ((CategoryImpl)channel.setName(json.getString("name"))).setPosition(json.getInt("position"));
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, id);
        }
        return channel;
    }

    public TextChannel createTextChannel(JSONObject json, long guildId) {
        return this.createTextChannel(null, json, guildId);
    }

    public TextChannel createTextChannel(GuildImpl guildObj, JSONObject json, long guildId) {
        boolean playbackCache = false;
        long id = json.getLong("id");
        TextChannelImpl channel = (TextChannelImpl)this.getJDA().getTextChannelMap().get(id);
        if (channel == null) {
            if (guildObj == null) {
                guildObj = (GuildImpl)this.getJDA().getGuildMap().get(guildId);
            }
            channel = new TextChannelImpl(id, guildObj);
            guildObj.getTextChannelsMap().put(id, (Object)channel);
            boolean bl = playbackCache = this.getJDA().getTextChannelMap().put(id, (Object)channel) == null;
        }
        if (!json.isNull("permission_overwrites")) {
            JSONArray overrides = json.getJSONArray("permission_overwrites");
            this.createOverridesPass(channel, overrides);
        }
        ((TextChannelImpl)((TextChannelImpl)((TextChannelImpl)channel.setParent(Helpers.optLong(json, "parent_id", 0L))).setLastMessageId(Helpers.optLong(json, "last_message_id", 0L)).setName(json.getString("name"))).setTopic(json.optString("topic", null)).setPosition(json.getInt("position"))).setNSFW(Helpers.optBoolean(json, "nsfw")).setSlowmode(Helpers.optInt(json, "rate_limit_per_user", 0));
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, id);
        }
        return channel;
    }

    public VoiceChannel createVoiceChannel(JSONObject json, long guildId) {
        return this.createVoiceChannel(null, json, guildId);
    }

    public VoiceChannel createVoiceChannel(GuildImpl guild, JSONObject json, long guildId) {
        boolean playbackCache = false;
        long id = json.getLong("id");
        VoiceChannelImpl channel = (VoiceChannelImpl)this.getJDA().getVoiceChannelMap().get(id);
        if (channel == null) {
            if (guild == null) {
                guild = (GuildImpl)this.getJDA().getGuildMap().get(guildId);
            }
            channel = new VoiceChannelImpl(id, guild);
            guild.getVoiceChannelsMap().put(id, (Object)channel);
            boolean bl = playbackCache = this.getJDA().getVoiceChannelMap().put(id, (Object)channel) == null;
        }
        if (!json.isNull("permission_overwrites")) {
            JSONArray overrides = json.getJSONArray("permission_overwrites");
            this.createOverridesPass(channel, overrides);
        }
        ((VoiceChannelImpl)((VoiceChannelImpl)((VoiceChannelImpl)channel.setParent(Helpers.optLong(json, "parent_id", 0L))).setName(json.getString("name"))).setPosition(json.getInt("position"))).setUserLimit(json.getInt("user_limit")).setBitrate(json.getInt("bitrate"));
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, id);
        }
        return channel;
    }

    public PrivateChannel createPrivateChannel(JSONObject privatechat) {
        JSONObject recipient = privatechat.has("recipients") ? privatechat.getJSONArray("recipients").getJSONObject(0) : privatechat.getJSONObject("recipient");
        long userId = recipient.getLong("id");
        UserImpl user = (UserImpl)this.getJDA().getUserMap().get(userId);
        if (user == null) {
            user = this.createFakeUser(recipient, true);
        }
        long channelId = privatechat.getLong("id");
        PrivateChannelImpl priv = new PrivateChannelImpl(channelId, user).setLastMessageId(Helpers.optLong(privatechat, "last_message_id", 0L));
        user.setPrivateChannel(priv);
        if (user.isFake()) {
            priv.setFake(true);
            this.getJDA().getFakePrivateChannelMap().put(channelId, (Object)priv);
        } else {
            this.getJDA().getPrivateChannelMap().put(channelId, (Object)priv);
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, channelId);
        }
        return priv;
    }

    public void createOverridesPass(AbstractChannelImpl<?> channel, JSONArray overrides) {
        for (int i = 0; i < overrides.length(); ++i) {
            try {
                this.createPermissionOverride(overrides.getJSONObject(i), channel);
                continue;
            }
            catch (NoSuchElementException e) {
                LOG.debug("{}. Ignoring PermissionOverride.", (Object)e.getMessage());
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.warn("{}. Ignoring PermissionOverride.", (Object)e.getMessage());
            }
        }
    }

    public Role createRole(GuildImpl guild, JSONObject roleJson, long guildId) {
        RoleImpl role;
        boolean playbackCache = false;
        long id = roleJson.getLong("id");
        if (guild == null) {
            guild = (GuildImpl)this.getJDA().getGuildMap().get(guildId);
        }
        if ((role = (RoleImpl)guild.getRolesMap().get(id)) == null) {
            role = new RoleImpl(id, guild);
            playbackCache = guild.getRolesMap().put(id, (Object)role) == null;
        }
        int color = roleJson.getInt("color");
        role.setName(roleJson.getString("name")).setRawPosition(roleJson.getInt("position")).setRawPermissions(roleJson.getLong("permissions")).setManaged(roleJson.getBoolean("managed")).setHoisted(roleJson.getBoolean("hoist")).setColor(color == 0 ? 0x1FFFFFFF : color).setMentionable(roleJson.has("mentionable") && roleJson.getBoolean("mentionable"));
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.ROLE, id);
        }
        return role;
    }

    public Message createMessage(JSONObject jsonObject) {
        return this.createMessage(jsonObject, false);
    }

    public Message createMessage(JSONObject jsonObject, boolean exceptionOnMissingUser) {
        long channelId = jsonObject.getLong("channel_id");
        MessageChannel chan = this.getJDA().getTextChannelById(channelId);
        if (chan == null) {
            chan = this.getJDA().getPrivateChannelById(channelId);
        }
        if (chan == null) {
            chan = (MessageChannel)this.getJDA().getFakePrivateChannelMap().get(channelId);
        }
        if (chan == null && this.getJDA().getAccountType() == AccountType.CLIENT) {
            chan = this.getJDA().asClient().getGroupById(channelId);
        }
        if (chan == null) {
            throw new IllegalArgumentException(MISSING_CHANNEL);
        }
        return this.createMessage(jsonObject, chan, exceptionOnMissingUser);
    }

    public Message createMessage(JSONObject jsonObject, MessageChannel chan, boolean exceptionOnMissingUser) {
        User user;
        long id = jsonObject.getLong("id");
        String content = jsonObject.optString("content");
        JSONObject author = jsonObject.getJSONObject("author");
        long authorId = author.getLong("id");
        boolean fromWebhook = jsonObject.has("webhook_id");
        boolean pinned = Helpers.optBoolean(jsonObject, "pinned");
        boolean tts = Helpers.optBoolean(jsonObject, "tts");
        boolean mentionsEveryone = Helpers.optBoolean(jsonObject, "mention_everyone");
        OffsetDateTime editTime = jsonObject.isNull("edited_timestamp") ? null : OffsetDateTime.parse(jsonObject.getString("edited_timestamp"));
        String nonce = jsonObject.isNull("nonce") ? null : jsonObject.get("nonce").toString();
        List<Message.Attachment> attachments = this.map(jsonObject, "attachments", this::createMessageAttachment);
        List<MessageEmbed> embeds = this.map(jsonObject, "embeds", this::createMessageEmbed);
        List<MessageReaction> reactions = this.map(jsonObject, "reactions", obj -> this.createMessageReaction(chan, id, (JSONObject)obj));
        MessageActivity activity = null;
        if (!jsonObject.isNull("activity")) {
            JSONObject activityData = jsonObject.getJSONObject("activity");
            MessageActivity.ActivityType activityType = MessageActivity.ActivityType.fromId(activityData.getInt("type"));
            String partyId = activityData.optString("party_id", null);
            MessageActivity.Application application = null;
            if (!jsonObject.isNull("application")) {
                JSONObject applicationData = jsonObject.getJSONObject("application");
                String name = applicationData.getString("name");
                String description = applicationData.getString("description");
                String iconId = applicationData.getString("icon");
                String coverId = applicationData.getString("cover_image");
                long applicationId = applicationData.getLong("id");
                application = new MessageActivity.Application(name, description, iconId, coverId, applicationId);
            }
            if (activityType == MessageActivity.ActivityType.UNKNOWN) {
                LOG.debug("Received an unknown ActivityType, Activity: {}", (Object)activityData);
            }
            activity = new MessageActivity(activityType, partyId, application);
        }
        switch (chan.getType()) {
            case PRIVATE: {
                if (authorId == this.getJDA().getSelfUser().getIdLong()) {
                    user = this.getJDA().getSelfUser();
                    break;
                }
                user = ((PrivateChannel)chan).getUser();
                break;
            }
            case GROUP: {
                user = this.getJDA().getUserById(authorId);
                if (user == null) {
                    user = (User)this.getJDA().getFakeUserMap().get(authorId);
                }
                if (user == null && fromWebhook) {
                    user = this.createFakeUser(author, false);
                }
                if (user == null) {
                    if (exceptionOnMissingUser) {
                        throw new IllegalArgumentException(MISSING_USER);
                    }
                    user = this.createFakeUser(author, false);
                }
                if (!user.isFake() || fromWebhook) break;
                UserImpl impl = (UserImpl)user;
                impl.setName(author.getString("username")).setDiscriminator(author.get("discriminator").toString()).setAvatarId(author.optString("avatar", null)).setBot(Helpers.optBoolean(author, "bot"));
                break;
            }
            case TEXT: {
                Guild guild = ((TextChannel)chan).getGuild();
                Member member = guild.getMemberById(authorId);
                User user2 = user = member != null ? member.getUser() : null;
                if (user != null) break;
                if (fromWebhook || !exceptionOnMissingUser) {
                    user = this.createFakeUser(author, false);
                    break;
                }
                throw new IllegalArgumentException(MISSING_USER);
            }
            default: {
                throw new IllegalArgumentException("Invalid Channel for creating a Message [" + (Object)((Object)chan.getType()) + ']');
            }
        }
        TLongHashSet mentionedRoles = new TLongHashSet();
        TLongHashSet mentionedUsers = new TLongHashSet(this.map(jsonObject, "mentions", o -> o.getLong("id")));
        JSONArray roleMentionArr = jsonObject.optJSONArray("mention_roles");
        if (roleMentionArr != null) {
            for (int i = 0; i < roleMentionArr.length(); ++i) {
                mentionedRoles.add(roleMentionArr.getLong(i));
            }
        }
        MessageType type = MessageType.fromId(jsonObject.getInt("type"));
        switch (type) {
            case DEFAULT: {
                return new ReceivedMessage(id, chan, type, fromWebhook, mentionsEveryone, (TLongSet)mentionedUsers, (TLongSet)mentionedRoles, tts, pinned, content, nonce, user, activity, editTime, reactions, attachments, embeds);
            }
            case UNKNOWN: {
                throw new IllegalArgumentException(UNKNOWN_MESSAGE_TYPE);
            }
        }
        return new SystemMessage(id, chan, type, fromWebhook, mentionsEveryone, (TLongSet)mentionedUsers, (TLongSet)mentionedRoles, tts, pinned, content, nonce, user, activity, editTime, reactions, attachments, embeds);
    }

    public MessageReaction createMessageReaction(MessageChannel chan, long id, JSONObject obj) {
        MessageReaction.ReactionEmote reactionEmote;
        JSONObject emoji = obj.getJSONObject("emoji");
        Long emojiID = emoji.isNull("id") ? null : Long.valueOf(emoji.getLong("id"));
        String name = emoji.optString("name", null);
        boolean animated = emoji.optBoolean("animated");
        int count = Helpers.optInt(obj, "count", -1);
        boolean me = Helpers.optBoolean(obj, "me");
        if (emojiID != null) {
            Emote emote = this.getJDA().getEmoteById(emojiID);
            if (emote == null) {
                emote = new EmoteImpl((long)emojiID, this.getJDA()).setAnimated(animated).setName(name);
            }
            reactionEmote = new MessageReaction.ReactionEmote(emote);
        } else {
            reactionEmote = new MessageReaction.ReactionEmote(name, null, this.getJDA());
        }
        return new MessageReaction(chan, reactionEmote, id, me, count);
    }

    public Message.Attachment createMessageAttachment(JSONObject jsonObject) {
        int width = Helpers.optInt(jsonObject, "width", -1);
        int height = Helpers.optInt(jsonObject, "height", -1);
        int size = jsonObject.getInt("size");
        String url = jsonObject.optString("url", null);
        String proxyUrl = jsonObject.optString("proxy_url", null);
        String filename = jsonObject.getString("filename");
        long id = jsonObject.getLong("id");
        return new Message.Attachment(id, url, proxyUrl, filename, size, height, width, this.getJDA());
    }

    public MessageEmbed createMessageEmbed(JSONObject content) {
        MessageEmbed.ImageInfo image;
        MessageEmbed.Footer footer;
        MessageEmbed.VideoInfo video;
        MessageEmbed.AuthorInfo author;
        MessageEmbed.Provider provider;
        MessageEmbed.Thumbnail thumbnail;
        int color;
        if (content.isNull("type")) {
            throw new JSONException("Encountered embed object with missing/null type field for Json: " + content);
        }
        EmbedType type = EmbedType.fromKey(content.getString("type"));
        String url = content.optString("url", null);
        String title = content.optString("title", null);
        String description = content.optString("description", null);
        OffsetDateTime timestamp = content.isNull("timestamp") ? null : OffsetDateTime.parse(content.getString("timestamp"));
        int n = color = content.isNull("color") ? 0x1FFFFFFF : content.getInt("color");
        if (content.isNull("thumbnail")) {
            thumbnail = null;
        } else {
            JSONObject obj2 = content.getJSONObject("thumbnail");
            thumbnail = new MessageEmbed.Thumbnail(obj2.optString("url", null), obj2.optString("proxy_url", null), Helpers.optInt(obj2, "width", -1), Helpers.optInt(obj2, "height", -1));
        }
        if (content.isNull("provider")) {
            provider = null;
        } else {
            JSONObject obj3 = content.getJSONObject("provider");
            provider = new MessageEmbed.Provider(obj3.optString("name", null), obj3.optString("url", null));
        }
        if (content.isNull("author")) {
            author = null;
        } else {
            JSONObject obj4 = content.getJSONObject("author");
            author = new MessageEmbed.AuthorInfo(obj4.optString("name", null), obj4.optString("url", null), obj4.optString("icon_url", null), obj4.optString("proxy_icon_url", null));
        }
        if (content.isNull("video")) {
            video = null;
        } else {
            JSONObject obj5 = content.getJSONObject("video");
            video = new MessageEmbed.VideoInfo(obj5.optString("url"), Helpers.optInt(obj5, "width", -1), Helpers.optInt(obj5, "height", -1));
        }
        if (content.isNull("footer")) {
            footer = null;
        } else {
            JSONObject obj6 = content.getJSONObject("footer");
            footer = new MessageEmbed.Footer(obj6.optString("text", null), obj6.optString("icon_url", null), obj6.optString("proxy_icon_url", null));
        }
        if (content.isNull("image")) {
            image = null;
        } else {
            JSONObject obj7 = content.getJSONObject("image");
            image = new MessageEmbed.ImageInfo(obj7.optString("url", null), obj7.optString("proxy_url", null), Helpers.optInt(obj7, "width", -1), Helpers.optInt(obj7, "height", -1));
        }
        List<MessageEmbed.Field> fields = this.map(content, "fields", obj -> new MessageEmbed.Field(obj.optString("name", null), obj.optString("value", null), Helpers.optBoolean(obj, "inline"), false));
        return EntityBuilder.createMessageEmbed(url, title, description, type, timestamp, color, thumbnail, provider, author, video, footer, image, fields);
    }

    public static MessageEmbed createMessageEmbed(String url, String title, String description, EmbedType type, OffsetDateTime timestamp, int color, MessageEmbed.Thumbnail thumbnail, MessageEmbed.Provider siteProvider, MessageEmbed.AuthorInfo author, MessageEmbed.VideoInfo videoInfo, MessageEmbed.Footer footer, MessageEmbed.ImageInfo image, List<MessageEmbed.Field> fields) {
        return new MessageEmbed(url, title, description, type, timestamp, color, thumbnail, siteProvider, author, videoInfo, footer, image, fields);
    }

    public PermissionOverride createPermissionOverride(JSONObject override, Channel chan) {
        PermissionOverrideImpl permOverride;
        long id = override.getLong("id");
        long allow = override.getLong("allow");
        long deny = override.getLong("deny");
        switch (override.getString("type")) {
            case "member": {
                Member member = chan.getGuild().getMemberById(id);
                if (member == null) {
                    throw new NoSuchElementException("Attempted to create a PermissionOverride for a non-existent user. Guild: " + chan.getGuild() + ", Channel: " + chan + ", JSON: " + override);
                }
                permOverride = (PermissionOverrideImpl)chan.getPermissionOverride(member);
                if (permOverride != null) break;
                permOverride = new PermissionOverrideImpl(chan, member.getUser().getIdLong(), member);
                ((AbstractChannelImpl)chan).getOverrideMap().put(member.getUser().getIdLong(), (Object)permOverride);
                break;
            }
            case "role": {
                Role role = (Role)((GuildImpl)chan.getGuild()).getRolesMap().get(id);
                if (role == null) {
                    throw new NoSuchElementException("Attempted to create a PermissionOverride for a non-existent role! JSON: " + override);
                }
                permOverride = (PermissionOverrideImpl)chan.getPermissionOverride(role);
                if (permOverride != null) break;
                permOverride = new PermissionOverrideImpl(chan, role.getIdLong(), role);
                ((AbstractChannelImpl)chan).getOverrideMap().put(role.getIdLong(), (Object)permOverride);
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided with an unknown PermissionOverride type! JSON: " + override);
            }
        }
        return permOverride.setAllow(allow).setDeny(deny);
    }

    public WebhookImpl createWebhook(JSONObject object) {
        long id = object.getLong("id");
        long guildId = object.getLong("guild_id");
        long channelId = object.getLong("channel_id");
        String token = object.optString("token", null);
        TextChannel channel = this.getJDA().getTextChannelById(channelId);
        if (channel == null) {
            throw new NullPointerException(String.format("Tried to create Webhook for an un-cached TextChannel! WebhookId: %s ChannelId: %s GuildId: %s", id, channelId, guildId));
        }
        Object name = !object.isNull("name") ? object.get("name") : JSONObject.NULL;
        Object avatar = !object.isNull("avatar") ? object.get("avatar") : JSONObject.NULL;
        JSONObject fakeUser = new JSONObject().put("username", name).put("discriminator", (Object)"0000").put("id", id).put("avatar", avatar);
        UserImpl defaultUser = this.createFakeUser(fakeUser, false);
        JSONObject ownerJson = object.optJSONObject("user");
        User owner = null;
        if (ownerJson != null) {
            long userId = ownerJson.getLong("id");
            owner = this.getJDA().getUserById(userId);
            if (owner == null) {
                ownerJson.put("id", userId);
                owner = this.createFakeUser(ownerJson, false);
            }
        }
        return new WebhookImpl(channel, id).setToken(token).setOwner(owner == null ? null : channel.getGuild().getMember(owner)).setUser(defaultUser);
    }

    public Relationship createRelationship(JSONObject relationshipJson) {
        if (this.getJDA().getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to create a Relationship but the logged in account is not a CLIENT!");
        }
        RelationshipType type = RelationshipType.fromKey(relationshipJson.getInt("type"));
        UserImpl user = type == RelationshipType.FRIEND ? this.createUser(relationshipJson.getJSONObject("user")) : this.createFakeUser(relationshipJson.getJSONObject("user"), true);
        Relationship relationship = this.getJDA().asClient().getRelationshipById(user.getIdLong(), type);
        if (relationship == null) {
            switch (type) {
                case FRIEND: {
                    relationship = new FriendImpl(user);
                    break;
                }
                case BLOCKED: {
                    relationship = new BlockedUserImpl(user);
                    break;
                }
                case INCOMING_FRIEND_REQUEST: {
                    relationship = new IncomingFriendRequestImpl(user);
                    break;
                }
                case OUTGOING_FRIEND_REQUEST: {
                    relationship = new OutgoingFriendRequestImpl(user);
                    break;
                }
                default: {
                    return null;
                }
            }
            this.getJDA().asClient().getRelationshipMap().put(user.getIdLong(), (Object)relationship);
        }
        return relationship;
    }

    public Group createGroup(JSONObject groupJson) {
        if (this.getJDA().getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to create a Group but the logged in account is not a CLIENT!");
        }
        boolean playbackCache = false;
        long groupId = groupJson.getLong("id");
        JSONArray recipients = groupJson.getJSONArray("recipients");
        long ownerId = groupJson.getLong("owner_id");
        String name = groupJson.optString("name", null);
        String iconId = groupJson.optString("icon", null);
        long lastMessage = Helpers.optLong(groupJson, "last_message_id", 0L);
        GroupImpl group = (GroupImpl)this.getJDA().asClient().getGroupById(groupId);
        if (group == null) {
            group = new GroupImpl(groupId, this.getJDA());
            playbackCache = this.getJDA().asClient().getGroupMap().put(groupId, (Object)group) == null;
        }
        TLongObjectMap<User> groupUsers = group.getUserMap();
        groupUsers.put(this.getJDA().getSelfUser().getIdLong(), (Object)this.getJDA().getSelfUser());
        for (int i = 0; i < recipients.length(); ++i) {
            JSONObject groupUser = recipients.getJSONObject(i);
            groupUsers.put(groupUser.getLong("id"), (Object)this.createFakeUser(groupUser, true));
        }
        User owner = (User)this.getJDA().getUserMap().get(ownerId);
        if (owner == null) {
            owner = (User)this.getJDA().getFakeUserMap().get(ownerId);
        }
        if (owner == null) {
            throw new IllegalArgumentException("Attempted to build a Group, but could not find user by provided owner id.This should not be possible because the owner should be IN the group!");
        }
        group.setOwner(owner).setLastMessageId(lastMessage).setName(name).setIconId(iconId);
        if (playbackCache) {
            this.getJDA().getEventCache().playbackCache(EventCache.Type.CHANNEL, groupId);
        }
        return group;
    }

    public Invite createInvite(JSONObject object) {
        OffsetDateTime timeCreated;
        boolean temporary;
        int uses;
        int maxUses;
        int maxAge;
        boolean expanded;
        InviteImpl.GroupImpl group;
        InviteImpl.ChannelImpl channel;
        InviteImpl.GuildImpl guild;
        Invite.InviteType type;
        String code = object.getString("code");
        UserImpl inviter = object.has("inviter") ? this.createFakeUser(object.getJSONObject("inviter"), false) : null;
        JSONObject channelObject = object.getJSONObject("channel");
        ChannelType channelType = ChannelType.fromId(channelObject.getInt("type"));
        if (channelType == ChannelType.GROUP) {
            type = Invite.InviteType.GROUP;
            guild = null;
            channel = null;
            String groupName = channelObject.optString("name");
            long groupId = channelObject.getLong("id");
            String groupIconId = channelObject.optString("icon", null);
            JSONArray usernameArray = channelObject.optJSONArray("recipients");
            List usernames = usernameArray == null ? null : Collections.unmodifiableList(StreamSupport.stream(usernameArray.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
            group = new InviteImpl.GroupImpl(groupIconId, groupName, groupId, usernames);
        } else if (channelType.isGuild()) {
            type = Invite.InviteType.GUILD;
            JSONObject guildObject = object.getJSONObject("guild");
            String guildIconId = guildObject.optString("icon", null);
            long guildId = guildObject.getLong("id");
            String guildName = guildObject.getString("name");
            String guildSplashId = guildObject.optString("splash", null);
            Guild.VerificationLevel guildVerificationLevel = Guild.VerificationLevel.fromKey(Helpers.optInt(guildObject, "verification_level", -1));
            int presenceCount = Helpers.optInt(object, "approximate_presence_count", -1);
            int memberCount = Helpers.optInt(object, "approximate_member_count", -1);
            Set<String> guildFeatures = guildObject.isNull("features") ? Collections.emptySet() : Collections.unmodifiableSet(StreamSupport.stream(guildObject.getJSONArray("features").spliterator(), false).map(String::valueOf).collect(Collectors.toSet()));
            guild = new InviteImpl.GuildImpl(guildId, guildIconId, guildName, guildSplashId, guildVerificationLevel, presenceCount, memberCount, guildFeatures);
            String channelName = channelObject.getString("name");
            long channelId = channelObject.getLong("id");
            channel = new InviteImpl.ChannelImpl(channelId, channelName, channelType);
            group = null;
        } else {
            type = Invite.InviteType.UNKNOWN;
            guild = null;
            channel = null;
            group = null;
        }
        if (object.has("max_uses")) {
            expanded = true;
            maxAge = object.getInt("max_age");
            maxUses = object.getInt("max_uses");
            uses = object.getInt("uses");
            temporary = object.getBoolean("temporary");
            timeCreated = OffsetDateTime.parse(object.getString("created_at"));
        } else {
            expanded = false;
            maxAge = -1;
            maxUses = -1;
            uses = -1;
            temporary = false;
            timeCreated = null;
        }
        return new InviteImpl(this.getJDA(), code, expanded, inviter, maxAge, maxUses, temporary, timeCreated, uses, channel, guild, group, type);
    }

    public ApplicationInfo createApplicationInfo(JSONObject object) {
        String description = object.getString("description");
        boolean doesBotRequireCodeGrant = object.getBoolean("bot_require_code_grant");
        String iconId = object.optString("icon", null);
        long id = object.getLong("id");
        String name = object.getString("name");
        boolean isBotPublic = object.getBoolean("bot_public");
        UserImpl owner = this.createFakeUser(object.getJSONObject("owner"), false);
        return new ApplicationInfoImpl(this.getJDA(), description, doesBotRequireCodeGrant, iconId, id, isBotPublic, name, owner);
    }

    public Application createApplication(JSONObject object) {
        return new ApplicationImpl(this.getJDA(), object);
    }

    public AuthorizedApplication createAuthorizedApplication(JSONObject object) {
        long authId = object.getLong("id");
        JSONArray scopeArray = object.getJSONArray("scopes");
        ArrayList<String> scopes = new ArrayList<String>(scopeArray.length());
        for (int i = 0; i < scopeArray.length(); ++i) {
            scopes.add(scopeArray.getString(i));
        }
        JSONObject application = object.getJSONObject("application");
        String description = application.getString("description");
        String iconId = application.has("icon") ? application.getString("icon") : null;
        long id = application.getLong("id");
        String name = application.getString("name");
        return new AuthorizedApplicationImpl(this.getJDA(), authId, description, iconId, id, name, scopes);
    }

    public AuditLogEntry createAuditLogEntry(GuildImpl guild, JSONObject entryJson, JSONObject userJson, JSONObject webhookJson) {
        Set<AuditLogChange> changesList;
        long targetId = Helpers.optLong(entryJson, "target_id", 0L);
        long id = entryJson.getLong("id");
        int typeKey = entryJson.getInt("action_type");
        JSONArray changes = entryJson.isNull("changes") ? null : entryJson.getJSONArray("changes");
        JSONObject options = entryJson.isNull("options") ? null : entryJson.getJSONObject("options");
        String reason = entryJson.optString("reason", null);
        UserImpl user = userJson == null ? null : this.createFakeUser(userJson, false);
        WebhookImpl webhook = webhookJson == null ? null : this.createWebhook(webhookJson);
        ActionType type = ActionType.from(typeKey);
        if (changes != null) {
            changesList = new HashSet(changes.length());
            for (int i = 0; i < changes.length(); ++i) {
                JSONObject object = changes.getJSONObject(i);
                AuditLogChange change = this.createAuditLogChange(object);
                changesList.add(change);
            }
        } else {
            changesList = Collections.emptySet();
        }
        CaseInsensitiveMap changeMap = new CaseInsensitiveMap(this.changeToMap(changesList));
        CaseInsensitiveMap optionMap = options != null ? new CaseInsensitiveMap(options.toMap()) : null;
        return new AuditLogEntry(type, id, targetId, guild, user, webhook, reason, (Map<String, AuditLogChange>)changeMap, (Map<String, Object>)optionMap);
    }

    public AuditLogChange createAuditLogChange(JSONObject change) {
        Object newValue;
        String key = change.getString("key");
        Object oldValue = change.isNull("old_value") ? null : change.get("old_value");
        Object object = newValue = change.isNull("new_value") ? null : change.get("new_value");
        if (oldValue instanceof JSONArray || newValue instanceof JSONArray) {
            oldValue = oldValue instanceof JSONArray ? ((JSONArray)oldValue).toList() : oldValue;
            newValue = newValue instanceof JSONArray ? ((JSONArray)newValue).toList() : newValue;
        } else if (oldValue instanceof JSONObject || newValue instanceof JSONObject) {
            oldValue = oldValue instanceof JSONObject ? ((JSONObject)oldValue).toMap() : oldValue;
            newValue = newValue instanceof JSONObject ? ((JSONObject)newValue).toMap() : newValue;
        }
        return new AuditLogChange(oldValue, newValue, key);
    }

    private Map<String, AuditLogChange> changeToMap(Set<AuditLogChange> changesList) {
        return changesList.stream().collect(Collectors.toMap(AuditLogChange::getKey, UnaryOperator.identity()));
    }

    private <T> List<T> map(JSONObject jsonObject, String key, Function<JSONObject, T> convert) {
        if (jsonObject.isNull(key)) {
            return Collections.emptyList();
        }
        JSONArray arr = jsonObject.getJSONArray(key);
        ArrayList<T> mappedObjects = new ArrayList<T>(arr.length());
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject obj = arr.getJSONObject(i);
            mappedObjects.add(convert.apply(obj));
        }
        return mappedObjects;
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add("application_id");
        tmp.add("assets");
        tmp.add("details");
        tmp.add("flags");
        tmp.add("party");
        tmp.add("session_id");
        tmp.add("state");
        tmp.add("sync_id");
        richGameFields = Collections.unmodifiableSet(tmp);
    }
}

