/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core;

import com.neovisionaries.ws.client.WebSocketFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.annotations.DeprecatedSince;
import net.dv8tion.jda.annotations.Incubating;
import net.dv8tion.jda.annotations.ReplaceWith;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.SessionController;
import net.dv8tion.jda.core.utils.SessionControllerAdapter;
import net.dv8tion.jda.core.utils.cache.CacheFlag;
import okhttp3.OkHttpClient;

public class JDABuilder {
    protected final List<Object> listeners;
    protected final AccountType accountType;
    protected ScheduledExecutorService rateLimitPool = null;
    protected boolean shutdownRateLimitPool = true;
    protected ScheduledExecutorService mainWsPool = null;
    protected boolean shutdownMainWsPool = true;
    protected ExecutorService callbackPool = null;
    protected boolean shutdownCallbackPool = true;
    protected EnumSet<CacheFlag> cacheFlags = EnumSet.allOf(CacheFlag.class);
    protected ConcurrentMap<String, String> contextMap = null;
    protected SessionController controller = null;
    protected OkHttpClient.Builder httpClientBuilder = null;
    protected OkHttpClient httpClient = null;
    protected WebSocketFactory wsFactory = null;
    protected String token = null;
    protected IEventManager eventManager = null;
    protected IAudioSendFactory audioSendFactory = null;
    protected JDA.ShardInfo shardInfo = null;
    protected Game game = null;
    protected OnlineStatus status = OnlineStatus.ONLINE;
    protected int maxReconnectDelay = 900;
    protected int corePoolSize = 5;
    protected boolean enableContext = true;
    protected boolean enableVoice = true;
    protected boolean enableShutdownHook = true;
    protected boolean enableBulkDeleteSplitting = true;
    protected boolean autoReconnect = true;
    protected boolean idle = false;
    protected boolean requestTimeoutRetry = true;
    protected boolean enableCompression = true;

    public JDABuilder() {
        this(AccountType.BOT);
    }

    public JDABuilder(String token) {
        this();
        this.setToken(token);
    }

    @Incubating
    public JDABuilder(AccountType accountType) {
        Checks.notNull((Object)accountType, "accountType");
        this.accountType = accountType;
        this.listeners = new LinkedList<Object>();
    }

    public JDABuilder setEnabledCacheFlags(EnumSet<CacheFlag> flags) {
        this.cacheFlags = flags == null ? EnumSet.noneOf(CacheFlag.class) : EnumSet.copyOf(flags);
        return this;
    }

    public JDABuilder setDisabledCacheFlags(EnumSet<CacheFlag> flags) {
        return this.setEnabledCacheFlags(EnumSet.complementOf(flags));
    }

    public JDABuilder setContextMap(ConcurrentMap<String, String> map) {
        this.contextMap = map;
        if (map != null) {
            this.enableContext = true;
        }
        return this;
    }

    public JDABuilder setContextEnabled(boolean enable) {
        this.enableContext = enable;
        return this;
    }

    public JDABuilder setCompressionEnabled(boolean enable) {
        this.enableCompression = enable;
        return this;
    }

    public JDABuilder setRequestTimeoutRetry(boolean retryOnTimeout) {
        this.requestTimeoutRetry = retryOnTimeout;
        return this;
    }

    public JDABuilder setToken(String token) {
        this.token = token;
        return this;
    }

    public JDABuilder setHttpClientBuilder(OkHttpClient.Builder builder) {
        this.httpClientBuilder = builder;
        return this;
    }

    public JDABuilder setHttpClient(OkHttpClient client) {
        this.httpClient = client;
        return this;
    }

    public JDABuilder setWebsocketFactory(WebSocketFactory factory) {
        this.wsFactory = factory;
        return this;
    }

    public JDABuilder setCorePoolSize(int size) {
        Checks.positive(size, "Core pool size");
        this.corePoolSize = size;
        return this;
    }

    public JDABuilder setRateLimitPool(ScheduledExecutorService pool) {
        return this.setRateLimitPool(pool, pool == null);
    }

    public JDABuilder setRateLimitPool(ScheduledExecutorService pool, boolean automaticShutdown) {
        this.rateLimitPool = pool;
        this.shutdownRateLimitPool = automaticShutdown;
        return this;
    }

    public JDABuilder setGatewayPool(ScheduledExecutorService pool) {
        return this.setGatewayPool(pool, pool == null);
    }

    public JDABuilder setGatewayPool(ScheduledExecutorService pool, boolean automaticShutdown) {
        this.mainWsPool = pool;
        this.shutdownMainWsPool = automaticShutdown;
        return this;
    }

    public JDABuilder setCallbackPool(ExecutorService executor) {
        return this.setCallbackPool(executor, executor == null);
    }

    public JDABuilder setCallbackPool(ExecutorService executor, boolean automaticShutdown) {
        this.callbackPool = executor;
        this.shutdownCallbackPool = automaticShutdown;
        return this;
    }

    public JDABuilder setAudioEnabled(boolean enabled) {
        this.enableVoice = enabled;
        return this;
    }

    public JDABuilder setBulkDeleteSplittingEnabled(boolean enabled) {
        this.enableBulkDeleteSplitting = enabled;
        return this;
    }

    public JDABuilder setEnableShutdownHook(boolean enable) {
        this.enableShutdownHook = enable;
        return this;
    }

    public JDABuilder setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public JDABuilder setEventManager(IEventManager manager) {
        this.eventManager = manager;
        return this;
    }

    public JDABuilder setAudioSendFactory(IAudioSendFactory factory) {
        this.audioSendFactory = factory;
        return this;
    }

    public JDABuilder setIdle(boolean idle) {
        this.idle = idle;
        return this;
    }

    public JDABuilder setGame(Game game) {
        this.game = game;
        return this;
    }

    public JDABuilder setStatus(OnlineStatus status) {
        if (status == null || status == OnlineStatus.UNKNOWN) {
            throw new IllegalArgumentException("OnlineStatus cannot be null or unknown!");
        }
        this.status = status;
        return this;
    }

    public JDABuilder addEventListener(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        Collections.addAll(this.listeners, listeners);
        return this;
    }

    public JDABuilder removeEventListener(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        this.listeners.removeAll(Arrays.asList(listeners));
        return this;
    }

    public JDABuilder setMaxReconnectDelay(int maxReconnectDelay) {
        Checks.check(maxReconnectDelay >= 32, "Max reconnect delay must be 32 seconds or greater. You provided %d.", (Object)maxReconnectDelay);
        this.maxReconnectDelay = maxReconnectDelay;
        return this;
    }

    public JDABuilder useSharding(int shardId, int shardTotal) {
        AccountTypeException.check(this.accountType, AccountType.BOT);
        Checks.notNegative(shardId, "Shard ID");
        Checks.positive(shardTotal, "Shard Total");
        Checks.check(shardId < shardTotal, "The shard ID must be lower than the shardTotal! Shard IDs are 0-based.");
        this.shardInfo = new JDA.ShardInfo(shardId, shardTotal);
        return this;
    }

    public JDABuilder setSessionController(SessionController controller) {
        this.controller = controller;
        return this;
    }

    @Deprecated
    @DeprecatedSince(value="3.8.0")
    @ReplaceWith(value="build()")
    public JDA buildAsync() throws LoginException {
        return this.build();
    }

    @Deprecated
    @DeprecatedSince(value="3.8.0")
    @ReplaceWith(value="build().awaitStatus(Status)")
    public JDA buildBlocking(JDA.Status status) throws LoginException, InterruptedException {
        Checks.notNull((Object)status, "Status");
        Checks.check(status.isInit(), "Cannot await the status %s as it is not part of the login cycle!", (Object)status);
        JDA jda = this.build();
        jda.awaitStatus(status);
        return jda;
    }

    @Deprecated
    @DeprecatedSince(value="3.8.0")
    @ReplaceWith(value="build().awaitReady()")
    public JDA buildBlocking() throws LoginException, InterruptedException {
        return this.buildBlocking(JDA.Status.CONNECTED);
    }

    public JDA build() throws LoginException {
        WebSocketFactory wsFactory;
        OkHttpClient httpClient = this.httpClient;
        if (httpClient == null) {
            if (this.httpClientBuilder == null) {
                this.httpClientBuilder = new OkHttpClient.Builder();
            }
            httpClient = this.httpClientBuilder.build();
        }
        WebSocketFactory webSocketFactory = wsFactory = this.wsFactory == null ? new WebSocketFactory() : this.wsFactory;
        if (this.controller == null && this.shardInfo != null) {
            this.controller = new SessionControllerAdapter();
        }
        JDAImpl jda = new JDAImpl(this.accountType, this.token, this.controller, httpClient, wsFactory, this.rateLimitPool, this.mainWsPool, this.callbackPool, this.autoReconnect, this.enableVoice, this.enableShutdownHook, this.enableBulkDeleteSplitting, this.requestTimeoutRetry, this.enableContext, this.shutdownRateLimitPool, this.shutdownMainWsPool, this.shutdownCallbackPool, this.corePoolSize, this.maxReconnectDelay, this.contextMap, this.cacheFlags);
        if (this.eventManager != null) {
            jda.setEventManager(this.eventManager);
        }
        if (this.audioSendFactory != null) {
            jda.setAudioSendFactory(this.audioSendFactory);
        }
        this.listeners.forEach(xva$0 -> jda.addEventListener(xva$0));
        jda.setStatus(JDA.Status.INITIALIZED);
        String gateway = jda.getGateway();
        ((PresenceImpl)jda.getPresence()).setCacheGame(this.game).setCacheIdle(this.idle).setCacheStatus(this.status);
        jda.login(gateway, this.shardInfo, this.enableCompression, true);
        return jda;
    }
}

