/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.bot.sharding;

import com.neovisionaries.ws.client.WebSocketFactory;
import gnu.trove.map.TIntObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntFunction;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.bot.sharding.ShardManager;
import net.dv8tion.jda.bot.sharding.ThreadPoolProvider;
import net.dv8tion.jda.bot.utils.cache.ShardCacheView;
import net.dv8tion.jda.bot.utils.cache.impl.ShardCacheViewImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.JDALogger;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.SessionController;
import net.dv8tion.jda.core.utils.SessionControllerAdapter;
import net.dv8tion.jda.core.utils.cache.CacheFlag;
import net.dv8tion.jda.core.utils.tuple.Pair;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;

public class DefaultShardManager
implements ShardManager {
    public static final Logger LOG = JDALogger.getLog(ShardManager.class);
    public static final ThreadFactory DEFAULT_THREAD_FACTORY = r -> {
        Thread t = new Thread(r, "DefaultShardManager");
        t.setPriority(6);
        return t;
    };
    protected final SessionController controller;
    protected final IAudioSendFactory audioSendFactory;
    protected final boolean autoReconnect;
    protected final int corePoolSize;
    protected final boolean enableBulkDeleteSplitting;
    protected final boolean enableVoice;
    protected final IntFunction<? extends IEventManager> eventManagerProvider;
    protected final List<Object> listeners;
    protected final List<IntFunction<Object>> listenerProviders;
    protected final int maxReconnectDelay;
    protected final ScheduledExecutorService executor;
    protected final Queue<Integer> queue = new ConcurrentLinkedQueue<Integer>();
    protected ShardCacheViewImpl shards;
    protected int shardsTotal;
    protected final OkHttpClient.Builder httpClientBuilder;
    protected final OkHttpClient httpClient;
    protected final ThreadPoolProvider<? extends ScheduledExecutorService> rateLimitPoolProvider;
    protected final ThreadPoolProvider<? extends ScheduledExecutorService> gatewayPoolProvider;
    protected final ThreadPoolProvider<? extends ExecutorService> callbackPoolProvider;
    protected final WebSocketFactory wsFactory;
    protected final boolean retryOnTimeout;
    protected final boolean useShutdownNow;
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    protected final Thread shutdownHook;
    protected final String token;
    protected Future<?> worker;
    protected String gatewayURL;
    protected IntFunction<? extends Game> gameProvider;
    protected IntFunction<Boolean> idleProvider;
    protected IntFunction<OnlineStatus> statusProvider;
    protected IntFunction<? extends ConcurrentMap<String, String>> contextProvider;
    protected boolean enableMDC;
    protected boolean enableCompression;
    protected final EnumSet<CacheFlag> cacheFlags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultShardManager(int shardsTotal, Collection<Integer> shardIds, SessionController controller, List<Object> listeners, List<IntFunction<Object>> listenerProviders, String token, IntFunction<? extends IEventManager> eventManagerProvider, IAudioSendFactory audioSendFactory, IntFunction<? extends Game> gameProvider, IntFunction<OnlineStatus> statusProvider, OkHttpClient.Builder httpClientBuilder, OkHttpClient httpClient, ThreadPoolProvider<? extends ScheduledExecutorService> rateLimitPoolProvider, ThreadPoolProvider<? extends ScheduledExecutorService> gatewayPoolProvider, ThreadPoolProvider<? extends ExecutorService> callbackPoolProvider, WebSocketFactory wsFactory, ThreadFactory threadFactory, int maxReconnectDelay, int corePoolSize, boolean enableVoice, boolean enableShutdownHook, boolean enableBulkDeleteSplitting, boolean autoReconnect, IntFunction<Boolean> idleProvider, boolean retryOnTimeout, boolean useShutdownNow, boolean enableMDC, IntFunction<? extends ConcurrentMap<String, String>> contextProvider, EnumSet<CacheFlag> cacheFlags, boolean enableCompression) {
        this.shardsTotal = shardsTotal;
        this.listeners = listeners;
        this.listenerProviders = listenerProviders;
        this.token = token;
        this.eventManagerProvider = eventManagerProvider;
        this.audioSendFactory = audioSendFactory;
        this.gameProvider = gameProvider;
        this.statusProvider = statusProvider;
        this.httpClient = httpClient;
        this.httpClientBuilder = httpClient == null ? (httpClientBuilder == null ? new OkHttpClient.Builder() : httpClientBuilder) : null;
        this.rateLimitPoolProvider = rateLimitPoolProvider;
        this.gatewayPoolProvider = gatewayPoolProvider;
        this.callbackPoolProvider = callbackPoolProvider;
        this.wsFactory = wsFactory == null ? new WebSocketFactory() : wsFactory;
        this.executor = this.createExecutor(threadFactory);
        this.controller = controller == null ? new SessionControllerAdapter() : controller;
        this.maxReconnectDelay = maxReconnectDelay;
        this.corePoolSize = corePoolSize;
        this.enableVoice = enableVoice;
        this.shutdownHook = enableShutdownHook ? new Thread(this::shutdown, "JDA Shutdown Hook") : null;
        this.enableBulkDeleteSplitting = enableBulkDeleteSplitting;
        this.autoReconnect = autoReconnect;
        this.idleProvider = idleProvider;
        this.retryOnTimeout = retryOnTimeout;
        this.useShutdownNow = useShutdownNow;
        this.contextProvider = contextProvider;
        this.enableMDC = enableMDC;
        this.enableCompression = enableCompression;
        this.cacheFlags = cacheFlags;
        Queue<Integer> queue = this.queue;
        synchronized (queue) {
            if (shardsTotal != -1) {
                if (shardIds == null) {
                    this.shards = new ShardCacheViewImpl(shardsTotal);
                    for (int i = 0; i < this.shardsTotal; ++i) {
                        this.queue.add(i);
                    }
                } else {
                    this.shards = new ShardCacheViewImpl(shardIds.size());
                    shardIds.stream().distinct().sorted().forEach(this.queue::add);
                }
            }
        }
    }

    @Override
    public void addEventListener(Object ... listeners) {
        ShardManager.super.addEventListener(listeners);
        Collections.addAll(this.listeners, listeners);
    }

    @Override
    public void removeEventListener(Object ... listeners) {
        ShardManager.super.removeEventListener(listeners);
        this.listeners.removeAll(Arrays.asList(listeners));
    }

    @Override
    public void addEventListeners(IntFunction<Object> eventListenerProvider) {
        ShardManager.super.addEventListeners(eventListenerProvider);
        this.listenerProviders.add(eventListenerProvider);
    }

    @Override
    public void removeEventListenerProvider(IntFunction<Object> eventListenerProvider) {
        this.listenerProviders.remove(eventListenerProvider);
    }

    @Override
    public int getShardsQueued() {
        return this.queue.size();
    }

    @Override
    public int getShardsTotal() {
        return this.shardsTotal;
    }

    @Override
    public Guild getGuildById(long id) {
        int shardId = MiscUtil.getShardForGuild(id, this.getShardsTotal());
        JDA shard = this.getShardById(shardId);
        return shard == null ? null : shard.getGuildById(id);
    }

    @Override
    public ShardCacheView getShardCache() {
        return this.shards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login() throws LoginException {
        JDAImpl jda = null;
        try {
            int shardId = this.queue.isEmpty() ? 0 : this.queue.peek();
            jda = this.buildInstance(shardId);
            this.shards.getMap().put(shardId, (Object)jda);
            Queue<Integer> queue = this.queue;
            synchronized (queue) {
                this.queue.remove(shardId);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted Startup", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            if (jda != null) {
                if (this.useShutdownNow) {
                    jda.shutdownNow();
                } else {
                    jda.shutdown();
                }
            }
            throw e;
        }
        this.runQueueWorker();
        if (this.shutdownHook != null) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    @Override
    public void restart(int shardId) {
        Checks.notNegative(shardId, "shardId");
        Checks.check(shardId < this.shardsTotal, "shardId must be lower than shardsTotal");
        JDA jda = (JDA)this.shards.getMap().remove(shardId);
        if (jda != null) {
            if (this.useShutdownNow) {
                jda.shutdownNow();
            } else {
                jda.shutdown();
            }
        }
        this.enqueueShard(shardId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() {
        TIntObjectMap<JDA> map;
        TIntObjectMap<JDA> tIntObjectMap = map = this.shards.getMap();
        synchronized (tIntObjectMap) {
            Arrays.stream(map.keys()).sorted().forEach(this::restart);
        }
    }

    @Override
    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.executor.shutdown();
        if (this.shards != null) {
            for (JDA jda : this.shards) {
                if (this.useShutdownNow) {
                    jda.shutdownNow();
                    continue;
                }
                jda.shutdown();
            }
        }
    }

    @Override
    public void shutdown(int shardId) {
        JDA jda = (JDA)this.shards.getMap().remove(shardId);
        if (jda != null) {
            if (this.useShutdownNow) {
                jda.shutdownNow();
            } else {
                jda.shutdown();
            }
        }
    }

    @Override
    public void start(int shardId) {
        Checks.notNegative(shardId, "shardId");
        Checks.check(shardId < this.shardsTotal, "shardId must be lower than shardsTotal");
        this.enqueueShard(shardId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueShard(int shardId) {
        Queue<Integer> queue = this.queue;
        synchronized (queue) {
            this.queue.add(shardId);
            this.runQueueWorker();
        }
    }

    protected void runQueueWorker() {
        if (this.worker != null) {
            return;
        }
        try {
            this.worker = this.executor.submit(() -> {
                while (!this.queue.isEmpty()) {
                    this.processQueue();
                }
                this.gatewayURL = null;
                Queue<Integer> queue = this.queue;
                synchronized (queue) {
                    this.worker = null;
                    if (!this.shutdown.get() && !this.queue.isEmpty()) {
                        this.runQueueWorker();
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            LOG.debug("ThreadPool rejected queue worker thread", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueue() {
        JDAImpl api;
        int shardId;
        if (this.shards == null) {
            shardId = 0;
        } else {
            Integer tmp = this.queue.peek();
            int n = shardId = tmp == null ? -1 : tmp;
        }
        if (shardId == -1) {
            return;
        }
        try {
            JDAImpl jDAImpl = api = this.shards == null ? null : (JDAImpl)this.shards.getElementById(shardId);
            if (api == null) {
                api = this.buildInstance(shardId);
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Queue has been interrupted", (Throwable)e);
            return;
        }
        catch (LoginException e) {
            LOG.warn("The token has been invalidated and the ShardManager will shutdown!", (Throwable)e);
            this.shutdown();
            return;
        }
        catch (Exception e) {
            LOG.error("Caught an exception in the queue processing thread", (Throwable)e);
            return;
        }
        this.shards.getMap().put(shardId, (Object)api);
        Queue<Integer> queue = this.queue;
        synchronized (queue) {
            this.queue.remove(shardId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JDAImpl buildInstance(int shardId) throws LoginException, InterruptedException {
        JDAImpl jda;
        block18: {
            OkHttpClient httpClient = this.httpClient;
            if (httpClient == null) {
                httpClient = this.httpClientBuilder.build();
            }
            ExecutorPair<? extends ScheduledExecutorService> rateLimitPair = DefaultShardManager.resolveExecutor(this.rateLimitPoolProvider, shardId);
            ScheduledExecutorService rateLimitPool = (ScheduledExecutorService)rateLimitPair.executor;
            boolean shutdownRateLimitPool = rateLimitPair.automaticShutdown;
            ExecutorPair<? extends ScheduledExecutorService> gatewayPair = DefaultShardManager.resolveExecutor(this.gatewayPoolProvider, shardId);
            ScheduledExecutorService gatewayPool = (ScheduledExecutorService)gatewayPair.executor;
            boolean shutdownGatewayPool = gatewayPair.automaticShutdown;
            ExecutorPair<? extends ExecutorService> callbackPair = DefaultShardManager.resolveExecutor(this.callbackPoolProvider, shardId);
            Object callbackPool = callbackPair.executor;
            boolean shutdownCallbackPool = callbackPair.automaticShutdown;
            jda = new JDAImpl(AccountType.BOT, this.token, this.controller, httpClient, this.wsFactory, rateLimitPool, gatewayPool, (ExecutorService)callbackPool, this.autoReconnect, this.enableVoice, false, this.enableBulkDeleteSplitting, this.retryOnTimeout, this.enableMDC, shutdownRateLimitPool, shutdownGatewayPool, shutdownCallbackPool, this.corePoolSize, this.maxReconnectDelay, this.contextProvider == null || !this.enableMDC ? null : this.contextProvider.apply(shardId), this.cacheFlags);
            jda.asBot().setShardManager(this);
            if (this.eventManagerProvider != null) {
                jda.setEventManager(this.eventManagerProvider.apply(shardId));
            }
            if (this.audioSendFactory != null) {
                jda.setAudioSendFactory(this.audioSendFactory);
            }
            this.listeners.forEach(xva$0 -> jda.addEventListener(xva$0));
            this.listenerProviders.forEach(provider -> jda.addEventListener(provider.apply(shardId)));
            jda.setStatus(JDA.Status.INITIALIZED);
            PresenceImpl presence = (PresenceImpl)jda.getPresence();
            if (this.gameProvider != null) {
                presence.setCacheGame(this.gameProvider.apply(shardId));
            }
            if (this.idleProvider != null) {
                presence.setCacheIdle(this.idleProvider.apply(shardId));
            }
            if (this.statusProvider != null) {
                presence.setCacheStatus(this.statusProvider.apply(shardId));
            }
            if (this.gatewayURL == null) {
                try {
                    Pair<String, Integer> gateway = jda.getGatewayBot();
                    this.gatewayURL = gateway.getLeft();
                    if (this.gatewayURL == null) {
                        LOG.error("Acquired null gateway url from SessionController");
                    } else {
                        LOG.info("Login Successful!");
                    }
                    if (this.shardsTotal != -1) break block18;
                    this.shardsTotal = gateway.getRight();
                    this.shards = new ShardCacheViewImpl(this.shardsTotal);
                    Queue<Integer> queue = this.queue;
                    synchronized (queue) {
                        for (int i = 0; i < this.shardsTotal; ++i) {
                            this.queue.add(i);
                        }
                    }
                }
                catch (RuntimeException e) {
                    Throwable ex;
                    if (e.getCause() instanceof InterruptedException) {
                        throw (InterruptedException)e.getCause();
                    }
                    Throwable throwable = ex = e.getCause() instanceof ExecutionException ? e.getCause().getCause() : null;
                    if (ex instanceof LoginException) {
                        throw new LoginException(ex.getMessage());
                    }
                    throw e;
                }
            }
        }
        JDA.ShardInfo shardInfo = new JDA.ShardInfo(shardId, this.shardsTotal);
        int shardTotal = jda.login(this.gatewayURL, shardInfo, this.enableCompression, false);
        if (this.shardsTotal == -1) {
            this.shardsTotal = shardTotal;
        }
        return jda;
    }

    @Override
    public void setGameProvider(IntFunction<? extends Game> gameProvider) {
        ShardManager.super.setGameProvider(gameProvider);
        this.gameProvider = gameProvider;
    }

    @Override
    public void setIdleProvider(IntFunction<Boolean> idleProvider) {
        ShardManager.super.setIdleProvider(idleProvider);
        this.idleProvider = idleProvider;
    }

    @Override
    public void setPresenceProvider(IntFunction<OnlineStatus> statusProvider, IntFunction<? extends Game> gameProvider) {
        ShardManager.super.setPresenceProvider(statusProvider, gameProvider);
        this.statusProvider = statusProvider;
        this.gameProvider = gameProvider;
    }

    @Override
    public void setStatusProvider(IntFunction<OnlineStatus> statusProvider) {
        ShardManager.super.setStatusProvider(statusProvider);
        this.statusProvider = statusProvider;
    }

    protected ScheduledExecutorService createExecutor(ThreadFactory threadFactory) {
        ThreadFactory factory = threadFactory == null ? DEFAULT_THREAD_FACTORY : threadFactory;
        return Executors.newSingleThreadScheduledExecutor(factory);
    }

    protected static <E extends ExecutorService> ExecutorPair<E> resolveExecutor(ThreadPoolProvider<? extends E> provider, int shardId) {
        Object executor = null;
        boolean automaticShutdown = true;
        if (provider != null) {
            executor = provider.provide(shardId);
            automaticShutdown = provider.shouldShutdownAutomatically(shardId);
        }
        return new ExecutorPair<Object>(executor, automaticShutdown);
    }

    protected static class ExecutorPair<E extends ExecutorService> {
        protected final E executor;
        protected final boolean automaticShutdown;

        protected ExecutorPair(E executor, boolean automaticShutdown) {
            this.executor = executor;
            this.automaticShutdown = automaticShutdown;
        }
    }
}

