/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.Objects;
import net.dv8tion.jda.client.entities.impl.FriendImpl;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.events.user.update.UserUpdateAvatarEvent;
import net.dv8tion.jda.core.events.user.update.UserUpdateDiscriminatorEvent;
import net.dv8tion.jda.core.events.user.update.UserUpdateGameEvent;
import net.dv8tion.jda.core.events.user.update.UserUpdateNameEvent;
import net.dv8tion.jda.core.events.user.update.UserUpdateOnlineStatusEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.utils.cache.CacheFlag;
import org.json.JSONObject;

public class PresenceUpdateHandler
extends SocketHandler {
    public PresenceUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        GuildImpl guild = null;
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
            guild = (GuildImpl)this.getJDA().getGuildById(guildId);
            if (guild == null) {
                this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
                EventCache.LOG.debug("Received a PRESENCE_UPDATE for a guild that is not yet cached! GuildId: " + guildId + " UserId: " + content.getJSONObject("user").get("id"));
                return null;
            }
        }
        JSONObject jsonUser = content.getJSONObject("user");
        long userId = jsonUser.getLong("id");
        UserImpl user = (UserImpl)this.getJDA().getUserMap().get(userId);
        if (user != null) {
            if (jsonUser.has("username")) {
                String name = jsonUser.getString("username");
                String discriminator = jsonUser.get("discriminator").toString();
                String avatarId = jsonUser.optString("avatar", null);
                String oldAvatar = user.getAvatarId();
                if (!user.getName().equals(name)) {
                    String oldUsername = user.getName();
                    user.setName(name);
                    this.getJDA().getEventManager().handle(new UserUpdateNameEvent(this.getJDA(), this.responseNumber, user, oldUsername));
                }
                if (!user.getDiscriminator().equals(discriminator)) {
                    String oldDiscriminator = user.getDiscriminator();
                    user.setDiscriminator(discriminator);
                    this.getJDA().getEventManager().handle(new UserUpdateDiscriminatorEvent(this.getJDA(), this.responseNumber, user, oldDiscriminator));
                }
                if (!Objects.equals(avatarId, oldAvatar)) {
                    String oldAvatarId = user.getAvatarId();
                    user.setAvatarId(avatarId);
                    this.getJDA().getEventManager().handle(new UserUpdateAvatarEvent(this.getJDA(), this.responseNumber, user, oldAvatarId));
                }
            }
            JSONObject game = !this.getJDA().isCacheFlagSet(CacheFlag.GAME) || content.isNull("game") ? null : content.optJSONObject("game");
            Game nextGame = null;
            boolean parsedGame = false;
            try {
                nextGame = game == null ? null : EntityBuilder.createGame(game);
                parsedGame = true;
            }
            catch (Exception ex) {
                if (EntityBuilder.LOG.isDebugEnabled()) {
                    EntityBuilder.LOG.warn("Encountered exception trying to parse a presence! UserID: {} JSON: {}", new Object[]{userId, game, ex});
                }
                EntityBuilder.LOG.warn("Encountered exception trying to parse a presence! UserID: {} Message: {} Enable debug for details", (Object)userId, (Object)ex.getMessage());
            }
            OnlineStatus status = OnlineStatus.fromKey(content.getString("status"));
            if (guild != null) {
                MemberImpl member = (MemberImpl)guild.getMember(user);
                if (member == null) {
                    if (status != OnlineStatus.OFFLINE) {
                        guild.getCachedPresenceMap().put(userId, (Object)content);
                        return null;
                    }
                } else {
                    if (!member.getOnlineStatus().equals((Object)status)) {
                        OnlineStatus oldStatus = member.getOnlineStatus();
                        member.setOnlineStatus(status);
                        this.getJDA().getEventManager().handle(new UserUpdateOnlineStatusEvent(this.getJDA(), this.responseNumber, user, guild, oldStatus));
                    }
                    if (parsedGame && !Objects.equals(member.getGame(), nextGame)) {
                        Game oldGame = member.getGame();
                        member.setGame(nextGame);
                        this.getJDA().getEventManager().handle(new UserUpdateGameEvent(this.getJDA(), this.responseNumber, user, guild, oldGame));
                    }
                }
            } else {
                if (this.getJDA().getAccountType() != AccountType.CLIENT) {
                    return null;
                }
                JDAClientImpl client = this.getJDA().asClient();
                FriendImpl friend = (FriendImpl)client.getFriendById(userId);
                if (friend != null) {
                    if (!friend.getOnlineStatus().equals((Object)status)) {
                        OnlineStatus oldStatus = friend.getOnlineStatus();
                        friend.setOnlineStatus(status);
                        this.getJDA().getEventManager().handle(new UserUpdateOnlineStatusEvent(this.getJDA(), this.responseNumber, user, null, oldStatus));
                    }
                    if (parsedGame && !Objects.equals(friend.getGame(), nextGame)) {
                        Game oldGame = friend.getGame();
                        friend.setGame(nextGame);
                        this.getJDA().getEventManager().handle(new UserUpdateGameEvent(this.getJDA(), this.responseNumber, user, null, oldGame));
                    }
                }
            }
        } else {
            OnlineStatus status = OnlineStatus.fromKey(content.getString("status"));
            if (status != OnlineStatus.OFFLINE && guild != null) {
                guild.getCachedPresenceMap().put(userId, (Object)content);
            }
        }
        return null;
    }
}

