/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core;

import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.bot.JDABot;
import net.dv8tion.jda.client.JDAClient;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.SelfUser;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.Presence;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.restaction.GuildAction;
import net.dv8tion.jda.core.utils.cache.CacheView;
import net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;

public interface JDA {
    public Status getStatus();

    public long getPing();

    public JDA awaitStatus(Status var1) throws InterruptedException;

    default public JDA awaitReady() throws InterruptedException {
        return this.awaitStatus(Status.CONNECTED);
    }

    public List<String> getCloudflareRays();

    public List<String> getWebSocketTrace();

    public void setEventManager(IEventManager var1);

    public void addEventListener(Object ... var1);

    public void removeEventListener(Object ... var1);

    public List<Object> getRegisteredListeners();

    public GuildAction createGuild(String var1);

    public CacheView<AudioManager> getAudioManagerCache();

    default public List<AudioManager> getAudioManagers() {
        return this.getAudioManagerCache().asList();
    }

    public SnowflakeCacheView<User> getUserCache();

    default public List<User> getUsers() {
        return this.getUserCache().asList();
    }

    default public User getUserById(String id) {
        return this.getUserCache().getElementById(id);
    }

    default public User getUserById(long id) {
        return this.getUserCache().getElementById(id);
    }

    default public List<User> getUsersByName(String name, boolean ignoreCase) {
        return this.getUserCache().getElementsByName(name, ignoreCase);
    }

    public List<Guild> getMutualGuilds(User ... var1);

    public List<Guild> getMutualGuilds(Collection<User> var1);

    @CheckReturnValue
    public RestAction<User> retrieveUserById(String var1);

    @CheckReturnValue
    public RestAction<User> retrieveUserById(long var1);

    public SnowflakeCacheView<Guild> getGuildCache();

    default public List<Guild> getGuilds() {
        return this.getGuildCache().asList();
    }

    default public Guild getGuildById(String id) {
        return this.getGuildCache().getElementById(id);
    }

    default public Guild getGuildById(long id) {
        return this.getGuildCache().getElementById(id);
    }

    default public List<Guild> getGuildsByName(String name, boolean ignoreCase) {
        return this.getGuildCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<Role> getRoleCache();

    default public List<Role> getRoles() {
        return this.getRoleCache().asList();
    }

    default public Role getRoleById(String id) {
        return this.getRoleCache().getElementById(id);
    }

    default public Role getRoleById(long id) {
        return this.getRoleCache().getElementById(id);
    }

    default public List<Role> getRolesByName(String name, boolean ignoreCase) {
        return this.getRoleCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<Category> getCategoryCache();

    default public Category getCategoryById(String id) {
        return this.getCategoryCache().getElementById(id);
    }

    default public Category getCategoryById(long id) {
        return this.getCategoryCache().getElementById(id);
    }

    default public List<Category> getCategories() {
        return this.getCategoryCache().asList();
    }

    default public List<Category> getCategoriesByName(String name, boolean ignoreCase) {
        return this.getCategoryCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<TextChannel> getTextChannelCache();

    default public List<TextChannel> getTextChannels() {
        return this.getTextChannelCache().asList();
    }

    default public TextChannel getTextChannelById(String id) {
        return this.getTextChannelCache().getElementById(id);
    }

    default public TextChannel getTextChannelById(long id) {
        return this.getTextChannelCache().getElementById(id);
    }

    default public List<TextChannel> getTextChannelsByName(String name, boolean ignoreCase) {
        return this.getTextChannelCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<VoiceChannel> getVoiceChannelCache();

    default public List<VoiceChannel> getVoiceChannels() {
        return this.getVoiceChannelCache().asList();
    }

    default public VoiceChannel getVoiceChannelById(String id) {
        return this.getVoiceChannelCache().getElementById(id);
    }

    default public VoiceChannel getVoiceChannelById(long id) {
        return this.getVoiceChannelCache().getElementById(id);
    }

    default public List<VoiceChannel> getVoiceChannelByName(String name, boolean ignoreCase) {
        return this.getVoiceChannelCache().getElementsByName(name, ignoreCase);
    }

    public SnowflakeCacheView<PrivateChannel> getPrivateChannelCache();

    default public List<PrivateChannel> getPrivateChannels() {
        return this.getPrivateChannelCache().asList();
    }

    default public PrivateChannel getPrivateChannelById(String id) {
        return this.getPrivateChannelCache().getElementById(id);
    }

    default public PrivateChannel getPrivateChannelById(long id) {
        return this.getPrivateChannelCache().getElementById(id);
    }

    public SnowflakeCacheView<Emote> getEmoteCache();

    default public List<Emote> getEmotes() {
        return this.getEmoteCache().asList();
    }

    default public Emote getEmoteById(String id) {
        return this.getEmoteCache().getElementById(id);
    }

    default public Emote getEmoteById(long id) {
        return this.getEmoteCache().getElementById(id);
    }

    default public List<Emote> getEmotesByName(String name, boolean ignoreCase) {
        return this.getEmoteCache().getElementsByName(name, ignoreCase);
    }

    public IEventManager getEventManager();

    public SelfUser getSelfUser();

    public Presence getPresence();

    public ShardInfo getShardInfo();

    public String getToken();

    public long getResponseTotal();

    public int getMaxReconnectDelay();

    public void setAutoReconnect(boolean var1);

    public void setRequestTimeoutRetry(boolean var1);

    public boolean isAutoReconnect();

    public boolean isAudioEnabled();

    public boolean isBulkDeleteSplittingEnabled();

    public void shutdown();

    public void shutdownNow();

    public AccountType getAccountType();

    public JDAClient asClient();

    public JDABot asBot();

    public RestAction<Webhook> getWebhookById(String var1);

    default public RestAction<Webhook> getWebhookById(long webhookId) {
        return this.getWebhookById(Long.toUnsignedString(webhookId));
    }

    public static class ShardInfo {
        int shardId;
        int shardTotal;

        public ShardInfo(int shardId, int shardTotal) {
            this.shardId = shardId;
            this.shardTotal = shardTotal;
        }

        public int getShardId() {
            return this.shardId;
        }

        public int getShardTotal() {
            return this.shardTotal;
        }

        public String getShardString() {
            return "[" + this.shardId + " / " + this.shardTotal + "]";
        }

        public String toString() {
            return "Shard " + this.getShardString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ShardInfo)) {
                return false;
            }
            ShardInfo oInfo = (ShardInfo)o;
            return this.shardId == oInfo.getShardId() && this.shardTotal == oInfo.getShardTotal();
        }
    }

    public static enum Status {
        INITIALIZING(true),
        INITIALIZED(true),
        LOGGING_IN(true),
        CONNECTING_TO_WEBSOCKET(true),
        IDENTIFYING_SESSION(true),
        AWAITING_LOGIN_CONFIRMATION(true),
        LOADING_SUBSYSTEMS(true),
        CONNECTED(true),
        DISCONNECTED,
        RECONNECT_QUEUED,
        WAITING_TO_RECONNECT,
        ATTEMPTING_TO_RECONNECT,
        SHUTTING_DOWN,
        SHUTDOWN,
        FAILED_TO_LOGIN;

        private final boolean isInit;

        private Status(boolean isInit) {
            this.isInit = isInit;
        }

        private Status() {
            this.isInit = false;
        }

        public boolean isInit() {
            return this.isInit;
        }
    }
}

