/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.entities.impl;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.client.entities.Call;
import net.dv8tion.jda.client.entities.CallUser;
import net.dv8tion.jda.client.entities.CallableChannel;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.utils.MiscUtil;

public class CallImpl
implements Call {
    private final CallableChannel callableChannel;
    private final long messageId;
    private final TLongObjectMap<CallUser> callUsers = MiscUtil.newLongMap();
    private final TLongObjectMap<CallUser> callUserHistory = MiscUtil.newLongMap();
    private Region region;

    public CallImpl(CallableChannel callableChannel, long messageId) {
        this.callableChannel = callableChannel;
        this.messageId = messageId;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public boolean isGroupCall() {
        return this.callableChannel instanceof Group;
    }

    @Override
    public CallableChannel getCallableChannel() {
        return this.callableChannel;
    }

    @Override
    public Group getGroup() {
        return this.isGroupCall() ? (Group)this.callableChannel : null;
    }

    @Override
    public PrivateChannel getPrivateChannel() {
        return !this.isGroupCall() ? (PrivateChannel)this.callableChannel : null;
    }

    @Override
    public String getMessageId() {
        return Long.toUnsignedString(this.messageId);
    }

    @Override
    public long getMessageIdLong() {
        return this.messageId;
    }

    @Override
    public List<CallUser> getRingingUsers() {
        return Collections.unmodifiableList(this.callUsers.valueCollection().stream().filter(CallUser::isRinging).collect(Collectors.toList()));
    }

    @Override
    public List<CallUser> getConnectedUsers() {
        return Collections.unmodifiableList(this.callUsers.valueCollection().stream().filter(cu -> cu.getVoiceState().isInCall()).collect(Collectors.toList()));
    }

    @Override
    public List<CallUser> getCallUserHistory() {
        return Collections.unmodifiableList(new ArrayList(this.callUserHistory.valueCollection()));
    }

    @Override
    public List<CallUser> getAllCallUsers() {
        return Collections.unmodifiableList(new ArrayList(this.callUsers.valueCollection()));
    }

    @Override
    public long getIdLong() {
        return this.callableChannel.getIdLong();
    }

    public String toString() {
        return "Call(" + this.getIdLong() + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Call)) {
            return false;
        }
        Call oCall = (Call)o;
        return this.getIdLong() == oCall.getIdLong() && this.messageId == oCall.getMessageIdLong();
    }

    public int hashCode() {
        return ("Call " + this.getId()).hashCode();
    }

    public CallImpl setRegion(Region region) {
        this.region = region;
        return this;
    }

    public TLongObjectMap<CallUser> getCallUserMap() {
        return this.callUsers;
    }

    public TLongObjectMap<CallUser> getCallUserHistoryMap() {
        return this.callUserHistory;
    }
}

