/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.dv8tion.jda.client.managers.EmoteManager;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.ListedEmote;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.utils.MiscUtil;

public class EmoteImpl
implements ListedEmote {
    private final long id;
    private final GuildImpl guild;
    private final JDAImpl api;
    private final Set<Role> roles;
    private final boolean fake;
    private final ReentrantLock mngLock = new ReentrantLock();
    private volatile EmoteManager manager = null;
    private boolean managed = false;
    private boolean animated = false;
    private String name;
    private User user;

    public EmoteImpl(long id, GuildImpl guild) {
        this(id, guild, false);
    }

    public EmoteImpl(long id, GuildImpl guild, boolean fake) {
        this.id = id;
        this.guild = guild;
        this.api = guild.getJDA();
        this.roles = Collections.synchronizedSet(new HashSet());
        this.fake = fake;
    }

    public EmoteImpl(long id, JDAImpl api) {
        this.id = id;
        this.api = api;
        this.guild = null;
        this.roles = null;
        this.fake = true;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public List<Role> getRoles() {
        if (!this.hasRoles()) {
            throw new IllegalStateException("Unable to return roles because this emote is fake. (We do not know the origin Guild of this emote)");
        }
        return Collections.unmodifiableList(new LinkedList<Role>(this.roles));
    }

    @Override
    public boolean hasRoles() {
        return this.roles != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public User getUser() {
        if (!this.hasUser()) {
            throw new IllegalStateException("This emote does not have a user");
        }
        return this.user;
    }

    @Override
    public boolean hasUser() {
        return this.user != null;
    }

    @Override
    public EmoteManager getManager() {
        EmoteManager m = this.manager;
        if (m == null) {
            m = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new EmoteManager(this);
                }
                return this.manager;
            });
        }
        return m;
    }

    @Override
    public boolean isAnimated() {
        return this.animated;
    }

    @Override
    public AuditableRestAction<Void> delete() {
        if (this.getGuild() == null) {
            throw new IllegalStateException("The emote you are trying to delete is not an actual emote we have access to (it is fake)!");
        }
        if (this.managed) {
            throw new UnsupportedOperationException("You cannot delete a managed emote!");
        }
        if (!this.guild.getSelfMember().hasPermission(Permission.MANAGE_EMOTES)) {
            throw new InsufficientPermissionException(Permission.MANAGE_EMOTES);
        }
        Route.CompiledRoute route = Route.Emotes.DELETE_EMOTE.compile(this.getGuild().getId(), this.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public EmoteImpl setName(String name) {
        this.name = name;
        return this;
    }

    public EmoteImpl setAnimated(boolean animated) {
        this.animated = animated;
        return this;
    }

    public EmoteImpl setManaged(boolean val) {
        this.managed = val;
        return this;
    }

    public EmoteImpl setUser(User user) {
        this.user = user;
        return this;
    }

    public Set<Role> getRoleSet() {
        return this.roles;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EmoteImpl)) {
            return false;
        }
        EmoteImpl oEmote = (EmoteImpl)obj;
        return this.id == oEmote.id && this.getName().equals(oEmote.getName());
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "E:" + this.getName() + '(' + this.getIdLong() + ')';
    }

    public EmoteImpl clone() {
        if (this.isFake()) {
            return null;
        }
        EmoteImpl copy = new EmoteImpl(this.id, this.guild).setUser(this.user).setManaged(this.managed).setAnimated(this.animated).setName(this.name);
        copy.roles.addAll(this.roles);
        return copy;
    }
}

