/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client;

import java.util.List;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.client.entities.Application;
import net.dv8tion.jda.client.entities.AuthorizedApplication;
import net.dv8tion.jda.client.entities.Friend;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.entities.UserSettings;
import net.dv8tion.jda.client.requests.restaction.ApplicationAction;
import net.dv8tion.jda.client.requests.restaction.pagination.MentionPaginationAction;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;

public interface JDAClient {
    public JDA getJDA();

    public SnowflakeCacheView<Group> getGroupCache();

    default public List<Group> getGroups() {
        return this.getGroupCache().asList();
    }

    default public List<Group> getGroupsByName(String name, boolean ignoreCase) {
        return this.getGroupCache().getElementsByName(name, ignoreCase);
    }

    default public Group getGroupById(String id) {
        return this.getGroupCache().getElementById(id);
    }

    default public Group getGroupById(long id) {
        return this.getGroupCache().getElementById(id);
    }

    public List<Relationship> getRelationships();

    public List<Relationship> getRelationships(RelationshipType var1);

    public List<Relationship> getRelationships(RelationshipType var1, String var2, boolean var3);

    public List<Relationship> getRelationshipsByName(String var1, boolean var2);

    public Relationship getRelationship(User var1);

    public Relationship getRelationship(Member var1);

    public Relationship getRelationshipById(String var1);

    public Relationship getRelationshipById(long var1);

    public Relationship getRelationshipById(String var1, RelationshipType var2);

    public Relationship getRelationshipById(long var1, RelationshipType var3);

    public List<Friend> getFriends();

    public List<Friend> getFriendsByName(String var1, boolean var2);

    public Friend getFriend(User var1);

    public Friend getFriend(Member var1);

    public Friend getFriendById(String var1);

    public Friend getFriendById(long var1);

    @CheckReturnValue
    public MentionPaginationAction getRecentMentions();

    @CheckReturnValue
    public MentionPaginationAction getRecentMentions(Guild var1);

    public UserSettings getSettings();

    @CheckReturnValue
    public ApplicationAction createApplication(String var1);

    @CheckReturnValue
    public RestAction<List<Application>> getApplications();

    @CheckReturnValue
    public RestAction<Application> getApplicationById(String var1);

    @CheckReturnValue
    public RestAction<List<AuthorizedApplication>> getAuthorizedApplications();

    @CheckReturnValue
    public RestAction<AuthorizedApplication> getAuthorizedApplicationById(String var1);
}

