/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils;

import com.neovisionaries.ws.client.OpeningHandshakeException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.JDALogger;
import net.dv8tion.jda.core.utils.SessionController;
import net.dv8tion.jda.core.utils.tuple.Pair;
import org.json.JSONObject;
import org.slf4j.Logger;

public class SessionControllerAdapter
implements SessionController {
    protected static final Logger log = JDALogger.getLog(SessionControllerAdapter.class);
    protected final Object lock = new Object();
    protected Queue<SessionController.SessionConnectNode> connectQueue = new ConcurrentLinkedQueue<SessionController.SessionConnectNode>();
    protected AtomicLong globalRatelimit = new AtomicLong(Long.MIN_VALUE);
    protected Thread workerHandle;
    protected long lastConnect = 0L;

    @Override
    public void appendSession(SessionController.SessionConnectNode node) {
        this.connectQueue.add(node);
        this.runWorker();
    }

    @Override
    public void removeSession(SessionController.SessionConnectNode node) {
        this.connectQueue.remove(node);
    }

    @Override
    public long getGlobalRatelimit() {
        return this.globalRatelimit.get();
    }

    @Override
    public void setGlobalRatelimit(long ratelimit) {
        this.globalRatelimit.set(ratelimit);
    }

    @Override
    public String getGateway(JDA api) {
        Route.CompiledRoute route = Route.Misc.GATEWAY.compile(new String[0]);
        return (String)new RestAction<String>(api, route){

            @Override
            protected void handleResponse(Response response, Request<String> request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject().getString("url"));
                } else {
                    request.onFailure(response);
                }
            }
        }.complete();
    }

    @Override
    public Pair<String, Integer> getGatewayBot(JDA api) {
        AccountTypeException.check(api.getAccountType(), AccountType.BOT);
        return (Pair)new RestAction<Pair<String, Integer>>(api, Route.Misc.GATEWAY_BOT.compile(new String[0])){

            @Override
            protected void handleResponse(Response response, Request<Pair<String, Integer>> request) {
                try {
                    if (response.isOk()) {
                        JSONObject object = response.getObject();
                        String url = object.getString("url");
                        int shards = object.getInt("shards");
                        request.onSuccess(Pair.of(url, shards));
                    } else if (response.code == 401) {
                        this.api.verifyToken(true);
                    } else {
                        request.onFailure(new LoginException("When verifying the authenticity of the provided token, Discord returned an unknown response:\n" + response.toString()));
                    }
                }
                catch (Exception e) {
                    request.onFailure(e);
                }
            }
        }.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWorker() {
        Object object = this.lock;
        synchronized (object) {
            if (this.workerHandle == null) {
                this.workerHandle = new QueueWorker();
                this.workerHandle.start();
            }
        }
    }

    protected class QueueWorker
    extends Thread {
        protected final long delay;

        public QueueWorker() {
            this(5);
        }

        public QueueWorker(int delay) {
            this(TimeUnit.SECONDS.toMillis(delay));
        }

        public QueueWorker(long delay) {
            super("SessionControllerAdapter-Worker");
            this.delay = delay;
            super.setUncaughtExceptionHandler(this::handleFailure);
        }

        protected void handleFailure(Thread thread, Throwable exception) {
            log.error("Worker has failed with throwable!", exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long interval;
                if (this.delay > 0L && (interval = System.currentTimeMillis() - SessionControllerAdapter.this.lastConnect) < this.delay) {
                    Thread.sleep(this.delay - interval);
                }
            }
            catch (InterruptedException ex) {
                log.error("Unable to backoff", (Throwable)ex);
            }
            this.processQueue();
            Object object = SessionControllerAdapter.this.lock;
            synchronized (object) {
                SessionControllerAdapter.this.workerHandle = null;
                if (!SessionControllerAdapter.this.connectQueue.isEmpty()) {
                    SessionControllerAdapter.this.runWorker();
                }
            }
        }

        protected void processQueue() {
            while (!SessionControllerAdapter.this.connectQueue.isEmpty()) {
                SessionController.SessionConnectNode node = SessionControllerAdapter.this.connectQueue.poll();
                try {
                    node.run(SessionControllerAdapter.this.connectQueue.isEmpty());
                    SessionControllerAdapter.this.lastConnect = System.currentTimeMillis();
                    if (SessionControllerAdapter.this.connectQueue.isEmpty()) break;
                    if (this.delay <= 0L) continue;
                    Thread.sleep(this.delay);
                }
                catch (IllegalStateException e) {
                    Throwable t = e.getCause();
                    if (t instanceof OpeningHandshakeException) {
                        log.error("Failed opening handshake, appending to queue. Message: {}", (Object)e.getMessage());
                    } else {
                        log.error("Failed to establish connection for a node, appending to queue", (Throwable)e);
                    }
                    SessionControllerAdapter.this.appendSession(node);
                }
                catch (InterruptedException e) {
                    log.error("Failed to run node", (Throwable)e);
                    SessionControllerAdapter.this.appendSession(node);
                    return;
                }
            }
        }
    }
}

