/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import gnu.trove.iterator.TLongIterator;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.impl.FriendImpl;
import net.dv8tion.jda.client.entities.impl.UserSettingsImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReadyHandler
extends SocketHandler {
    private final TLongSet incompleteGuilds = new TLongHashSet();
    private final TLongSet acknowledgedGuilds = new TLongHashSet();
    private final TLongSet unavailableGuilds = new TLongHashSet();
    private final TLongSet guildsRequiringChunking = new TLongHashSet();
    private final TLongSet guildsRequiringSyncing = new TLongHashSet();

    public ReadyHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        JSONObject guild;
        int i;
        EntityBuilder builder = this.api.getEntityBuilder();
        JSONArray guilds = content.getJSONArray("guilds");
        JSONObject selfJson = content.getJSONObject("user");
        builder.createSelfUser(selfJson);
        if (this.api.getAccountType() == AccountType.CLIENT && !content.isNull("user_settings")) {
            JSONObject userSettingsJson = content.getJSONObject("user_settings");
            UserSettingsImpl userSettingsObj = (UserSettingsImpl)this.api.asClient().getSettings();
            userSettingsObj.setStatus(userSettingsJson.isNull("status") ? OnlineStatus.ONLINE : OnlineStatus.fromKey(userSettingsJson.getString("status")));
            if (userSettingsObj.getStatus() != OnlineStatus.ONLINE) {
                ((PresenceImpl)this.api.getPresence()).setCacheStatus(userSettingsObj.getStatus());
            }
        }
        for (i = 0; i < guilds.length(); ++i) {
            guild = guilds.getJSONObject(i);
            this.incompleteGuilds.add(guild.getLong("id"));
        }
        for (i = 0; i < guilds.length(); ++i) {
            guild = guilds.getJSONObject(i);
            if (guild.has("unavailable") && guild.getBoolean("unavailable")) {
                builder.createGuildFirstPass(guild, null);
                continue;
            }
            builder.createGuildFirstPass(guild, this::guildSetupComplete);
        }
        if (guilds.length() == 0) {
            this.guildLoadComplete(content);
        }
        return null;
    }

    public void guildLoadComplete(JSONObject content) {
        this.api.getClient().setChunkingAndSyncing(false);
        EntityBuilder builder = this.api.getEntityBuilder();
        JSONArray privateChannels = content.getJSONArray("private_channels");
        if (this.api.getAccountType() == AccountType.CLIENT) {
            int i;
            JSONArray relationships = content.getJSONArray("relationships");
            JSONArray presences = content.getJSONArray("presences");
            JSONObject notes = content.getJSONObject("notes");
            JSONArray readstates = content.has("read_state") ? content.getJSONArray("read_state") : null;
            JSONArray guildSettings = content.has("user_guild_settings") ? content.getJSONArray("user_guild_settings") : null;
            for (i = 0; i < relationships.length(); ++i) {
                JSONObject relationship = relationships.getJSONObject(i);
                Relationship r = builder.createRelationship(relationship);
                if (r != null) continue;
                JDAImpl.LOG.error("Provided relationship in READY with an unknown type! JSON: {}", (Object)relationship);
            }
            for (i = 0; i < presences.length(); ++i) {
                JSONObject presence = presences.getJSONObject(i);
                String userId = presence.getJSONObject("user").getString("id");
                FriendImpl friend = (FriendImpl)this.api.asClient().getFriendById(userId);
                if (friend == null) {
                    WebSocketClient.LOG.warn("Received a presence in the Presences array in READY that did not correspond to a cached Friend! JSON: {}", (Object)presence);
                    continue;
                }
                builder.createPresence(friend, presence);
            }
        }
        block6: for (int i = 0; i < privateChannels.length(); ++i) {
            JSONObject chan = privateChannels.getJSONObject(i);
            ChannelType type = ChannelType.fromId(chan.getInt("type"));
            switch (type) {
                case PRIVATE: {
                    builder.createPrivateChannel(chan);
                    continue block6;
                }
                case GROUP: {
                    builder.createGroup(chan);
                    continue block6;
                }
                default: {
                    WebSocketClient.LOG.warn("Received a Channel in the priv_channels array in READY of an unknown type! JSON: {}", (Object)type);
                }
            }
        }
        this.api.getClient().ready();
    }

    public void acknowledgeGuild(Guild guild, boolean available, boolean requiresChunking, boolean requiresSync) {
        this.acknowledgedGuilds.add(guild.getIdLong());
        if (available) {
            this.unavailableGuilds.remove(guild.getIdLong());
            if (requiresChunking) {
                this.guildsRequiringChunking.add(guild.getIdLong());
            }
            if (requiresSync) {
                this.guildsRequiringSyncing.add(guild.getIdLong());
            }
        } else {
            this.unavailableGuilds.add(guild.getIdLong());
        }
        this.checkIfReadyToSendRequests();
    }

    public void guildSetupComplete(Guild guild) {
        if (!this.incompleteGuilds.remove(guild.getIdLong())) {
            WebSocketClient.LOG.error("Completed the setup for Guild: {} without matching id in ReadyHandler cache", (Object)guild);
        }
        if (this.incompleteGuilds.size() == this.unavailableGuilds.size()) {
            this.guildLoadComplete(this.allContent.getJSONObject("d"));
        } else {
            this.checkIfReadyToSendRequests();
        }
    }

    public void clearCache() {
        this.incompleteGuilds.clear();
        this.acknowledgedGuilds.clear();
        this.unavailableGuilds.clear();
        this.guildsRequiringChunking.clear();
        this.guildsRequiringSyncing.clear();
    }

    private void checkIfReadyToSendRequests() {
        if (this.acknowledgedGuilds.size() == this.incompleteGuilds.size()) {
            this.api.getClient().setChunkingAndSyncing(true);
            if (this.api.getAccountType() == AccountType.CLIENT) {
                this.sendGuildSyncRequests();
            }
            this.sendMemberChunkRequests();
        }
    }

    private void sendGuildSyncRequests() {
        if (this.guildsRequiringSyncing.isEmpty()) {
            return;
        }
        JSONArray guildIds = new JSONArray();
        TLongIterator it = this.guildsRequiringSyncing.iterator();
        while (it.hasNext()) {
            guildIds.put(it.next());
            if (guildIds.length() != 50) continue;
            this.api.getClient().chunkOrSyncRequest(new JSONObject().put("op", 12).put("d", (Object)guildIds));
            guildIds = new JSONArray();
        }
        if (guildIds.length() > 0) {
            this.api.getClient().chunkOrSyncRequest(new JSONObject().put("op", 12).put("d", (Object)guildIds));
        }
        this.guildsRequiringSyncing.clear();
    }

    private void sendMemberChunkRequests() {
        if (this.guildsRequiringChunking.isEmpty()) {
            return;
        }
        JSONArray guildIds = new JSONArray();
        TLongIterator it = this.guildsRequiringChunking.iterator();
        while (it.hasNext()) {
            guildIds.put(it.next());
            if (guildIds.length() != 50) continue;
            this.api.getClient().chunkOrSyncRequest(new JSONObject().put("op", 8).put("d", (Object)new JSONObject().put("guild_id", (Object)guildIds).put("query", (Object)"").put("limit", 0)));
            guildIds = new JSONArray();
        }
        if (guildIds.length() > 0) {
            this.api.getClient().chunkOrSyncRequest(new JSONObject().put("op", 8).put("d", (Object)new JSONObject().put("guild_id", (Object)guildIds).put("query", (Object)"").put("limit", 0)));
        }
        this.guildsRequiringChunking.clear();
    }
}

