/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.events.message.group.react.GroupMessageReactionRemoveAllEvent;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.message.guild.react.GuildMessageReactionRemoveAllEvent;
import net.dv8tion.jda.core.events.message.react.MessageReactionRemoveAllEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.hooks.IEventManager;
import org.json.JSONObject;

public class MessageReactionBulkRemoveHandler
extends SocketHandler {
    public MessageReactionBulkRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long messageId = content.getLong("message_id");
        long channelId = content.getLong("channel_id");
        TextChannel channel = this.api.getTextChannelById(channelId);
        if (channel == null) {
            this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a reaction for a channel that JDA does not currently have cached channel_id: {} message_id: {}", (Object)channelId, (Object)messageId);
            return null;
        }
        IEventManager manager = this.api.getEventManager();
        switch (channel.getType()) {
            case TEXT: {
                manager.handle(new GuildMessageReactionRemoveAllEvent(this.api, this.responseNumber, messageId, channel));
                break;
            }
            case GROUP: {
                manager.handle(new GroupMessageReactionRemoveAllEvent(this.api, this.responseNumber, messageId, (Group)((Object)channel)));
            }
        }
        manager.handle(new MessageReactionRemoveAllEvent(this.api, this.responseNumber, messageId, channel));
        return null;
    }
}

