/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.guild.member.GuildMemberJoinEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class GuildMemberAddHandler
extends SocketHandler {
    public GuildMemberAddHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("guild_id");
        if (this.api.getGuildLock().isLocked(id)) {
            return id;
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(id);
        if (guild == null) {
            this.api.getEventCache().cache(EventCache.Type.GUILD, id, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Caching member for guild that is not yet cached. Guild ID: {} JSON: {}", (Object)id, (Object)content);
            return null;
        }
        Member member = this.api.getEntityBuilder().createMember(guild, content);
        this.api.getEventManager().handle(new GuildMemberJoinEvent((JDA)this.api, this.responseNumber, member));
        this.api.getEventCache().playbackCache(EventCache.Type.USER, member.getUser().getIdLong());
        return null;
    }
}

