/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.client.exceptions.VerificationLevelException;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.IPermissionHolder;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.WebhookImpl;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.requests.restaction.ChannelAction;
import net.dv8tion.jda.core.requests.restaction.MessageAction;
import net.dv8tion.jda.core.requests.restaction.WebhookAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextChannelImpl
extends AbstractChannelImpl<TextChannelImpl>
implements TextChannel {
    private String topic;
    private long lastMessageId;
    private boolean nsfw;

    public TextChannelImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    public String getAsMention() {
        return "<#" + this.id + '>';
    }

    @Override
    public RestAction<List<Webhook>> getWebhooks() {
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Channels.GET_WEBHOOKS.compile(this.getId());
        return new RestAction<List<Webhook>>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Webhook>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                JSONArray array = response.getArray();
                ArrayList<WebhookImpl> webhooks = new ArrayList<WebhookImpl>(array.length());
                EntityBuilder builder = this.api.getEntityBuilder();
                for (Object object : array) {
                    try {
                        webhooks.add(builder.createWebhook((JSONObject)object));
                    }
                    catch (NullPointerException | JSONException e) {
                        JDAImpl.LOG.error("Error while creating websocket from json", e);
                    }
                }
                request.onSuccess(Collections.unmodifiableList(webhooks));
            }
        };
    }

    @Override
    public WebhookAction createWebhook(String name) {
        Checks.notBlank(name, "Webhook name");
        name = name.trim();
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Checks.check(name.length() >= 2 && name.length() <= 100, "Name must be 2-100 characters in length!");
        Route.CompiledRoute route = Route.Channels.CREATE_WEBHOOK.compile(this.getId());
        return new WebhookAction(this.getJDA(), route, name);
    }

    @Override
    public RestAction<Void> deleteMessages(Collection<Message> messages) {
        Checks.notEmpty(messages, "Messages collection");
        return this.deleteMessagesByIds(messages.stream().map(ISnowflake::getId).collect(Collectors.toList()));
    }

    @Override
    public RestAction<Void> deleteMessagesByIds(Collection<String> messageIds) {
        this.checkPermission(Permission.MESSAGE_MANAGE, "Must have MESSAGE_MANAGE in order to bulk delete messages in this channel regardless of author.");
        if (messageIds.size() < 2 || messageIds.size() > 100) {
            throw new IllegalArgumentException("Must provide at least 2 or at most 100 messages to be deleted.");
        }
        long twoWeeksAgo = System.currentTimeMillis() - 1209600000L - 1420070400000L << 22;
        for (String id : messageIds) {
            Checks.check(MiscUtil.parseSnowflake(id) > twoWeeksAgo, "Message Id provided was older than 2 weeks. Id: " + id);
        }
        JSONObject body = new JSONObject().put("messages", messageIds);
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGES.compile(this.getId());
        return new RestAction<Void>(this.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public AuditableRestAction<Void> deleteWebhookById(String id) {
        Checks.isSnowflake(id, "Webhook ID");
        if (!this.guild.getSelfMember().hasPermission((Channel)this, Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_WEBHOOKS);
        }
        Route.CompiledRoute route = Route.Webhooks.DELETE_WEBHOOK.compile(id);
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public boolean canTalk() {
        return this.canTalk(this.guild.getSelfMember());
    }

    @Override
    public boolean canTalk(Member member) {
        if (!this.guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided Member is not from the Guild that this TextChannel is part of.");
        }
        return member.hasPermission((Channel)this, Permission.MESSAGE_READ, Permission.MESSAGE_WRITE);
    }

    @Override
    public long getLatestMessageIdLong() {
        long messageId = this.lastMessageId;
        if (messageId == 0L) {
            throw new IllegalStateException("No last message id found.");
        }
        return messageId;
    }

    @Override
    public boolean hasLatestMessage() {
        return this.lastMessageId != 0L;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.TEXT;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public boolean isNSFW() {
        return this.nsfw || this.name.equals("nsfw") || this.name.startsWith("nsfw-");
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(this.guild.getMembersMap().valueCollection().stream().filter(m -> m.hasPermission((Channel)this, Permission.MESSAGE_READ)).collect(Collectors.toList()));
    }

    @Override
    public int getPosition() {
        List<TextChannel> channels = this.guild.getTextChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new AssertionError((Object)"Somehow when determining position we never found the TextChannel in the Guild's channels? wtf?");
    }

    @Override
    public ChannelAction createCopy(Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction action = guild.getController().createTextChannel(this.name).setNSFW(this.nsfw).setTopic(this.topic);
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParent();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.overrides.valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addPermissionOverride((IPermissionHolder)o.getMember(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addPermissionOverride((IPermissionHolder)o.getRole(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }

    @Override
    public MessageAction sendMessage(CharSequence text) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        return TextChannel.super.sendMessage(text);
    }

    @Override
    public MessageAction sendMessage(MessageEmbed embed) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        return TextChannel.super.sendMessage(embed);
    }

    @Override
    public MessageAction sendMessage(Message msg) {
        Checks.notNull(msg, "Message");
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        if (msg.getContentRaw().isEmpty() && !msg.getEmbeds().isEmpty()) {
            this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        }
        return TextChannel.super.sendMessage(msg);
    }

    @Override
    public MessageAction sendFile(InputStream data, String fileName, Message message) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        return TextChannel.super.sendFile(data, fileName, message);
    }

    @Override
    public RestAction<Message> getMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.getMessageById(messageId);
    }

    @Override
    public AuditableRestAction<Void> deleteMessageById(String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        this.checkPermission(Permission.MESSAGE_READ);
        return TextChannel.super.deleteMessageById(messageId);
    }

    @Override
    public RestAction<Void> pinMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ, "You cannot pin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        return TextChannel.super.pinMessageById(messageId);
    }

    @Override
    public RestAction<Void> unpinMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ, "You cannot unpin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        return TextChannel.super.unpinMessageById(messageId);
    }

    @Override
    public RestAction<List<Message>> getPinnedMessages() {
        this.checkPermission(Permission.MESSAGE_READ, "Cannot get the pinned message of a channel without MESSAGE_READ access.");
        return TextChannel.super.getPinnedMessages();
    }

    @Override
    public RestAction<Void> addReactionById(String messageId, String unicode) {
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.addReactionById(messageId, unicode);
    }

    @Override
    public RestAction<Void> addReactionById(String messageId, Emote emote) {
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.addReactionById(messageId, emote);
    }

    @Override
    public RestAction<Void> clearReactionsById(String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        this.checkPermission(Permission.MESSAGE_MANAGE);
        Route.CompiledRoute route = Route.Messages.REMOVE_ALL_REACTIONS.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> removeReactionById(String messageId, String unicode, User user) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.noWhitespace(unicode, "Unicode emoji");
        Checks.notNull(user, "User");
        if (!this.getJDA().getSelfUser().equals(user)) {
            this.checkPermission(Permission.MESSAGE_MANAGE);
        }
        String code = MiscUtil.encodeUTF8(unicode);
        Route.CompiledRoute route = user.equals(this.getJDA().getSelfUser()) ? Route.Messages.REMOVE_OWN_REACTION.compile(this.getId(), messageId, code) : Route.Messages.REMOVE_REACTION.compile(this.getId(), messageId, code, user.getId());
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                } else {
                    request.onSuccess(null);
                }
            }
        };
    }

    @Override
    public MessageAction editMessageById(String messageId, CharSequence newContent) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        return TextChannel.super.editMessageById(messageId, newContent);
    }

    @Override
    public MessageAction editMessageById(String messageId, MessageEmbed newEmbed) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        return TextChannel.super.editMessageById(messageId, newEmbed);
    }

    @Override
    public MessageAction editMessageById(String id, Message newContent) {
        Checks.notNull(newContent, "Message");
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        if (newContent.getContentRaw().isEmpty() && !newContent.getEmbeds().isEmpty()) {
            this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        }
        return TextChannel.super.editMessageById(id, newContent);
    }

    public String toString() {
        return "TC:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public int compareTo(TextChannel chan) {
        Checks.notNull(chan, "Other TextChannel");
        if (this == chan) {
            return 0;
        }
        Checks.check(this.getGuild().equals(chan.getGuild()), "Cannot compare TextChannels that aren't from the same guild!");
        if (this.getPositionRaw() == chan.getPositionRaw()) {
            return Long.compare(this.id, chan.getIdLong());
        }
        return Integer.compare(this.rawPosition, chan.getPositionRaw());
    }

    public TextChannelImpl setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public TextChannelImpl setLastMessageId(long id) {
        this.lastMessageId = id;
        return this;
    }

    public TextChannelImpl setNSFW(boolean nsfw) {
        this.nsfw = nsfw;
        return this;
    }

    private void checkVerification() {
        if (!this.guild.checkVerification()) {
            throw new VerificationLevelException(this.guild.getVerificationLevel());
        }
    }
}

