/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.IPermissionHolder;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.PermOverrideManager;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.utils.MiscUtil;

public class PermissionOverrideImpl
implements PermissionOverride {
    private final long id;
    private final Channel channel;
    private final IPermissionHolder permissionHolder;
    protected final ReentrantLock mngLock = new ReentrantLock();
    protected volatile PermOverrideManager manager;
    private long allow;
    private long deny;

    public PermissionOverrideImpl(Channel channel, long id, IPermissionHolder permissionHolder) {
        this.channel = channel;
        this.id = id;
        this.permissionHolder = permissionHolder;
    }

    @Override
    public long getAllowedRaw() {
        return this.allow;
    }

    @Override
    public long getInheritRaw() {
        return (this.allow | this.deny) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long getDeniedRaw() {
        return this.deny;
    }

    @Override
    public List<Permission> getAllowed() {
        return Collections.unmodifiableList(Permission.getPermissions(this.allow));
    }

    @Override
    public List<Permission> getInherit() {
        return Collections.unmodifiableList(Permission.getPermissions(this.getInheritRaw()));
    }

    @Override
    public List<Permission> getDenied() {
        return Collections.unmodifiableList(Permission.getPermissions(this.deny));
    }

    @Override
    public JDA getJDA() {
        return this.channel.getJDA();
    }

    @Override
    public Member getMember() {
        return this.isMemberOverride() ? (Member)this.permissionHolder : null;
    }

    @Override
    public Role getRole() {
        return this.isRoleOverride() ? (Role)this.permissionHolder : null;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public Guild getGuild() {
        return this.channel.getGuild();
    }

    @Override
    public boolean isMemberOverride() {
        return this.permissionHolder instanceof Member;
    }

    @Override
    public boolean isRoleOverride() {
        return this.permissionHolder instanceof Role;
    }

    @Override
    public PermOverrideManager getManager() {
        PermOverrideManager mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new PermOverrideManager(this);
                }
                return this.manager;
            });
        }
        return mng;
    }

    @Override
    public AuditableRestAction<Void> delete() {
        if (!this.channel.getGuild().getSelfMember().hasPermission(this.channel, Permission.MANAGE_PERMISSIONS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_PERMISSIONS);
        }
        String targetId = this.isRoleOverride() ? this.getRole().getId() : this.getMember().getUser().getId();
        Route.CompiledRoute route = Route.Channels.DELETE_PERM_OVERRIDE.compile(this.channel.getId(), targetId);
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public PermissionOverrideImpl setAllow(long allow) {
        this.allow = allow;
        return this;
    }

    public PermissionOverrideImpl setDeny(long deny) {
        this.deny = deny;
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PermissionOverrideImpl)) {
            return false;
        }
        PermissionOverrideImpl oPerm = (PermissionOverrideImpl)o;
        return this == oPerm || this.permissionHolder.equals(oPerm.permissionHolder) && this.channel.equals(oPerm.channel);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "PermOver:(" + (this.isMemberOverride() ? "M" : "R") + ")(" + this.channel.getId() + " | " + this.id + ")";
    }
}

