/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.entities.impl;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.client.entities.Call;
import net.dv8tion.jda.client.entities.Friend;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.core.utils.cache.impl.SnowflakeCacheViewImpl;

public class GroupImpl
implements Group {
    private final long id;
    private final JDAImpl api;
    private final SnowflakeCacheViewImpl<User> userCache = new SnowflakeCacheViewImpl<User>(User.class, User::getName);
    private Call currentCall;
    private User owner;
    private String name;
    private String iconId;
    private long lastMessageId;

    public GroupImpl(long id, JDAImpl api) {
        this.id = id;
        this.api = api;
    }

    @Override
    public long getLatestMessageIdLong() {
        long messageId = this.lastMessageId;
        if (messageId < 0L) {
            throw new IllegalStateException("No last message id found.");
        }
        return messageId;
    }

    @Override
    public boolean hasLatestMessage() {
        return this.lastMessageId > 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.GROUP;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/channel-icons/" + this.id + "/" + this.iconId + ".jpg";
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    public SnowflakeCacheView<User> getUserCache() {
        return this.userCache;
    }

    @Override
    public List<User> getUsers() {
        return this.userCache.asList();
    }

    @Override
    public List<User> getNonFriendUsers() {
        ArrayList nonFriends = new ArrayList();
        TLongObjectMap<Relationship> map = this.api.asClient().getRelationshipMap();
        this.userCache.forEach(user -> {
            Friend friend;
            Relationship relationship = (Relationship)map.get(user.getIdLong());
            Friend friend2 = friend = relationship instanceof Friend ? (Friend)relationship : null;
            if (friend == null) {
                nonFriends.add(user);
            }
        });
        return Collections.unmodifiableList(nonFriends);
    }

    @Override
    public List<Friend> getFriends() {
        ArrayList friends = new ArrayList();
        TLongObjectMap<Relationship> map = this.api.asClient().getRelationshipMap();
        this.userCache.forEach(user -> {
            Friend friend;
            Relationship relationship = (Relationship)map.get(user.getIdLong());
            Friend friend2 = friend = relationship instanceof Friend ? (Friend)relationship : null;
            if (friend != null) {
                friends.add(friend);
            }
        });
        return Collections.unmodifiableList(friends);
    }

    @Override
    public RestAction<Call> startCall() {
        return null;
    }

    @Override
    public Call getCurrentCall() {
        return this.currentCall;
    }

    @Override
    public RestAction leaveGroup() {
        return null;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    public String toString() {
        return String.format("G:%s(%d)", this.getName(), this.id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GroupImpl)) {
            return false;
        }
        GroupImpl oGroup = (GroupImpl)o;
        return this.id == oGroup.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public TLongObjectMap<User> getUserMap() {
        return this.userCache.getMap();
    }

    public GroupImpl setCurrentCall(Call call) {
        this.currentCall = call;
        return this;
    }

    public GroupImpl setOwner(User owner) {
        this.owner = owner;
        return this;
    }

    public GroupImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GroupImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    public GroupImpl setLastMessageId(long lastMessageId) {
        this.lastMessageId = lastMessageId;
        return this;
    }

    private void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }

    @Override
    public long getIdLong() {
        return this.id;
    }
}

