/*
 *     Copyright 2015-2018 Austin Keener & Michael Ritter & Florian Spieß
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dv8tion.jda.client.events.relationship;

import net.dv8tion.jda.client.entities.OutgoingFriendRequest;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.core.JDA;

public class FriendRequestSentEvent extends GenericRelationshipAddEvent
{
    public FriendRequestSentEvent(JDA api, long responseNumber, Relationship relationship)
    {
        super(api, responseNumber, relationship);
    }

    public OutgoingFriendRequest getFriendRequest()
    {
        return (OutgoingFriendRequest) relationship;
    }
}
