/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils.cache.impl;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.cache.CacheView;
import org.apache.commons.collections4.iterators.ArrayIterator;

public abstract class AbstractCacheView<T>
implements CacheView<T> {
    protected final TLongObjectMap<T> elements = MiscUtil.newLongMap();
    protected final Function<T, String> nameMapper;

    protected AbstractCacheView(Function<T, String> nameMapper) {
        this.nameMapper = nameMapper;
    }

    public void clear() {
        this.elements.clear();
    }

    public TLongObjectMap<T> getMap() {
        return this.elements;
    }

    @Override
    public List<T> asList() {
        ArrayList list = new ArrayList(this.elements.size());
        this.elements.forEachValue(list::add);
        return Collections.unmodifiableList(list);
    }

    @Override
    public Set<T> asSet() {
        HashSet set = new HashSet(this.elements.size());
        this.elements.forEachValue(set::add);
        return Collections.unmodifiableSet(set);
    }

    @Override
    public long size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public List<T> getElementsByName(String name, boolean ignoreCase) {
        Checks.notEmpty(name, "Name");
        if (this.elements.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.nameMapper == null) {
            throw new UnsupportedOperationException("The contained elements are not assigned with names.");
        }
        LinkedList list = new LinkedList();
        for (Object elem : this.elements.valueCollection()) {
            String elementName = this.nameMapper.apply(elem);
            if (elementName == null) continue;
            if (ignoreCase) {
                if (!elementName.equalsIgnoreCase(name)) continue;
                list.add(elem);
                continue;
            }
            if (!elementName.equals(name)) continue;
            list.add(elem);
        }
        return list;
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.elements.values(), 1024);
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new ArrayIterator((Object)this.elements.values());
    }
}

