/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.exceptions.GuildUnavailableException;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.fields.GuildField;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.utils.Checks;
import org.json.JSONObject;

public class GuildManagerUpdatable {
    protected final Guild guild;
    protected GuildField<String> name;
    protected GuildField<Icon> icon;
    protected GuildField<Icon> splash;
    protected GuildField<Region> region;
    protected GuildField<VoiceChannel> afkChannel;
    protected GuildField<TextChannel> systemChannel;
    protected GuildField<Guild.VerificationLevel> verificationLevel;
    protected GuildField<Guild.NotificationLevel> defaultNotificationLevel;
    protected GuildField<Guild.MFALevel> mfaLevel;
    protected GuildField<Guild.ExplicitContentLevel> explicitContentLevel;
    protected GuildField<Guild.Timeout> timeout;

    public GuildManagerUpdatable(Guild guild) {
        this.guild = guild;
        this.setupFields();
    }

    public JDA getJDA() {
        return this.guild.getJDA();
    }

    public Guild getGuild() {
        return this.guild;
    }

    public GuildField<String> getNameField() {
        this.checkAvailable();
        return this.name;
    }

    public GuildField<Region> getRegionField() {
        this.checkAvailable();
        return this.region;
    }

    public GuildField<Icon> getIconField() {
        this.checkAvailable();
        return this.icon;
    }

    public GuildField<Icon> getSplashField() {
        this.checkAvailable();
        return this.splash;
    }

    public GuildField<VoiceChannel> getAfkChannelField() {
        this.checkAvailable();
        return this.afkChannel;
    }

    public GuildField<TextChannel> getSystemChannelField() {
        this.checkAvailable();
        return this.systemChannel;
    }

    public GuildField<Guild.Timeout> getAfkTimeoutField() {
        this.checkAvailable();
        return this.timeout;
    }

    public GuildField<Guild.VerificationLevel> getVerificationLevelField() {
        this.checkAvailable();
        return this.verificationLevel;
    }

    public GuildField<Guild.NotificationLevel> getDefaultNotificationLevelField() {
        this.checkAvailable();
        return this.defaultNotificationLevel;
    }

    public GuildField<Guild.MFALevel> getRequiredMFALevelField() {
        this.checkAvailable();
        return this.mfaLevel;
    }

    public GuildField<Guild.ExplicitContentLevel> getExplicitContentLevelField() {
        this.checkAvailable();
        return this.explicitContentLevel;
    }

    public void reset() {
        this.name.reset();
        this.region.reset();
        this.timeout.reset();
        this.icon.reset();
        this.splash.reset();
        this.afkChannel.reset();
        this.systemChannel.reset();
        this.verificationLevel.reset();
        this.defaultNotificationLevel.reset();
        this.mfaLevel.reset();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> update() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_SERVER);
        if (!this.needToUpdate()) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject().put("name", (Object)this.guild.getName());
        if (this.name.shouldUpdate()) {
            body.put("name", this.name.getValue());
        }
        if (this.region.shouldUpdate()) {
            body.put("region", (Object)((Region)((Object)this.region.getValue())).getKey());
        }
        if (this.timeout.shouldUpdate()) {
            body.put("afk_timeout", ((Guild.Timeout)((Object)this.timeout.getValue())).getSeconds());
        }
        if (this.icon.shouldUpdate()) {
            body.put("icon", this.icon.getValue() == null ? JSONObject.NULL : ((Icon)this.icon.getValue()).getEncoding());
        }
        if (this.splash.shouldUpdate()) {
            body.put("splash", this.splash.getValue() == null ? JSONObject.NULL : ((Icon)this.splash.getValue()).getEncoding());
        }
        if (this.afkChannel.shouldUpdate()) {
            body.put("afk_channel_id", this.afkChannel.getValue() == null ? JSONObject.NULL : ((VoiceChannel)this.afkChannel.getValue()).getId());
        }
        if (this.systemChannel.shouldUpdate()) {
            body.put("system_channel_id", this.systemChannel.getValue() == null ? JSONObject.NULL : ((TextChannel)this.systemChannel.getValue()).getId());
        }
        if (this.verificationLevel.shouldUpdate()) {
            body.put("verification_level", ((Guild.VerificationLevel)((Object)this.verificationLevel.getValue())).getKey());
        }
        if (this.defaultNotificationLevel.shouldUpdate()) {
            body.put("default_notification_level", ((Guild.NotificationLevel)((Object)this.defaultNotificationLevel.getValue())).getKey());
        }
        if (this.mfaLevel.shouldUpdate()) {
            body.put("mfa_level", ((Guild.MFALevel)((Object)this.mfaLevel.getValue())).getKey());
        }
        if (this.explicitContentLevel.shouldUpdate()) {
            body.put("explicit_content_filter", ((Guild.ExplicitContentLevel)((Object)this.explicitContentLevel.getValue())).getKey());
        }
        this.reset();
        Route.CompiledRoute route = Route.Guilds.MODIFY_GUILD.compile(this.guild.getId());
        return new AuditableRestAction<Void>(this.guild.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    protected boolean needToUpdate() {
        return this.name.shouldUpdate() || this.region.shouldUpdate() || this.timeout.shouldUpdate() || this.icon.shouldUpdate() || this.splash.shouldUpdate() || this.afkChannel.shouldUpdate() || this.systemChannel.shouldUpdate() || this.verificationLevel.shouldUpdate() || this.defaultNotificationLevel.shouldUpdate() || this.mfaLevel.shouldUpdate() || this.explicitContentLevel.shouldUpdate();
    }

    protected void checkAvailable() {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
    }

    protected void checkPermission(Permission perm) {
        if (!this.guild.getSelfMember().hasPermission(perm)) {
            throw new InsufficientPermissionException(perm);
        }
    }

    protected void setupFields() {
        this.name = new GuildField<String>(this, this.guild::getName){

            @Override
            public void checkValue(String value) {
                Checks.notNull(value, "guild name");
                if (value.length() < 2 || value.length() > 100) {
                    throw new IllegalArgumentException("Provided guild name must be 2 to 100 characters in length");
                }
            }
        };
        this.timeout = new GuildField<Guild.Timeout>(this, this.guild::getAfkTimeout){

            @Override
            public void checkValue(Guild.Timeout value) {
                Checks.notNull((Object)value, "Timeout");
            }
        };
        this.icon = new GuildField<Icon>(this, null){

            @Override
            public void checkValue(Icon value) {
            }

            @Override
            public Icon getOriginalValue() {
                throw new UnsupportedOperationException("Cannot easily provide the original Icon. Use Guild#getIconUrl() and download it yourself.");
            }

            @Override
            public boolean shouldUpdate() {
                return this.isSet();
            }
        };
        this.splash = new GuildField<Icon>(this, null){

            @Override
            public void checkValue(Icon value) {
            }

            @Override
            public Icon getOriginalValue() {
                throw new UnsupportedOperationException("Cannot easily provide the original Splash. Use Guild#getSplashUrl() and download it yourself.");
            }

            @Override
            public boolean shouldUpdate() {
                return this.isSet();
            }
        };
        this.region = new GuildField<Region>(this, this.guild::getRegion){

            @Override
            public void checkValue(Region value) {
                Checks.notNull((Object)value, "Region");
                if (value == Region.UNKNOWN) {
                    throw new IllegalArgumentException("Cannot set Guild Region to UNKNOWN!");
                }
                if (value.isVip() && !GuildManagerUpdatable.this.guild.getFeatures().contains("VIP_REGIONS")) {
                    throw new IllegalArgumentException("VIP regions are not supported by this Guild");
                }
            }
        };
        this.afkChannel = new GuildField<VoiceChannel>(this, this.guild::getAfkChannel){

            @Override
            public void checkValue(VoiceChannel value) {
                if (value != null && !GuildManagerUpdatable.this.guild.equals(value.getGuild())) {
                    throw new IllegalArgumentException("Provided AFK Channel is not from this Guild!");
                }
            }
        };
        this.systemChannel = new GuildField<TextChannel>(this, this.guild::getSystemChannel){

            @Override
            public void checkValue(TextChannel value) {
                if (value != null && !GuildManagerUpdatable.this.guild.equals(value.getGuild())) {
                    throw new IllegalArgumentException("Provided system channel is not from this Guild!");
                }
            }
        };
        this.verificationLevel = new GuildField<Guild.VerificationLevel>(this, this.guild::getVerificationLevel){

            @Override
            public void checkValue(Guild.VerificationLevel value) {
                Checks.notNull((Object)value, "VerificationLevel");
                if (value == Guild.VerificationLevel.UNKNOWN) {
                    throw new IllegalArgumentException("Cannot set Guild VerificationLevel to UNKNOWN");
                }
            }
        };
        this.defaultNotificationLevel = new GuildField<Guild.NotificationLevel>(this, this.guild::getDefaultNotificationLevel){

            @Override
            public void checkValue(Guild.NotificationLevel value) {
                Checks.notNull((Object)value, "NotificationLevel");
                if (value == Guild.NotificationLevel.UNKNOWN) {
                    throw new IllegalArgumentException("Cannot set NotificationLevel to UNKNOWN");
                }
            }
        };
        this.mfaLevel = new GuildField<Guild.MFALevel>(this, this.guild::getRequiredMFALevel){

            @Override
            public void checkValue(Guild.MFALevel value) {
                Checks.notNull((Object)value, "MFALevel");
                if (value == Guild.MFALevel.UNKNOWN) {
                    throw new IllegalArgumentException("Cannot set MFALevel to UNKNOWN");
                }
            }
        };
        this.explicitContentLevel = new GuildField<Guild.ExplicitContentLevel>(this, this.guild::getExplicitContentLevel){

            @Override
            public void checkValue(Guild.ExplicitContentLevel value) {
                Checks.notNull((Object)value, "ExplicitContentLevel");
                Checks.check(value != Guild.ExplicitContentLevel.UNKNOWN, "Cannot set ExplicitContentLevel to UNKNOWN");
            }
        };
    }
}

