/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.guild.GuildBanEvent;
import net.dv8tion.jda.core.events.guild.GuildUnbanEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.utils.JDALogger;
import org.json.JSONObject;

public class GuildBanHandler
extends SocketHandler {
    private final boolean banned;

    public GuildBanHandler(JDAImpl api, boolean banned) {
        super(api);
        this.banned = banned;
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("guild_id");
        if (this.api.getGuildLock().isLocked(id)) {
            return id;
        }
        JSONObject userJson = content.getJSONObject("user");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(id);
        if (guild == null) {
            this.api.getEventCache().cache(EventCache.Type.GUILD, id, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received Guild Member {} event for a Guild not yet cached.", JDALogger.getLazyString(() -> this.banned ? "Ban" : "Unban"));
            return null;
        }
        User user = this.api.getEntityBuilder().createFakeUser(userJson, false);
        if (this.banned) {
            this.api.getEventManager().handle(new GuildBanEvent(this.api, this.responseNumber, guild, user));
        } else {
            this.api.getEventManager().handle(new GuildUnbanEvent(this.api, this.responseNumber, guild, user));
        }
        return null;
    }
}

