/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.events.group.GroupJoinEvent;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.channel.category.CategoryCreateEvent;
import net.dv8tion.jda.core.events.channel.priv.PrivateChannelCreateEvent;
import net.dv8tion.jda.core.events.channel.text.TextChannelCreateEvent;
import net.dv8tion.jda.core.events.channel.voice.VoiceChannelCreateEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class ChannelCreateHandler
extends SocketHandler {
    public ChannelCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        long guildId = 0L;
        if (type.isGuild()) {
            guildId = content.getLong("guild_id");
            if (this.api.getGuildLock().isLocked(guildId)) {
                return guildId;
            }
        }
        switch (type) {
            case TEXT: {
                this.api.getEventManager().handle(new TextChannelCreateEvent(this.api, this.responseNumber, this.api.getEntityBuilder().createTextChannel(content, guildId)));
                break;
            }
            case VOICE: {
                this.api.getEventManager().handle(new VoiceChannelCreateEvent(this.api, this.responseNumber, this.api.getEntityBuilder().createVoiceChannel(content, guildId)));
                break;
            }
            case CATEGORY: {
                this.api.getEventManager().handle(new CategoryCreateEvent(this.api, this.responseNumber, this.api.getEntityBuilder().createCategory(content, guildId)));
                break;
            }
            case PRIVATE: {
                this.api.getEventManager().handle(new PrivateChannelCreateEvent(this.api, this.responseNumber, this.api.getEntityBuilder().createPrivateChannel(content)));
                break;
            }
            case GROUP: {
                this.api.getEventManager().handle(new GroupJoinEvent(this.api, this.responseNumber, this.api.getEntityBuilder().createGroup(content)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Discord provided an CREATE_CHANNEL event with an unknown channel type! JSON: " + content);
            }
        }
        this.api.getEventCache().playbackCache(EventCache.Type.CHANNEL, content.getLong("id"));
        return null;
    }
}

