/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.utils.Checks;

public class RichPresence
extends Game {
    protected final long applicationId;
    protected final Party party;
    protected final String details;
    protected final String state;
    protected final Timestamps timestamps;
    protected final Image largeImage;
    protected final Image smallImage;

    protected RichPresence(Game.GameType type, String name, String url, long applicationId, Party party, String details, String state, Timestamps timestamps, String largeImageKey, String largeImageText, String smallImageKey, String smallImageText) {
        super(name, url, type);
        this.applicationId = applicationId;
        this.party = party;
        this.details = details;
        this.state = state;
        this.timestamps = timestamps;
        this.largeImage = largeImageKey != null ? new Image(largeImageKey, largeImageText) : null;
        this.smallImage = smallImageKey != null ? new Image(smallImageKey, smallImageText) : null;
    }

    @Override
    public boolean isRich() {
        return true;
    }

    @Override
    public RichPresence asRichPresence() {
        return this;
    }

    public long getApplicationIdLong() {
        return this.applicationId;
    }

    @Nonnull
    public String getApplicationId() {
        return Long.toUnsignedString(this.applicationId);
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nullable
    public String getDetails() {
        return this.details;
    }

    @Nullable
    public Party getParty() {
        return this.party;
    }

    @Nullable
    public Timestamps getTimestamps() {
        return this.timestamps;
    }

    @Nullable
    public Image getLargeImage() {
        return this.largeImage;
    }

    @Nullable
    public Image getSmallImage() {
        return this.smallImage;
    }

    @Override
    public String toString() {
        return String.format("RichPresence(%s / %s)", this.name, this.getApplicationId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.applicationId, this.state, this.details, this.party, this.timestamps, this.largeImage, this.smallImage);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RichPresence)) {
            return false;
        }
        RichPresence p = (RichPresence)o;
        return this.applicationId == p.applicationId && Objects.equals(this.name, p.name) && Objects.equals(this.url, p.url) && Objects.equals((Object)this.type, (Object)p.type) && Objects.equals(this.state, p.state) && Objects.equals(this.details, p.details) && Objects.equals(this.party, p.party) && Objects.equals(this.timestamps, p.timestamps) && Objects.equals(this.largeImage, p.largeImage) && Objects.equals(this.smallImage, p.smallImage);
    }

    public static class Party {
        protected final String id;
        protected final long size;
        protected final long max;

        public Party(String id, long size, long max) {
            this.id = id;
            this.size = size;
            this.max = max;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public int getSize() {
            return (int)this.size;
        }

        public long getSizeAsLong() {
            return this.size;
        }

        public int getMax() {
            return (int)this.max;
        }

        public long getMaxAsLong() {
            return this.max;
        }

        public String toString() {
            return String.format("RichPresenceParty(%s | [%d, %d])", this.id, this.size, this.max);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Party)) {
                return false;
            }
            Party p = (Party)obj;
            return this.size == p.size && this.max == p.max && Objects.equals(this.id, p.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.size, this.max);
        }
    }

    public static class Timestamps {
        protected final long start;
        protected final long end;

        public Timestamps(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        @Nullable
        public Instant getStartTime() {
            return this.start <= 0L ? null : Instant.ofEpochMilli(this.start);
        }

        public long getEnd() {
            return this.end;
        }

        @Nullable
        public Instant getEndTime() {
            return this.end <= 0L ? null : Instant.ofEpochMilli(this.end);
        }

        public long getRemainingTime(TemporalUnit unit) {
            Checks.notNull(unit, "TemporalUnit");
            Instant end = this.getEndTime();
            return end != null ? Instant.now().until(end, unit) : -1L;
        }

        public long getElapsedTime(TemporalUnit unit) {
            Checks.notNull(unit, "TemporalUnit");
            Instant start = this.getStartTime();
            return start != null ? start.until(Instant.now(), unit) : -1L;
        }

        public String toString() {
            return String.format("RichPresenceTimestamp(%d-%d)", this.start, this.end);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Timestamps)) {
                return false;
            }
            Timestamps t = (Timestamps)obj;
            return this.start == t.start && this.end == t.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }
    }

    public class Image {
        protected final String key;
        protected final String text;

        public Image(String key, String text) {
            this.key = key;
            this.text = text;
        }

        @Nonnull
        public String getKey() {
            return this.key;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @Nonnull
        public String getUrl() {
            return "https://cdn.discordapp.com/app-assets/" + RichPresence.this.applicationId + "/" + this.key + ".png";
        }

        public String toString() {
            return String.format("RichPresenceImage(%s | %s)", this.key, this.text);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Image)) {
                return false;
            }
            Image i = (Image)obj;
            return Objects.equals(this.key, i.key) && Objects.equals(this.text, i.text);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.text);
        }
    }
}

