/*
 * Decompiled with CFR 0.152.
 */
package net.droidlabs.mvvm.recyclerview.adapter;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ObservableArrayList;
import android.databinding.ObservableList;
import android.databinding.ViewDataBinding;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import java.lang.ref.WeakReference;
import java.util.Collection;
import net.droidlabs.mvvm.recyclerview.adapter.binder.ItemBinder;

public class BindingRecyclerViewAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    private final WeakReferenceOnListChangedCallback onListChangedCallback;
    private final ItemBinder<T> itemBinder;
    private ObservableList<T> items;
    private LayoutInflater inflater;

    public BindingRecyclerViewAdapter(ItemBinder<T> itemBinder, @Nullable Collection<T> items) {
        this.itemBinder = itemBinder;
        this.onListChangedCallback = new WeakReferenceOnListChangedCallback(this);
        this.setItems(items);
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    public void setItems(@Nullable Collection<T> items) {
        if (this.items == items) {
            return;
        }
        if (this.items != null) {
            this.items.removeOnListChangedCallback((ObservableList.OnListChangedCallback)this.onListChangedCallback);
            this.notifyItemRangeRemoved(0, this.items.size());
        }
        if (items instanceof ObservableList) {
            this.items = (ObservableList)items;
            this.notifyItemRangeInserted(0, this.items.size());
            this.items.addOnListChangedCallback((ObservableList.OnListChangedCallback)this.onListChangedCallback);
        } else if (items != null) {
            this.items = new ObservableArrayList();
            this.items.addOnListChangedCallback((ObservableList.OnListChangedCallback)this.onListChangedCallback);
            this.items.addAll(items);
        } else {
            this.items = null;
        }
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        if (this.items != null) {
            this.items.removeOnListChangedCallback((ObservableList.OnListChangedCallback)this.onListChangedCallback);
        }
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int layoutId) {
        if (this.inflater == null) {
            this.inflater = LayoutInflater.from((Context)viewGroup.getContext());
        }
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)this.inflater, (int)layoutId, (ViewGroup)viewGroup, (boolean)false);
        return new ViewHolder(binding);
    }

    public void onBindViewHolder(ViewHolder viewHolder, int position) {
        Object item = this.items.get(position);
        viewHolder.binding.setVariable(this.itemBinder.getBindingVariable(item), item);
        viewHolder.binding.executePendingBindings();
    }

    public int getItemViewType(int position) {
        return this.itemBinder.getLayoutRes(this.items.get(position));
    }

    public int getItemCount() {
        return this.items == null ? 0 : this.items.size();
    }

    private static class WeakReferenceOnListChangedCallback<T>
    extends ObservableList.OnListChangedCallback {
        private final WeakReference<BindingRecyclerViewAdapter<T>> adapterReference;

        public WeakReferenceOnListChangedCallback(BindingRecyclerViewAdapter<T> bindingRecyclerViewAdapter) {
            this.adapterReference = new WeakReference<BindingRecyclerViewAdapter<BindingRecyclerViewAdapter<T>>>(bindingRecyclerViewAdapter);
        }

        public void onChanged(ObservableList sender) {
            RecyclerView.Adapter adapter = (RecyclerView.Adapter)this.adapterReference.get();
            if (adapter != null) {
                adapter.notifyDataSetChanged();
            }
        }

        public void onItemRangeChanged(ObservableList sender, int positionStart, int itemCount) {
            RecyclerView.Adapter adapter = (RecyclerView.Adapter)this.adapterReference.get();
            if (adapter != null) {
                adapter.notifyItemRangeChanged(positionStart, itemCount);
            }
        }

        public void onItemRangeInserted(ObservableList sender, int positionStart, int itemCount) {
            RecyclerView.Adapter adapter = (RecyclerView.Adapter)this.adapterReference.get();
            if (adapter != null) {
                adapter.notifyItemRangeInserted(positionStart, itemCount);
            }
        }

        public void onItemRangeMoved(ObservableList sender, int fromPosition, int toPosition, int itemCount) {
            RecyclerView.Adapter adapter = (RecyclerView.Adapter)this.adapterReference.get();
            if (adapter != null) {
                adapter.notifyItemMoved(fromPosition, toPosition);
            }
        }

        public void onItemRangeRemoved(ObservableList sender, int positionStart, int itemCount) {
            RecyclerView.Adapter adapter = (RecyclerView.Adapter)this.adapterReference.get();
            if (adapter != null) {
                adapter.notifyItemRangeRemoved(positionStart, itemCount);
            }
        }
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        final ViewDataBinding binding;

        ViewHolder(ViewDataBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }
    }
}

