/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.JsonUtil;
import net.dreamlu.mica.http.HttpException;
import net.dreamlu.mica.http.HttpResponse;
import net.dreamlu.mica.http.ResponseSpec;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;

public class Exchange {
    private final Call call;
    @Nullable
    private BiConsumer<Request, HttpException> failedBiConsumer;

    public Exchange(Call call) {
        this.call = call;
        this.failedBiConsumer = null;
    }

    public Exchange onFailed(BiConsumer<Request, HttpException> failConsumer) {
        this.failedBiConsumer = failConsumer;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R onResponse(Function<ResponseSpec, R> func) {
        try (HttpResponse response = new HttpResponse(this.call.execute());){
            R r = func.apply(response);
            return r;
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <R> R onSuccess(Function<ResponseSpec, R> func) {
        try (HttpResponse response = new HttpResponse(this.call.execute());){
            R r = func.apply(response);
            return r;
        }
        catch (IOException e) {
            this.onFailure(this.call.request(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <R> R onSuccessful(Function<ResponseSpec, R> func) {
        try (HttpResponse response = new HttpResponse(this.call.execute());){
            if (response.isOk()) {
                R r = func.apply(response);
                return r;
            }
            this.onFailure(response);
            return null;
        }
        catch (IOException e) {
            this.onFailure(this.call.request(), e);
        }
        return null;
    }

    public <R> Optional<R> onSuccessOpt(Function<ResponseSpec, R> func) {
        return Optional.ofNullable(this.onSuccess(func));
    }

    public <R> Optional<R> onSuccessfulOpt(Function<ResponseSpec, R> func) {
        return Optional.ofNullable(this.onSuccessful(func));
    }

    public Response response() {
        return this.onResponse(ResponseSpec::rawResponse);
    }

    public String asString() {
        return this.onResponse(ResponseSpec::asString);
    }

    public String asString(Charset charset) {
        return this.onResponse(responseSpec -> responseSpec.asString(charset));
    }

    public byte[] asBytes() {
        return this.onResponse(ResponseSpec::asBytes);
    }

    public JsonNode asJsonNode() {
        return this.onResponse(ResponseSpec::asJsonNode);
    }

    public JsonNode atJsonPath(String jsonPtrExpr) {
        return this.asJsonNode().at(jsonPtrExpr);
    }

    public <T> T atJsonPathValue(String jsonPtrExpr, Class<T> valueType) {
        return (T)JsonUtil.convertValue((Object)this.atJsonPath(jsonPtrExpr), valueType);
    }

    public <T> T asValue(Class<T> valueType) {
        return (T)this.onResponse(responseSpec -> responseSpec.asValue(valueType));
    }

    public <T> T asValue(TypeReference<T> typeReference) {
        return (T)this.onResponse(responseSpec -> responseSpec.asValue(typeReference));
    }

    public <T> List<T> asList(Class<T> valueType) {
        return this.onResponse(responseSpec -> responseSpec.asList(valueType));
    }

    public <K, V> Map<K, V> asMap(Class<?> keyClass, Class<?> valueType) {
        return this.onResponse(responseSpec -> responseSpec.asMap(keyClass, valueType));
    }

    public <V> Map<String, V> asMap(Class<?> valueType) {
        return this.onResponse(responseSpec -> responseSpec.asMap(valueType));
    }

    public File toFile(File file) {
        return this.onResponse(responseSpec -> responseSpec.toFile(file));
    }

    public Path toFile(Path path) {
        return this.onResponse(responseSpec -> responseSpec.toFile(path));
    }

    private void onFailure(Request request, IOException e) {
        if (this.failedBiConsumer != null) {
            this.failedBiConsumer.accept(request, new HttpException(request, (Throwable)e));
        }
    }

    private void onFailure(HttpResponse response) {
        if (this.failedBiConsumer != null) {
            this.failedBiConsumer.accept(response.rawRequest(), new HttpException(response));
        }
    }
}

