/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.http.AsyncExchange;
import net.dreamlu.mica.http.Exchange;
import net.dreamlu.mica.http.HttpRequest;
import okhttp3.Headers;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Buffer;

public class MultipartFormBuilder {
    private final HttpRequest request;
    private final MultipartBody.Builder formBuilder;

    MultipartFormBuilder(HttpRequest request) {
        this.request = request;
        this.formBuilder = new MultipartBody.Builder();
    }

    public MultipartFormBuilder add(String name, @Nullable Object value) {
        this.formBuilder.addFormDataPart(name, HttpRequest.handleValue(value));
        return this;
    }

    public MultipartFormBuilder addMap(@Nullable Map<String, Object> formMap) {
        if (formMap != null && !formMap.isEmpty()) {
            formMap.forEach(this::add);
        }
        return this;
    }

    public MultipartFormBuilder add(String name, File file) {
        String fileName = file.getName();
        return this.add(name, fileName, file);
    }

    public MultipartFormBuilder add(String name, @Nullable String filename, File file) {
        RequestBody fileBody = RequestBody.create(null, (File)file);
        return this.add(name, filename, fileBody);
    }

    public MultipartFormBuilder add(String name, @Nonnull String filename, byte[] bytes) {
        RequestBody fileBody = RequestBody.create(null, (byte[])bytes);
        return this.add(name, filename, fileBody);
    }

    public MultipartFormBuilder add(String name, @Nonnull String filename, InputStream stream) {
        try {
            MultipartFormBuilder multipartFormBuilder;
            Buffer buffer = new Buffer();
            try {
                buffer.readFrom(stream);
                multipartFormBuilder = this.add(name, filename, buffer.readByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        buffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Exceptions.unchecked((Throwable)e);
                }
            }
            buffer.close();
            return multipartFormBuilder;
        }
        finally {
            Util.closeQuietly((Closeable)stream);
        }
    }

    public MultipartFormBuilder add(String name, @Nullable String filename, RequestBody fileBody) {
        this.formBuilder.addFormDataPart(name, filename, fileBody);
        return this;
    }

    public MultipartFormBuilder add(RequestBody body) {
        this.formBuilder.addPart(body);
        return this;
    }

    public MultipartFormBuilder add(@Nullable Headers headers, RequestBody body) {
        this.formBuilder.addPart(headers, body);
        return this;
    }

    public MultipartFormBuilder add(MultipartBody.Part part) {
        this.formBuilder.addPart(part);
        return this;
    }

    public HttpRequest build() {
        this.formBuilder.setType(MultipartBody.FORM);
        MultipartBody formBody = this.formBuilder.build();
        this.request.multipartForm(formBody);
        return this.request;
    }

    public Exchange execute() {
        return this.build().execute();
    }

    public AsyncExchange async() {
        return this.build().async();
    }
}

